/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.farm.bean.CropCase;
import com.farm.bean.CropManage;
import com.farm.mapper.CropManageMapper;
import com.farm.service.CropManageService;
import java.util.List;
import javax.annotation.Resource;
import net.sf.json.JSONObject;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CropManageServiceImpl
implements CropManageService {
    @Resource
    private CropManageMapper cropManageMapper;

    @Transactional(propagation=Propagation.REQUIRED)
    public Integer saveCropManage(CropManage cropManage) {
        int count = 0;
        do {
            int n;
            Integer num;
            if ((num = this.cropManageMapper.queryNumByParentId(cropManage.getParentId(), cropManage.getCompanyId())) == null) {
                n = 1;
            } else {
                num = num + 1;
                n = num;
            }
            cropManage.setNum(Integer.valueOf(n));
            if (cropManage.getNum() < 10 || cropManage.getDataType() == 3 && cropManage.getNum() < 100) {
                if (cropManage.getDataType() == 3 && cropManage.getNum() < 100) {
                    cropManage.setCropNum(cropManage.getParentCropNum() + "00" + cropManage.getNum());
                } else {
                    cropManage.setCropNum(cropManage.getParentCropNum() + "0" + cropManage.getNum());
                }
            } else {
                cropManage.setCropNum(cropManage.getParentCropNum() + cropManage.getNum());
            }
            cropManage.setCompanyCropNum(cropManage.getCompanyId() + "_" + cropManage.getCropNum());
            Integer numCount = this.cropManageMapper.queryCompanyCropNumCount(cropManage.getCompanyCropNum());
            if (numCount > 0) continue;
            try {
                count = this.cropManageMapper.saveCropManage(cropManage);
            }
            catch (DuplicateKeyException duplicateKeyException) {
                count = 0;
            }
        } while (count == 0);
        return 1;
    }

    public List<CropManage> queryCropManageList(CropCase cropCase) {
        if (cropCase.getCropType() != null && cropCase.getCropType() == 2) {
            return this.cropManageMapper.queryCropManageListAll(cropCase);
        }
        return this.cropManageMapper.queryCropManageList(cropCase);
    }

    public List<CropManage> queryCropManageByParentId(Integer companyId, Integer id) {
        return this.cropManageMapper.queryCropManageByParentId(companyId, id);
    }

    public Integer updateCropManage(String name, Integer isDelete, Integer id) {
        Integer count;
        if (isDelete != null && isDelete == 2 && (count = this.cropManageMapper.queryNodeCountById(id)) > 0) {
            return -1;
        }
        return this.cropManageMapper.updateCropManage(name, isDelete, id);
    }

    public JSONObject queryCropManageParentName(Integer id) {
        JSONObject json = new JSONObject();
        String cropNames = this.cropManageMapper.queryCropManageParentName(id);
        if (cropNames != null && !cropNames.isEmpty()) {
            String[] split = cropNames.split(",");
            if (split.length > 0) {
                json.put((Object)"cropName", (Object)split[0]);
                json.put((Object)"breedName", (Object)split[1]);
            }
        } else {
            json.put((Object)"cropName", (Object)"");
            json.put((Object)"breedName", (Object)"");
        }
        return json;
    }
}

