/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.farm.bean.DepotCapacityStatisticsExport;
import com.farm.bean.DepotCapacityStatisticsMap;
import com.farm.bean.DepotInfo;
import com.farm.bean.DepotStorage;
import com.farm.bean.DepotStorageDetailExport;
import com.farm.bean.DepotStorageStatisticsExport;
import com.farm.mapper.DepotDataStatisticsMapper;
import com.farm.mapper.DepotInfoMapper;
import com.farm.mapper.DepotStorageMapper;
import com.farm.service.DepotDataStatisticsService;
import com.farm.service.DepotInfoService;
import com.farm.util.BaseMail;
import com.farm.util.DateTimeUtil;
import com.farm.util.EasyExcelUtil;
import com.farm.util.ParamAESUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="depotDataStatisticsService")
public class DepotDataStatisticsServiceImpl
implements DepotDataStatisticsService {
    @Autowired
    private BaseMail mailService;
    @Autowired
    private DepotDataStatisticsMapper depotDataStatisticsMapper;
    @Autowired
    private DepotInfoMapper depotInfoMapper;
    @Autowired
    private DepotInfoService depotInfoService;
    @Autowired
    private DepotStorageMapper depotStorageMapper;

    public DepotCapacityStatisticsMap queryDepotStatisticsRealTime(Integer depotId, String userId) {
        return this.depotDataStatisticsMapper.queryDepotStatisticsRealTime(depotId, ParamAESUtil.dealStr((String)userId, (int)2));
    }

    public List<DepotCapacityStatisticsMap> queryDepotCapacityStatistics(Integer timeType, String time, Integer nowSort, Integer totalSort, Integer depotId, String userId, String town, String name) {
        List depotInfoIdList = new ArrayList<Integer>();
        if (depotId != null) {
            depotInfoIdList.add(depotId);
        } else {
            depotInfoIdList = this.getDepotInfoIdListByUserId(userId);
        }
        if (depotInfoIdList.size() < 1) {
            return null;
        }
        List<Object> depotCapacityStatisticsMapList = new ArrayList<DepotCapacityStatisticsMap>();
        if (timeType == 1) {
            for (int i = 1; i < 13; ++i) {
                String monthStartTime = time + "-" + i + "-01";
                String monthEndTime = DateTimeUtil.getMonthEndTime((String)(time + "-" + i));
                DepotCapacityStatisticsMap depotCapacityStatisticsMap = this.depotDataStatisticsMapper.queryDepotCapacityStatisticsByYear(depotInfoIdList, monthEndTime, nowSort, totalSort, town, name, monthStartTime);
                if (depotCapacityStatisticsMap == null) continue;
                depotCapacityStatisticsMapList.add(depotCapacityStatisticsMap);
            }
        } else {
            depotCapacityStatisticsMapList = this.depotDataStatisticsMapper.queryDepotCapacityStatisticsByMouth(depotInfoIdList, time, nowSort, totalSort, town, name);
        }
        return depotCapacityStatisticsMapList;
    }

    public JSONObject queryDepotCapacityStatisticsList(Integer timeType, String time, Integer nowSort, Integer totalSort, String userId, Integer start, Integer pageSize) {
        JSONObject jsonObject = new JSONObject();
        List depotInfoIdList = this.getDepotInfoIdListByUserId(userId);
        if (depotInfoIdList.size() < 1) {
            return null;
        }
        List allDepotInfoList = this.depotInfoMapper.queryDepotInfoListByIdList(depotInfoIdList);
        List depotInfoList = this.getDepotInfos(timeType, time, nowSort, totalSort, start, pageSize, allDepotInfoList);
        jsonObject.put((Object)"count", (Object)allDepotInfoList.size());
        jsonObject.put((Object)"list", (Object)depotInfoList);
        return jsonObject;
    }

    public void exportDepotCapacityStatisticsList(HttpServletResponse response, Integer timeType, String time, String email, Integer depotId, Integer nowSort, Integer totalSort, String userId) throws IOException {
        if (depotId != null) {
            List depotCapacityStatisticsMapList = this.queryDepotCapacityStatistics(timeType, time, nowSort, totalSort, depotId, userId, "", null);
            for (int i = 0; i < depotCapacityStatisticsMapList.size(); ++i) {
                ((DepotCapacityStatisticsMap)depotCapacityStatisticsMapList.get(i)).setIndex(Integer.valueOf(i + 1));
            }
            if (!email.equals("")) {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream(1000);
                EasyExcelUtil.sendEmail((ByteArrayOutputStream)outputStream, DepotCapacityStatisticsMap.class, (String)"\u5e93\u5bb9\u7edf\u8ba1", (List)depotCapacityStatisticsMapList);
                this.mailService.sendMsgAndFile(email, "\u5e93\u5bb9\u7edf\u8ba1", "\u5e93\u5bb9\u7edf\u8ba1", "\u5e93\u5bb9\u7edf\u8ba1.xlsx", outputStream.toByteArray());
            } else {
                EasyExcelUtil.generateFixedHeadFile((HttpServletResponse)response, (String)"\u5e93\u5bb9\u7edf\u8ba1", DepotCapacityStatisticsMap.class, (String)"\u5e93\u5bb9\u7edf\u8ba1", (List)depotCapacityStatisticsMapList);
            }
        } else {
            List depotInfoIdList = this.getDepotInfoIdListByUserId(userId);
            ArrayList<DepotCapacityStatisticsExport> exportList = new ArrayList<DepotCapacityStatisticsExport>();
            if (depotInfoIdList.size() > 0) {
                List allDepotInfoList = this.depotInfoMapper.queryDepotInfoListByIdList(depotInfoIdList);
                List depotInfoList = this.getDepotInfos(timeType, time, nowSort, totalSort, null, null, allDepotInfoList);
                for (int i = 0; i < depotInfoList.size(); ++i) {
                    exportList.add(DepotCapacityStatisticsExport.generateExport((DepotInfo)((DepotInfo)depotInfoList.get(i)), (Integer)(i + 1), (String)time));
                }
            }
            if (!email.equals("")) {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream(1000);
                EasyExcelUtil.sendEmail((ByteArrayOutputStream)outputStream, DepotCapacityStatisticsExport.class, (String)"\u5e93\u5bb9\u7edf\u8ba1", exportList);
                this.mailService.sendMsgAndFile(email, "\u5e93\u5bb9\u7edf\u8ba1", "\u5e93\u5bb9\u7edf\u8ba1", "\u5e93\u5bb9\u7edf\u8ba1.xlsx", outputStream.toByteArray());
            } else {
                EasyExcelUtil.generateFixedHeadFile((HttpServletResponse)response, (String)"\u5e93\u5bb9\u7edf\u8ba1", DepotCapacityStatisticsExport.class, (String)"\u5e93\u5bb9\u7edf\u8ba1", exportList);
            }
        }
    }

    private List<DepotInfo> getDepotInfos(Integer timeType, String time, Integer nowSort, Integer totalSort, Integer start, Integer pageSize, List<DepotInfo> allDepotInfoList) {
        List depotInfoList;
        List depotInfoIdList = allDepotInfoList.stream().map(DepotInfo::getId).collect(Collectors.toList());
        String nowDate = timeType == 1 ? new SimpleDateFormat("yyyy").format(new Date()) : new SimpleDateFormat("yyyy-MM").format(new Date());
        if (time.equals(nowDate)) {
            depotInfoList = this.depotInfoMapper.queryDepotInfoListByStatistics(nowSort, totalSort, start, pageSize);
        } else if (timeType == 1) {
            depotInfoList = this.depotInfoMapper.queryDepotStatisticsInfoListByTimeAndId(nowSort, totalSort, depotInfoIdList, time + "-12-31", start, pageSize);
        } else {
            String monthEndTime = DateTimeUtil.getMonthEndTime((String)time);
            depotInfoList = this.depotInfoMapper.queryDepotStatisticsInfoListByTimeAndId(nowSort, totalSort, depotInfoIdList, monthEndTime, start, pageSize);
        }
        return depotInfoList;
    }

    public List<DepotCapacityStatisticsMap> queryDepotStorageStatistics(Integer timeType, String time, Integer depotId, String town, String userId, String name) {
        List depotInfoIdList = new ArrayList<Integer>();
        if (depotId != null) {
            depotInfoIdList.add(depotId);
        } else {
            depotInfoIdList = this.getDepotInfoIdListByUserId(userId);
        }
        if (depotInfoIdList.size() < 1) {
            return null;
        }
        ArrayList<DepotCapacityStatisticsMap> depotCapacityStatisticsMapList = new ArrayList<DepotCapacityStatisticsMap>();
        List depotStorageList = timeType == 1 ? this.depotDataStatisticsMapper.queryDepotStorageStatisticsByYear(depotInfoIdList, time, town, name) : this.depotDataStatisticsMapper.queryDepotStorageStatisticsByMouth(depotInfoIdList, time, town, name);
        Map<String, List<DepotStorage>> collect = depotStorageList.stream().collect(Collectors.groupingBy(DepotStorage::getStorageTime));
        for (String key : collect.keySet()) {
            Double totalCapacity = 0.0;
            Double nowCapacity = 0.0;
            for (DepotStorage item : collect.get(key)) {
                if (item.getType() == 1) {
                    totalCapacity = item.getAmount();
                    continue;
                }
                nowCapacity = item.getAmount();
            }
            depotCapacityStatisticsMapList.add(new DepotCapacityStatisticsMap(key, totalCapacity, nowCapacity));
        }
        return depotCapacityStatisticsMapList.stream().sorted(Comparator.comparing(DepotCapacityStatisticsMap::getTime)).collect(Collectors.toList());
    }

    public JSONObject queryDepotStorageStatisticsList(Integer timeType, String time, Integer depotId, Integer inSort, Integer outSort, Integer capacitySort, String userId, Integer start, Integer pageSize) {
        JSONObject jsonObject = new JSONObject();
        if (depotId != null) {
            Integer depotStorageCount = this.depotStorageMapper.queryDepotStorageListByDepotId(timeType, time, depotId);
            List depotStorageList = this.depotStorageMapper.queryDepotStoragePageByDepotId(timeType, time, depotId, inSort, outSort, capacitySort, start, pageSize);
            jsonObject.put((Object)"count", (Object)depotStorageCount);
            jsonObject.put((Object)"list", (Object)depotStorageList);
        } else {
            List depotInfoIdList = this.getDepotInfoIdListByUserId(userId);
            if (depotInfoIdList.size() < 1) {
                return null;
            }
            List result = this.getDepotStorageList(timeType, time, inSort, outSort, start, pageSize, depotInfoIdList);
            jsonObject.put((Object)"count", (Object)depotInfoIdList.size());
            jsonObject.put((Object)"list", (Object)result);
        }
        return jsonObject;
    }

    private List<DepotInfo> getDepotStorageList(Integer timeType, String time, Integer inSort, Integer outSort, Integer start, Integer pageSize, List<Integer> depotInfoIdList) {
        List depotInfoList = this.depotInfoMapper.queryDepotInfoListByIdList(depotInfoIdList);
        List depotStorageList = this.depotStorageMapper.queryDepotStorageStatisticsList(timeType, time, depotInfoIdList);
        depotInfoList.forEach(depotInfo -> {
            depotInfo.setTotalCapacity(Double.valueOf(depotStorageList.stream().filter(depotStorage -> depotStorage.getDepotId().equals(depotInfo.getId()) && depotStorage.getType() == 1).mapToDouble(DepotStorage::getAmount).sum()));
            depotInfo.setNowCapacity(Double.valueOf(depotStorageList.stream().filter(depotStorage -> depotStorage.getDepotId().equals(depotInfo.getId()) && depotStorage.getType() == 2).mapToDouble(DepotStorage::getAmount).sum()));
        });
        List result = this.sortDepotInfoList(outSort, inSort, depotInfoList);
        return start == null ? result : result.stream().skip(start.intValue()).limit(pageSize.intValue()).collect(Collectors.toList());
    }

    private List<DepotInfo> sortDepotInfoList(Integer nowSort, Integer totalSort, List<DepotInfo> depotInfoList) {
        List<Object> resultTemp = nowSort == null ? depotInfoList : (nowSort == 1 ? depotInfoList.stream().filter(depotInfo -> depotInfo.getNowCapacity() != null).sorted(Comparator.comparing(DepotInfo::getNowCapacity).reversed()).collect(Collectors.toList()) : depotInfoList.stream().filter(depotInfo -> depotInfo.getNowCapacity() != null).sorted(Comparator.comparing(DepotInfo::getNowCapacity)).collect(Collectors.toList()));
        List<Object> result = totalSort == null ? resultTemp : (totalSort == 1 ? resultTemp.stream().filter(depotInfo -> depotInfo.getTotalCapacity() != null).sorted(Comparator.comparing(DepotInfo::getTotalCapacity).reversed()).collect(Collectors.toList()) : resultTemp.stream().filter(depotInfo -> depotInfo.getTotalCapacity() != null).sorted(Comparator.comparing(DepotInfo::getTotalCapacity)).collect(Collectors.toList()));
        return result;
    }

    public void exportDepotStorageStatisticsList(HttpServletResponse response, Integer timeType, String time, String email, Integer depotId, Integer inSort, Integer outSort, Integer capacitySort, String userId) throws IOException {
        if (depotId != null) {
            List depotStorageList = this.depotStorageMapper.queryDepotStoragePageByDepotId(timeType, time, depotId, inSort, outSort, capacitySort, null, null);
            ArrayList<DepotStorageDetailExport> exportList = new ArrayList<DepotStorageDetailExport>();
            for (int i = 0; i < depotStorageList.size(); ++i) {
                exportList.add(DepotStorageDetailExport.generate((DepotStorage)((DepotStorage)depotStorageList.get(i)), (Integer)(i + 1)));
            }
            if (!email.equals("")) {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream(1000);
                EasyExcelUtil.sendEmail((ByteArrayOutputStream)outputStream, DepotStorageDetailExport.class, (String)"\u51fa\u5165\u5e93\u7edf\u8ba1", exportList);
                this.mailService.sendMsgAndFile(email, "\u51fa\u5165\u5e93\u7edf\u8ba1", "\u51fa\u5165\u5e93\u7edf\u8ba1", "\u51fa\u5165\u5e93\u7edf\u8ba1.xlsx", outputStream.toByteArray());
            } else {
                EasyExcelUtil.generateFixedHeadFile((HttpServletResponse)response, (String)"\u51fa\u5165\u5e93\u7edf\u8ba1", DepotStorageDetailExport.class, (String)"\u51fa\u5165\u5e93\u7edf\u8ba1", exportList);
            }
        } else {
            List depotInfoIdList = this.getDepotInfoIdListByUserId(userId);
            ArrayList<DepotStorageStatisticsExport> exportList = new ArrayList<DepotStorageStatisticsExport>();
            if (depotInfoIdList.size() > 0) {
                List depotInfoList = this.getDepotStorageList(timeType, time, inSort, outSort, null, null, depotInfoIdList);
                for (int i = 0; i < depotInfoList.size(); ++i) {
                    exportList.add(DepotStorageStatisticsExport.generateExport((DepotInfo)((DepotInfo)depotInfoList.get(i)), (Integer)(i + 1), (String)time));
                }
            }
            if (!email.equals("")) {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream(1000);
                EasyExcelUtil.sendEmail((ByteArrayOutputStream)outputStream, DepotStorageStatisticsExport.class, (String)"\u51fa\u5165\u5e93\u7edf\u8ba1", exportList);
                this.mailService.sendMsgAndFile(email, "\u51fa\u5165\u5e93\u7edf\u8ba1", "\u51fa\u5165\u5e93\u7edf\u8ba1", "\u51fa\u5165\u5e93\u7edf\u8ba1.xlsx", outputStream.toByteArray());
            } else {
                EasyExcelUtil.generateFixedHeadFile((HttpServletResponse)response, (String)"\u51fa\u5165\u5e93\u7edf\u8ba1", DepotStorageStatisticsExport.class, (String)"\u51fa\u5165\u5e93\u7edf\u8ba1", exportList);
            }
        }
    }

    public List<DepotCapacityStatisticsMap> queryDepotStatisticsChangeYear(String town, String name) {
        return this.depotDataStatisticsMapper.queryDepotStatisticsChangeYearCount(town, name);
    }

    private List<Integer> getDepotInfoIdListByUserId(String userId) {
        Map stringObjectMap = this.depotInfoService.queryDepotInfoPageByApp(userId, null, null, "", "", null, null);
        List<Integer> depotInfoIdList = new ArrayList<Integer>();
        if (stringObjectMap.get("list") != null) {
            List depotInfoList = (List)stringObjectMap.get("list");
            depotInfoIdList = depotInfoList.stream().map(DepotInfo::getId).collect(Collectors.toList());
        }
        return depotInfoIdList;
    }
}

