/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.farm.bean.DepotInfo;
import com.farm.bean.DepotRoomInfo;
import com.farm.mapper.DepotInfoMapper;
import com.farm.service.DepotInfoService;
import com.farm.service.DepotRoleService;
import com.farm.service.DepotStorageService;
import com.farm.util.ParamAESUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.geo.GeoJson;
import org.springframework.data.mongodb.core.geo.GeoJsonPoint;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="depotInfoService")
public class DepotInfoServiceImpl
implements DepotInfoService {
    @Autowired
    private DepotInfoMapper depotInfoMapper;
    @Autowired
    private DepotRoleService depotRoleService;
    @Autowired
    private DepotStorageService depotStorageService;
    @Autowired
    private MongoTemplate mongoTemplate;

    public void insert(DepotInfo depotInfo) {
        depotInfo.setUserId(ParamAESUtil.dealStr((String)depotInfo.getUserId(), (int)2));
        this.depotInfoMapper.insert(depotInfo);
    }

    public void update(DepotInfo depotInfo) {
        depotInfo.setUserId(ParamAESUtil.dealStr((String)depotInfo.getUserId(), (int)2));
        this.depotInfoMapper.update(depotInfo);
    }

    public void disableDepotInfo(Integer id, Integer status) {
        this.depotInfoMapper.disableDepotInfo(id, status);
    }

    @Transactional
    public void deleteDepotInfo(Integer id) {
        this.depotInfoMapper.deleteDepotInfo(id);
        this.depotInfoMapper.deleteDepotRoomByDepotId(id);
        this.depotInfoMapper.deleteDepotCapacityStatByDepotId(id);
        this.depotStorageService.deleteDepotStorageByDepotId(id);
        this.depotRoleService.deleteDepotRolePermissionByDepotId(id);
    }

    public DepotInfo queryDepotInfoDetail(Integer id, String userId) {
        DepotInfo depotInfo = this.depotInfoMapper.queryDepotInfoDetail(id);
        if (depotInfo == null) {
            return null;
        }
        depotInfo.setUserId(ParamAESUtil.dealStr((String)depotInfo.getUserId(), (int)1));
        if (userId != null && !userId.equals("")) {
            if (depotInfo.getUserId().equals(userId)) {
                depotInfo.setStatisticsFlag(Integer.valueOf(1));
            } else {
                depotInfo.setStatisticsFlag(this.depotRoleService.validateUserCanSearchStatistics(ParamAESUtil.dealStr((String)userId, (int)2), id));
            }
        }
        return depotInfo;
    }

    public JSONObject queryDepotInfoPage(String name, String type, String phone, Integer status, String town, Integer start, Integer pageSize) {
        JSONObject jsonObject = new JSONObject();
        Integer count = this.depotInfoMapper.queryDepotInfoCount(name, type, phone, status, town);
        List depotInfoList = this.depotInfoMapper.queryDepotInfoPage(name, type, phone, status, town, start, pageSize);
        depotInfoList.forEach(item -> item.setUserId(ParamAESUtil.dealStr((String)item.getUserId(), (int)1)));
        jsonObject.put("count", (Object)count);
        jsonObject.put("list", (Object)depotInfoList);
        return jsonObject;
    }

    public List<DepotInfo> queryDepotInfoList() {
        List depotInfoList = this.depotInfoMapper.queryDepotInfoList();
        depotInfoList.forEach(item -> item.setUserId(ParamAESUtil.dealStr((String)item.getUserId(), (int)1)));
        return depotInfoList;
    }

    public void insertDepotRoomInfo(Integer depotId, String name) {
        this.depotInfoMapper.insertDepotRoomInfo(depotId, name);
    }

    public void updateDepotRoomInfo(Integer id, String name) {
        this.depotInfoMapper.updateDepotRoomInfo(id, name);
    }

    public void deleteDepotRoom(Integer id) {
        this.depotInfoMapper.deleteDepotRoom(id);
    }

    public List<DepotRoomInfo> queryDepotRoomList(Integer depotId) {
        return this.depotInfoMapper.queryDepotRoomList(depotId);
    }

    public List<DepotInfo> queryDepotInfoByUserId(String userId, String depotName, String town, String name) {
        String userIdTemp = ParamAESUtil.dealStr((String)userId, (int)2);
        List roleIdList = this.depotRoleService.queryDepotRoleIdByUserId(userIdTemp);
        List<DepotInfo> depotInfoList = new ArrayList();
        if (roleIdList.size() > 0) {
            depotInfoList = this.depotInfoMapper.queryDepotInfoByRoleIdList(roleIdList, Integer.valueOf(2), depotName, town, name);
        }
        List depotInfoIdList = depotInfoList.stream().map(DepotInfo::getId).collect(Collectors.toList());
        depotInfoList.addAll(this.depotInfoMapper.queryDepotInfoListByUserId(userIdTemp, depotInfoIdList, depotName, name));
        depotInfoList.forEach(item -> item.setUserId(userId));
        return depotInfoList;
    }

    public Map<String, Object> queryDepotInfoPageByApp(String userId, Double lng, Double lat, String name, String capacity, Integer start, Integer pageSize) {
        List result;
        HashMap<String, Object> map = new HashMap<String, Object>();
        Integer count = 0;
        if (userId.equals("")) {
            count = this.depotInfoMapper.queryDepotInfoCountByApp(name);
            result = this.depotInfoMapper.queryDepotInfoPageByApp(null, lng, lat, name, capacity, start, pageSize);
        } else {
            String userIdTemp = ParamAESUtil.dealStr((String)userId, (int)2);
            List roleIdList = this.depotRoleService.queryDepotRoleIdByUserId(userIdTemp);
            List depotInfoList = new ArrayList();
            if (roleIdList.size() > 0) {
                depotInfoList = this.depotInfoMapper.queryDepotInfoByRoleIdList(roleIdList, Integer.valueOf(1), name, "", null);
            }
            List depotInfoIdList = depotInfoList.stream().map(DepotInfo::getId).collect(Collectors.toList());
            depotInfoList.addAll(this.depotInfoMapper.queryDepotInfoListByUserId(userIdTemp, depotInfoIdList, name, null));
            result = depotInfoList;
            List depotInfoIdListTemp = depotInfoList.stream().map(DepotInfo::getId).collect(Collectors.toList());
            if (depotInfoIdListTemp.size() > 0) {
                result = this.depotInfoMapper.queryDepotInfoPageByApp(depotInfoIdListTemp, lng, lat, name, capacity, start, pageSize);
                count = result.size();
            }
        }
        result.forEach(item -> item.setUserId(ParamAESUtil.dealStr((String)item.getUserId(), (int)1)));
        map.put("count", count);
        map.put("list", result);
        return map;
    }

    public void updateDepotNowCapacity(Integer id, Double nowCapacity) {
        this.depotInfoMapper.updateDepotNowCapacity(id, nowCapacity);
    }

    public Boolean validateDepotInRange(Double lng, Double lat, int code) {
        Criteria criteria = new Criteria();
        criteria.and("adcode").is((Object)String.valueOf(code));
        criteria.and("bound").intersects((GeoJson)new GeoJsonPoint(lng.doubleValue(), lat.doubleValue()));
        return this.mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), JSONObject.class, "district") != null;
    }
}

