/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.farm.bean.DepotRole;
import com.farm.bean.DepotRolePermission;
import com.farm.mapper.DepotRoleMapper;
import com.farm.service.DepotRoleService;
import com.farm.util.ParamAESUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="depotRoleService")
public class DepotRoleServiceImpl
implements DepotRoleService {
    @Autowired
    private DepotRoleMapper depotRoleMapper;

    @Transactional
    public void insert(DepotRole depotRole) {
        this.depotRoleMapper.insertRole(depotRole);
        this.insertRolePermissionAndRoleUser(depotRole);
    }

    @Transactional
    public void update(DepotRole depotRole) {
        this.depotRoleMapper.updateRole(depotRole);
        this.deleteRolePermissionAndRoleUserByRoleId(depotRole.getId());
        this.insertRolePermissionAndRoleUser(depotRole);
    }

    public void deleteDepotRole(Integer id) {
        this.deleteRolePermissionAndRoleUserByRoleId(id);
        this.depotRoleMapper.deleteDepotRole(id);
    }

    public DepotRole queryDepotRoleDetail(Integer id) {
        DepotRole depotRole = this.depotRoleMapper.queryDepotRoleDetail(id);
        depotRole.setDepotRolePermissionList(this.depotRoleMapper.queryRolePermissionListByRoleId(id));
        List depotRoleUserList = this.depotRoleMapper.queryRoleUserListByRoleId(id);
        depotRoleUserList.forEach(depotRoleUser -> depotRoleUser.setUserId(ParamAESUtil.dealStr((String)depotRoleUser.getUserId(), (int)1)));
        depotRole.setDepotRoleUserList(depotRoleUserList);
        return depotRole;
    }

    public JSONObject queryDepotRolePage(String name, List<String> depotIdList, Integer start, Integer pageSize) {
        JSONObject jsonObject = new JSONObject();
        Integer count = this.depotRoleMapper.queryDepotRoleCount(name, depotIdList);
        List depotRoleList = this.depotRoleMapper.queryDepotRolePage(name, depotIdList, start, pageSize);
        depotRoleList.forEach(depotRole -> depotRole.setDepotRolePermissionList(this.depotRoleMapper.queryRolePermissionListByRoleId(depotRole.getId())));
        jsonObject.put((Object)"count", (Object)count);
        jsonObject.put((Object)"list", (Object)depotRoleList);
        return jsonObject;
    }

    public List<Integer> queryDepotRoleIdByUserId(String userId) {
        return this.depotRoleMapper.queryDepotRoleIdByUserId(userId);
    }

    public Integer validateUserCanSearchStatistics(String userId, Integer depotId) {
        return this.depotRoleMapper.queryRolePermissionByUserAndDepotId(userId, depotId) != null ? 1 : 0;
    }

    public void deleteDepotRolePermissionByDepotId(Integer depotId) {
        this.depotRoleMapper.deleteDepotRolePermissionByDepotId(depotId);
    }

    private void insertRolePermissionAndRoleUser(DepotRole depotRole) {
        List tempRolePermissionList = depotRole.getDepotRolePermissionList();
        List depotRoleUserList = depotRole.getDepotRoleUserList();
        ArrayList depotRolePermissionList = new ArrayList();
        Map<Integer, List<DepotRolePermission>> depotRolePermissionMap = tempRolePermissionList.stream().collect(Collectors.groupingBy(DepotRolePermission::getDepotId));
        depotRolePermissionMap.keySet().forEach(key -> {
            List depotRolePermissions = (List)depotRolePermissionMap.get(key);
            List collect = depotRolePermissions.stream().map(DepotRolePermission::getType).collect(Collectors.toList());
            depotRolePermissionList.add(new DepotRolePermission(key, StringUtils.join(collect, (String)",")));
        });
        depotRolePermissionList.forEach(depotRolePermission -> depotRolePermission.setRoleId(depotRole.getId()));
        depotRoleUserList.forEach(depotRoleUser -> {
            depotRoleUser.setRoleId(depotRole.getId());
            depotRoleUser.setUserId(ParamAESUtil.dealStr((String)depotRoleUser.getUserId(), (int)2));
        });
        this.depotRoleMapper.insertRolePermissionBatch(depotRolePermissionList);
        this.depotRoleMapper.insertRoleUserBatch(depotRoleUserList);
    }

    private void deleteRolePermissionAndRoleUserByRoleId(Integer id) {
        this.depotRoleMapper.deleteRolePermissionByRoleId(id);
        this.depotRoleMapper.deleteRoleUserByRoleId(id);
    }
}

