/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.farm.bean.DepotInfo;
import com.farm.bean.DepotStorage;
import com.farm.bean.DepotStorageExport;
import com.farm.mapper.DepotInfoMapper;
import com.farm.mapper.DepotStorageMapper;
import com.farm.service.DepotInfoService;
import com.farm.service.DepotStorageService;
import com.farm.util.EasyExcelUtil;
import com.farm.util.HttpSendUtil;
import com.farm.util.ParamAESUtil;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="depotStorageService")
public class DepotStorageServiceImpl
implements DepotStorageService {
    @Value(value="${farm.serverUrl}")
    private String farmServerUrl;
    @Autowired
    private DepotStorageMapper depotStorageMapper;
    @Autowired
    private DepotInfoService depotInfoService;
    @Autowired
    private DepotInfoMapper depotInfoMapper;

    @Transactional
    public void insert(DepotStorage depotStorage) throws ParseException {
        this.aseFieldIdList(depotStorage, Integer.valueOf(2));
        DepotInfo depotInfo = this.depotInfoService.queryDepotInfoDetail(depotStorage.getDepotId(), null);
        long storageTime = new SimpleDateFormat("yyyy-MM-dd HH:mm").parse(depotStorage.getStorageTime()).getTime();
        if (storageTime < new Date().getTime()) {
            this.updateDepotNowCapacity(depotStorage, depotInfo);
            DepotStorage nearDepotStorage = this.depotStorageMapper.getDepotStorageByNearTime(depotStorage.getStorageTime(), depotStorage.getDepotId());
            depotStorage.setTotalCapacity(nearDepotStorage == null ? depotInfo.getTotalCapacity() : nearDepotStorage.getTotalCapacity());
            if (depotStorage.getType() == 1) {
                depotStorage.setNowCapacity(Double.valueOf(nearDepotStorage == null ? depotStorage.getAmount() : nearDepotStorage.getNowCapacity() + depotStorage.getAmount()));
            } else {
                depotStorage.setNowCapacity(Double.valueOf(nearDepotStorage == null ? -depotStorage.getAmount().doubleValue() : nearDepotStorage.getNowCapacity() - depotStorage.getAmount()));
            }
            depotStorage.setIsExecute(Integer.valueOf(1));
            this.depotStorageMapper.updateDepotStorageNowCapacity(depotStorage.getStorageTime(), depotStorage.getType(), depotStorage.getAmount(), depotStorage.getDepotId(), Integer.valueOf(1));
        } else {
            depotStorage.setIsExecute(Integer.valueOf(0));
        }
        this.depotStorageMapper.insert(depotStorage);
    }

    @Transactional
    public void update(DepotStorage depotStorage) throws ParseException {
        DepotStorage oldDepotStorage = this.depotStorageMapper.queryDepotStorageDetail(depotStorage.getId());
        DepotInfo depotInfo = this.depotInfoService.queryDepotInfoDetail(depotStorage.getDepotId(), null);
        this.aseFieldIdList(depotStorage, Integer.valueOf(2));
        long storageTime = new SimpleDateFormat("yyyy-MM-dd HH:mm").parse(depotStorage.getStorageTime()).getTime();
        if (oldDepotStorage.getIsExecute() == 0) {
            if (storageTime < new Date().getTime()) {
                this.updateDepotNowCapacity(depotStorage, oldDepotStorage, depotInfo, Integer.valueOf(0));
                this.depotStorageMapper.updateDepotStorageNowCapacity(depotStorage.getStorageTime(), depotStorage.getType(), depotStorage.getAmount(), depotStorage.getDepotId(), Integer.valueOf(1));
            } else {
                depotStorage.setIsExecute(Integer.valueOf(0));
            }
        } else if (storageTime < new Date().getTime()) {
            this.updateDepotNowCapacity(depotStorage, oldDepotStorage, depotInfo, Integer.valueOf(1));
            this.depotStorageMapper.updateStorageNowCapacityByTimeInterval(depotStorage.getStorageTime(), oldDepotStorage.getStorageTime(), depotStorage.getAmount(), depotStorage.getDepotId(), depotStorage.getType());
            this.depotStorageMapper.updateDepotStorageNowCapacity(oldDepotStorage.getStorageTime(), depotStorage.getType(), Double.valueOf(depotStorage.getAmount() - oldDepotStorage.getAmount()), depotStorage.getDepotId(), Integer.valueOf(1));
        } else {
            double nowCapacity = depotStorage.getType() == 1 ? depotInfo.getNowCapacity() - oldDepotStorage.getAmount() : depotInfo.getNowCapacity() + oldDepotStorage.getAmount();
            this.depotInfoMapper.updateDepotNowCapacity(depotInfo.getId(), Double.valueOf(nowCapacity));
            depotStorage.setIsExecute(Integer.valueOf(0));
            depotStorage.setTotalCapacity(Double.valueOf(0.0));
            depotStorage.setNowCapacity(Double.valueOf(0.0));
            this.depotStorageMapper.updateDepotStorageNowCapacity(oldDepotStorage.getStorageTime(), depotStorage.getType(), oldDepotStorage.getAmount(), depotStorage.getDepotId(), Integer.valueOf(2));
        }
        this.depotStorageMapper.update(depotStorage);
    }

    private void updateDepotNowCapacity(DepotStorage depotStorage, DepotStorage oldDepotStorage, DepotInfo depotInfo, Integer type) {
        double nowCapacity;
        depotStorage.setIsExecute(Integer.valueOf(1));
        DepotStorage nearDepotStorage = this.depotStorageMapper.getDepotStorageByNearTime(depotStorage.getStorageTime(), depotStorage.getDepotId());
        depotStorage.setTotalCapacity(nearDepotStorage == null ? depotInfo.getTotalCapacity() : nearDepotStorage.getTotalCapacity());
        if (depotStorage.getType() == 1) {
            depotStorage.setNowCapacity(Double.valueOf(nearDepotStorage == null ? depotStorage.getAmount() : nearDepotStorage.getNowCapacity() + depotStorage.getAmount()));
            nowCapacity = type == 0 ? depotInfo.getNowCapacity() + depotStorage.getAmount() : depotInfo.getNowCapacity() - oldDepotStorage.getAmount() + depotStorage.getAmount();
        } else {
            depotStorage.setNowCapacity(Double.valueOf(nearDepotStorage == null ? -depotStorage.getAmount().doubleValue() : nearDepotStorage.getNowCapacity() - depotStorage.getAmount()));
            nowCapacity = type == 0 ? depotInfo.getNowCapacity() - depotStorage.getAmount() : depotInfo.getNowCapacity() + oldDepotStorage.getAmount() - depotStorage.getAmount();
        }
        this.depotInfoService.updateDepotNowCapacity(depotInfo.getId(), Double.valueOf(nowCapacity));
    }

    private void updateDepotNowCapacity(DepotStorage depotStorage, DepotInfo depotInfo) {
        if (depotStorage.getType() == 1) {
            depotInfo.setNowCapacity(Double.valueOf(depotInfo.getNowCapacity() + depotStorage.getAmount()));
        } else {
            depotInfo.setNowCapacity(Double.valueOf(depotInfo.getNowCapacity() - depotStorage.getAmount()));
        }
        this.depotInfoService.updateDepotNowCapacity(depotInfo.getId(), depotInfo.getNowCapacity());
    }

    private void aseFieldIdList(DepotStorage depotStorage, Integer type) {
        if (!"".equals(depotStorage.getFieldIds()) && depotStorage.getFieldIds() != null) {
            List<String> fieldIdList = Arrays.asList(depotStorage.getFieldIds().split(","));
            ArrayList fieldIdTempList = new ArrayList();
            fieldIdList.forEach(fieldId -> fieldIdTempList.add(ParamAESUtil.dealStr((String)fieldId, (int)type)));
            depotStorage.setFieldIds(StringUtils.join(fieldIdTempList, (String)","));
        }
    }

    public DepotStorage queryDepotStorageDetail(Integer id) throws IOException {
        DepotStorage depotStorage = this.depotStorageMapper.queryDepotStorageDetail(id);
        depotStorage.setUserId(ParamAESUtil.dealStr((String)depotStorage.getUserId(), (int)1));
        if (depotStorage.getFieldIds() != null && !depotStorage.getFieldIds().equals("")) {
            String url = this.farmServerUrl + "field/queryFieldListName?fieldIdString=" + depotStorage.getFieldIds();
            depotStorage.setFieldName(HttpSendUtil.sendHttpGet((String)url));
        }
        this.aseFieldIdList(depotStorage, Integer.valueOf(1));
        return depotStorage;
    }

    @Transactional
    public void deleteDepotStorage(Integer id) {
        DepotStorage depotStorage = this.depotStorageMapper.queryDepotStorageDetail(id);
        DepotInfo depotInfo = this.depotInfoMapper.queryDepotInfoDetail(depotStorage.getDepotId());
        if (depotStorage.getType() == 1) {
            depotInfo.setNowCapacity(Double.valueOf(depotInfo.getNowCapacity() - depotStorage.getAmount()));
        } else {
            depotInfo.setNowCapacity(Double.valueOf(depotInfo.getNowCapacity() + depotStorage.getAmount()));
        }
        this.depotInfoMapper.updateDepotNowCapacity(depotInfo.getId(), depotInfo.getNowCapacity());
        this.depotStorageMapper.updateDepotStorageNowCapacity(depotStorage.getStorageTime(), depotStorage.getType(), depotStorage.getAmount(), depotStorage.getDepotId(), Integer.valueOf(2));
        this.depotStorageMapper.deleteDepotStorage(id);
    }

    public JSONObject queryDepotStoragePage(String depotName, Integer type, String variety, String phone, Integer start, Integer pageSize) {
        JSONObject jsonObject = new JSONObject();
        Integer count = this.depotStorageMapper.queryDepotStorageCount(depotName, type, variety, phone);
        List depotStorageList = this.depotStorageMapper.queryDepotStoragePage(depotName, type, variety, phone, start, pageSize);
        depotStorageList.forEach(depotStorage -> this.aseFieldIdList(depotStorage, Integer.valueOf(1)));
        jsonObject.put((Object)"count", (Object)count);
        jsonObject.put((Object)"list", (Object)depotStorageList);
        return jsonObject;
    }

    public void exportDepotStorage(HttpServletResponse response, String depotName, Integer type, String variety, String phone) throws IOException {
        List depotStorageList = this.depotStorageMapper.queryDepotStorageList(depotName, type, variety, phone);
        ArrayList depotStorageExportList = new ArrayList();
        depotStorageList.forEach(depotStorage -> depotStorageExportList.add(DepotStorageExport.generate((DepotStorage)depotStorage)));
        for (int i = 0; i < depotStorageExportList.size(); ++i) {
            ((DepotStorageExport)depotStorageExportList.get(i)).setIndex(Integer.valueOf(i + 1));
        }
        EasyExcelUtil.generateFixedHeadFile((HttpServletResponse)response, (String)"\u51fa\u5165\u5e93\u8bb0\u5f55", DepotStorageExport.class, (String)"\u51fa\u5165\u5e93\u8bb0\u5f55", depotStorageExportList);
    }

    public void deleteDepotStorageByDepotId(Integer depotId) {
        this.depotStorageMapper.deleteDepotStorageByDepotId(depotId);
    }
}

