/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.DpChildrenData;
import com.farm.bean.DpData;
import com.farm.bean.DpDataExport;
import com.farm.bean.bo.DpDataBo;
import com.farm.bean.dpBean.TZZXJB_14006;
import com.farm.bean.dpBean.YFGYZT_14104;
import com.farm.bean.vo.DpDataVo;
import com.farm.config.HttpUrlConfig;
import com.farm.mapper.DpDataMapper;
import com.farm.service.DpDataService;
import com.farm.util.HttpSendUtil;
import com.farm.util.ParamAESUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DpDataServiceImpl
implements DpDataService {
    @Resource
    private DpDataMapper dpDataMapper;

    public Integer saveData(DpDataBo dpDataBo) {
        DpData dpData = (DpData)BeanUtil.toBean((Object)dpDataBo, DpData.class);
        if (dpDataBo.getBusinessId() == null) {
            if (dpDataBo.getType() == 0) {
                this.dpDataMapper.saveData(dpData);
            } else {
                String uuid;
                this.dpDataMapper.saveData(dpData);
                if (dpData.getJsonData().getString("uuid") == null || dpData.getJsonData().getString("uuid").isEmpty()) {
                    uuid = IdUtil.simpleUUID();
                    dpData.getJsonData().put("uuid", (Object)uuid);
                } else {
                    uuid = dpData.getJsonData().getString("uuid");
                }
                if (dpData.getId() == null) {
                    dpData.setId(this.dpDataMapper.queryId(dpData.getTypeCode()));
                }
                this.dpDataMapper.saveDataList(uuid, dpData.getId(), JSONObject.toJSONString((Object)dpData.getJsonData()), dpData.getJsonData().getString("title"), dpData.getJsonData().getString("sort"), dpData.getJsonData().getString("time"), dpData.getJsonData().getString("year"));
            }
        } else {
            this.dpDataMapper.saveNodeData(dpData);
        }
        return 1;
    }

    public DpDataVo queryDataByTypeCode(Integer typeCode, String businessId) {
        if (businessId == null || businessId.isEmpty()) {
            return this.dpDataMapper.queryDataByTypeCode(typeCode);
        }
        DpDataVo dpDataVo = this.dpDataMapper.queryDataNodeByBusinessId(typeCode, businessId);
        if (typeCode == 14101) {
            StringBuilder str;
            String ids = dpDataVo.getData().getString("ids");
            String fieldId = dpDataVo.getData().getString("fieldId");
            if (StringUtils.isNotBlank((String)fieldId)) {
                fieldId = ParamAESUtil.dealStr((String)fieldId, (int)2);
                str = new StringBuilder();
                str.append(HttpUrlConfig.url);
                str.append("view/temp/querySystemData");
                JSONObject para = new JSONObject();
                para.put("userId", (Object)"E6C9A3599C6E9E4124EE232DD85F6B86");
                para.put("companyId", (Object)"4377");
                para.put("moduleKey", (Object)"deviceWlInfo");
                para.put("fieldId", (Object)fieldId);
                String returnData = HttpSendUtil.sendHttpPost((String)str.toString(), (String)"", (String)"", (String)para.toJSONString());
                JSONObject jsonObject = JSONObject.parseObject((String)returnData);
                Integer resCode = jsonObject.getInteger("resCode");
                if (resCode == 0) {
                    JSONArray resData = jsonObject.getJSONObject("resData").getJSONArray("list");
                    for (int i = 0; i < resData.size(); ++i) {
                        JSONObject data = resData.getJSONObject(i);
                        if (data.getInteger("equipId") == null || data.getIntValue("equipId") != 19) continue;
                        String res = HttpSendUtil.sendHttpGet((String)("http://pc.shuxitech.com/farm_server/wlCustomerDevice/platformDetail?platformId=" + data.getString("id") + "&companyId=4377&userId=E6C9A3599C6E9E4124EE232DD85F6B86"));
                        JSONObject detail = JSONObject.parseObject((String)res);
                        try {
                            JSONObject jsonObject1 = detail.getJSONObject("resData").getJSONArray("typeMainList").getJSONObject(0).getJSONObject("correlationDeviceData").getJSONObject("nowImgData");
                            if (!jsonObject1.getString("type").equals("2") || !StringUtils.isNotBlank((String)jsonObject1.getString("playUrl"))) continue;
                            data.put("playUrl", (Object)jsonObject1.getString("playUrl"));
                            data.put("token", (Object)jsonObject1.getString("token"));
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    JSONObject json = new JSONObject();
                    json.put("boundary", (Object)dpDataVo.getData().getString("boundary"));
                    json.put("list", (Object)resData);
                    json.put("fieldId", (Object)fieldId);
                    dpDataVo.setDataJson(json);
                    return dpDataVo;
                }
            }
            if (ids == null || ids.isEmpty()) {
                JSONObject json = new JSONObject();
                json.put("list", new ArrayList());
                dpDataVo.setDataJson(json);
                return dpDataVo;
            }
            str = new StringBuilder();
            str.append(HttpUrlConfig.url);
            str.append("dp/service/wlListInfo");
            str.append("?ids=" + ids);
            String returnData = HttpSendUtil.sendHttpGet((String)str.toString());
            JSONObject jsonObject = JSONObject.parseObject((String)returnData);
            Integer resCode = jsonObject.getInteger("resCode");
            if (resCode == 0) {
                JSONArray resData = jsonObject.getJSONArray("resData");
                JSONObject json = new JSONObject();
                json.put("list", (Object)resData);
                dpDataVo.setDataJson(json);
            }
            return dpDataVo;
        }
        if (dpDataVo == null) {
            dpDataVo = new DpDataVo();
            JSONObject json = new JSONObject();
            json.put("list", new ArrayList());
            dpDataVo.setDataJson(json);
            return dpDataVo;
        }
        return dpDataVo;
    }

    public Integer delData(String uuids) {
        return this.dpDataMapper.delData(uuids);
    }

    public Integer delDataByCode(String code) {
        return this.dpDataMapper.delDataByCode(code);
    }

    public Integer saveParentData(DpData dpData) {
        return this.dpDataMapper.saveParentData(dpData);
    }

    public Integer saveChildrenData(List<com.farm.bean.vo.DpChildrenData> list) {
        return this.dpDataMapper.saveChildrenData(list);
    }

    public DpDataExport selectExportData(String typeCode, String businessId) {
        if (StringUtils.isNotBlank((String)typeCode) && typeCode.equals("14104") && StringUtils.isNotBlank((String)businessId)) {
            JSONArray list;
            DpDataExport dpDataExport = new DpDataExport();
            DpDataVo dpDataVo = this.dpDataMapper.queryDataNodeByBusinessId(Integer.valueOf(Integer.parseInt(typeCode)), businessId);
            JSONObject data = dpDataVo.getData();
            if (data != null && (list = data.getJSONArray("list")) != null) {
                ArrayList<DpChildrenData> cList = new ArrayList<DpChildrenData>();
                for (int i = 0; i < list.size(); ++i) {
                    JSONObject item = list.getJSONObject(i);
                    JSONArray dataList = item.getJSONArray("dataList");
                    for (int j = 0; j < dataList.size(); ++j) {
                        DpChildrenData dp = new DpChildrenData();
                        JSONObject jsonObject = dataList.getJSONObject(j);
                        dp.setData(JSONObject.toJSONString((Object)jsonObject));
                        cList.add(dp);
                    }
                }
                dpDataExport.setChildrenList(cList);
            }
            return dpDataExport;
        }
        return this.dpDataMapper.selectExportData(typeCode);
    }

    public JSONObject queryDataListByTypeCode(Integer typeCode, Integer pageNum, Integer pageSize) {
        JSONObject json = new JSONObject();
        if (typeCode == 14006) {
            List list = this.dpDataMapper.queryList(typeCode, Integer.valueOf(0), Integer.valueOf(1000));
            if (list.size() == 0) {
                return json;
            }
            DpDataVo dpDataVo = (DpDataVo)list.get(0);
            List<JSONObject> returnList = list.stream().map(item -> item.getData()).collect(Collectors.toList());
            ArrayList enList = new ArrayList();
            returnList.forEach(item -> {
                TZZXJB_14006 it = (TZZXJB_14006)JSONObject.parseObject((String)JSONObject.toJSONString((Object)item), TZZXJB_14006.class);
                enList.add(it);
            });
            Map<String, List<TZZXJB_14006>> collect = enList.stream().collect(Collectors.groupingBy(TZZXJB_14006::getProjectName));
            ArrayList dataList = new ArrayList();
            collect.forEach((key, value) -> {
                JSONObject newJson = new JSONObject();
                newJson.put("projectName", key);
                newJson.put("resourcesNames", value);
                dataList.add(newJson);
            });
            JSONObject json1 = new JSONObject();
            json1.put("list", dataList);
            json.put("data", (Object)json1);
            json.put("id", (Object)dpDataVo.getId());
            json.put("typeCode", (Object)dpDataVo.getTypeCode());
            return json;
        }
        Integer start = null;
        if (pageNum != null && pageSize != null && pageNum != null && pageNum != null) {
            start = (pageNum - 1) * pageSize;
        }
        List list = this.dpDataMapper.queryList(typeCode, start, pageSize);
        List returnList = list.stream().map(item -> item.getData()).collect(Collectors.toList());
        if (start != null && pageSize != null) {
            json.put("count", (Object)this.dpDataMapper.queryListCount(typeCode));
        }
        json.put("list", returnList);
        return json;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void saveNodeList(List<YFGYZT_14104> list, String businessId, String code) {
        DpData dp = new DpData();
        dp.setBusinessId(businessId);
        dp.setTypeCode(Integer.valueOf(Integer.parseInt(code)));
        Map<String, List<YFGYZT_14104>> collect = list.stream().collect(Collectors.groupingBy(YFGYZT_14104::getMonth));
        ArrayList dataList = new ArrayList();
        collect.forEach((key, value) -> {
            JSONObject json = new JSONObject();
            json.put("month", key);
            json.put("dataList", value);
            dataList.add(json);
        });
        JSONObject jsonNew = new JSONObject();
        jsonNew.put("list", dataList);
        dp.setData(JSONObject.toJSONString((Object)jsonNew));
        this.dpDataMapper.saveNodeData(dp);
    }
}

