/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.CropManageAll;
import com.farm.bean.MarketPriceAll;
import com.farm.mapper.MarketPriceAllMapper;
import com.farm.service.MarketPriceAllService;
import com.farm.util.BigDecimalUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MarketPriceAllServiceImpl
implements MarketPriceAllService {
    @Resource
    private MarketPriceAllMapper marketPriceAllMapper;
    @Resource
    private MongoTemplate mongoTemplate;

    @Transactional(propagation=Propagation.REQUIRED)
    public void disposeData() {
        List cropManageAll = this.marketPriceAllMapper.queryCropAllList();
        if (cropManageAll.size() == 0) {
            return;
        }
        String date = DateUtil.format((Date)DateUtil.offsetDay((Date)DateUtil.date(), (int)-1), (String)"yyyy-MM-dd");
        cropManageAll.forEach(item -> {
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"date").is((Object)date).and("variety").regex(".*?" + item.getName() + ".*"));
            List jsonObjects = this.mongoTemplate.find(query, JSONObject.class, "jn_zgw_price");
            List listAll = this.createEntity(jsonObjects, item);
            if (listAll.size() > 0) {
                this.marketPriceAllMapper.batchSaveCropAll(listAll);
            }
        });
    }

    private List<MarketPriceAll> createEntity(List<JSONObject> list, CropManageAll cropManageAll) {
        ArrayList<MarketPriceAll> listAll = new ArrayList<MarketPriceAll>();
        list.forEach(item -> {
            MarketPriceAll marketPriceAll = new MarketPriceAll();
            marketPriceAll.setCropId(cropManageAll.getParentId());
            marketPriceAll.setBreedId(cropManageAll.getId());
            String diameter = item.getString(" diameter");
            marketPriceAll.setSerialId(this.createSerialId(cropManageAll.getParentId(), cropManageAll.getId(), diameter));
            marketPriceAll.setRegionName(item.getString("province"));
            marketPriceAll.setReportTime(item.getString("date"));
            Double min = BigDecimalUtil.mul((double)item.getDouble("min"), (double)100.0);
            marketPriceAll.setMinPrice(Long.valueOf(min.longValue()));
            Double max = BigDecimalUtil.mul((double)item.getDouble("max"), (double)100.0);
            marketPriceAll.setMaxPrice(Long.valueOf(max.longValue()));
            Double avg = BigDecimalUtil.mul((double)item.getDouble("avg"), (double)100.0);
            marketPriceAll.setAvgPrice(Long.valueOf(avg.longValue()));
            listAll.add(marketPriceAll);
        });
        return listAll;
    }

    private synchronized Integer createSerialId(Integer cropId, Integer breedId, String diameter) {
        Integer serialId = this.marketPriceAllMapper.querySerialIdByName(cropId, breedId, diameter);
        if (serialId == null) {
            CropManageAll cropManageAll = new CropManageAll();
            cropManageAll.setName(diameter);
            cropManageAll.setParentId(breedId);
            this.marketPriceAllMapper.saveCropAll(cropManageAll);
            serialId = cropManageAll.getId();
        }
        return serialId;
    }
}

