/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.MarketPrice;
import com.farm.bean.MarketPriceCase;
import com.farm.bean.MarketPriceGroup;
import com.farm.bean.PriceGroup;
import com.farm.bean.PriceGroupAll;
import com.farm.bean.PriceGroupData;
import com.farm.bean.PriceType;
import com.farm.bean.RegionVo;
import com.farm.bean.ReportPrice;
import com.farm.mapper.CropManageMapper;
import com.farm.mapper.MarketPriceAllMapper;
import com.farm.mapper.MarketPriceGroupMapper;
import com.farm.mapper.MarketPriceMapper;
import com.farm.mapper.PriceTypeMapper;
import com.farm.service.MarketPriceService;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MarketPriceServiceImpl
implements MarketPriceService {
    @Resource
    private MarketPriceMapper marketPriceMapper;
    @Resource
    private MarketPriceGroupMapper marketPriceGroupMapper;
    @Resource
    private MarketPriceAllMapper marketPriceAllMapper;
    @Resource
    private PriceTypeMapper priceTypeMapper;
    @Resource
    private CropManageMapper cropManageMapper;

    public Integer saveOrUpdateMarketPrice(MarketPrice marketPrice) {
        Integer count;
        this.conversionPrice(marketPrice);
        if (marketPrice.getBackupNum() != null) {
            this.conversionNum(marketPrice);
        }
        marketPrice.setBusinessId(marketPrice.getReportTime().replace("-", "") + "_" + marketPrice.getCompanyId() + "_" + marketPrice.getSerialId() + "_" + marketPrice.getPriceId() + "_" + marketPrice.getAddressId());
        if (marketPrice.getId() == null && (count = this.marketPriceGroupMapper.queryGroupCountByBusinessId(marketPrice.getBusinessId())) == 0) {
            MarketPriceGroup group = new MarketPriceGroup();
            group.setBusinessId(marketPrice.getBusinessId());
            group.setCropId(marketPrice.getCropId());
            group.setBreedId(marketPrice.getBreedId());
            group.setSerialId(marketPrice.getSerialId());
            group.setPriceId(marketPrice.getPriceId());
            group.setReportTime(marketPrice.getReportTime());
            group.setStatus(Integer.valueOf(1));
            group.setLevel(Integer.valueOf(1));
            group.setAddressId(marketPrice.getAddressId());
            group.setCompanyId(marketPrice.getCompanyId());
            try {
                this.marketPriceGroupMapper.saveGroup(group);
            }
            catch (DuplicateKeyException duplicateKeyException) {
                // empty catch block
            }
        }
        return this.marketPriceMapper.saveOrUpdateMarketPrice(marketPrice);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public Integer batchDelete(String ids) {
        Integer integer = this.marketPriceMapper.batchDelete(ids);
        String[] split = ids.split(",");
        if (split.length > 0) {
            for (String s : split) {
                String businessId = this.marketPriceMapper.queryMarketPriceBusinessId(s);
                List s1 = this.marketPriceMapper.checkDeleteGroupMark(businessId);
                if (s1 != null && s1.size() != 0) continue;
                this.marketPriceMapper.deleteGroupMark(businessId);
            }
        }
        return 1;
    }

    public JSONObject queryMarketPrice(MarketPriceCase marketPriceCase) {
        List list;
        JSONObject json = new JSONObject();
        if (marketPriceCase.getPageNum() != null && marketPriceCase.getPageNum() != null) {
            marketPriceCase.setStart(Integer.valueOf((marketPriceCase.getPageNum() - 1) * marketPriceCase.getPageSize()));
        }
        if (marketPriceCase.getReportTime() != null && !marketPriceCase.getReportTime().isEmpty()) {
            String[] split = marketPriceCase.getReportTime().split(",");
            marketPriceCase.setStartTime(split[0]);
            marketPriceCase.setEndTime(split[1]);
        }
        if (marketPriceCase.getType() != null && marketPriceCase.getType() == 0) {
            list = this.marketPriceMapper.queryMarketPriceList(marketPriceCase);
            Integer count = this.marketPriceMapper.queryMarketPriceCount(marketPriceCase);
            json.put("list", (Object)list);
            json.put("count", (Object)count);
        } else if (marketPriceCase.getType() != null && marketPriceCase.getType() == 1) {
            marketPriceCase.setStatus(Integer.valueOf(1));
            list = this.marketPriceMapper.queryMarketPriceListByGroup(marketPriceCase);
            Integer count = this.marketPriceMapper.queryMarketPriceCountByGroup(marketPriceCase);
            json.put("list", (Object)list);
            json.put("count", (Object)count);
        } else if (marketPriceCase.getType() != null && marketPriceCase.getType() == 2) {
            marketPriceCase.setStatus(Integer.valueOf(2));
            list = this.marketPriceMapper.queryMarketPriceListByGroup2(marketPriceCase);
            Integer count = this.marketPriceMapper.queryMarketPriceCountByGroup2(marketPriceCase);
            json.put("list", (Object)list);
            json.put("count", (Object)count);
        } else {
            json.put("list", new ArrayList());
            json.put("count", (Object)0);
        }
        return json;
    }

    public MarketPrice queryCropManageDetails(Integer id) {
        return this.marketPriceMapper.queryCropManageDetails(id);
    }

    public JSONObject queryReportDetails(String businessId, Integer pageNum, Integer pageSize) {
        JSONObject json = new JSONObject();
        Integer start = 0;
        if (pageNum != null && pageNum != null) {
            start = (pageNum - 1) * pageSize;
        }
        MarketPriceCase marketPriceCase = new MarketPriceCase();
        marketPriceCase.setBusinessId(businessId);
        marketPriceCase.setStart(start);
        marketPriceCase.setPageSize(pageSize);
        List list = this.marketPriceMapper.queryMarketPriceList(marketPriceCase);
        Integer count = this.marketPriceMapper.queryMarketPriceCount(marketPriceCase);
        json.put("list", (Object)list);
        json.put("count", (Object)count);
        return json;
    }

    public ReportPrice queryReportPrice(String businessId) {
        return this.marketPriceMapper.queryReportPrice(businessId);
    }

    public Integer updateReportPrice(String businessId, Long maxPrice, Long minPrice, Long avgPrice) {
        return this.marketPriceMapper.updateReportPrice(businessId, maxPrice, minPrice, avgPrice);
    }

    public Integer revocation(String businessIds) {
        return this.marketPriceMapper.revocation(businessIds);
    }

    public List<PriceGroup> priceGroup(Integer companyId, Integer cropId, Integer type, Integer day) {
        if (type == -1 && cropId == -1) {
            type = 1;
            cropId = this.cropManageMapper.queryCropId("\u82f9\u679c", companyId);
            if (cropId == null) {
                return new ArrayList<PriceGroup>();
            }
        }
        List priceTypes = this.priceTypeMapper.queryPriceTypeId(companyId);
        DateTime endTime = DateUtil.parse((CharSequence)DateUtil.today(), (String)"yyyy-MM-dd");
        DateTime startTime = DateUtil.offsetDay((Date)endTime, (int)(-day.intValue()));
        if (priceTypes.size() == 0) {
            return new ArrayList<PriceGroup>();
        }
        List list = this.marketPriceMapper.queryMarketPriceDateGroup(cropId, companyId, priceTypes, type, startTime.toString(), endTime.toString());
        return this.supplementDate(priceTypes, list, startTime, day);
    }

    public List<PriceGroup> priceGroupNew(Integer companyId, Integer cropId, Integer type, Integer day, Integer priceType) {
        if (cropId == -1 && (cropId = this.cropManageMapper.queryCropId("\u82f9\u679c", companyId)) == null) {
            return new ArrayList<PriceGroup>();
        }
        DateTime endTime = DateUtil.parse((CharSequence)DateUtil.today(), (String)"yyyy-MM-dd");
        DateTime startTime = DateUtil.offsetDay((Date)endTime, (int)(-day.intValue()));
        List regionList = this.marketPriceMapper.queryRegionCode(companyId, cropId, type, day, priceType, startTime.toString(), endTime.toString(), null);
        if (regionList.size() == 0) {
            return new ArrayList<PriceGroup>();
        }
        PriceType py = new PriceType();
        py.setId(Integer.valueOf(-1));
        py.setPriceName("\u5e73\u5747\u503c");
        regionList.add(py);
        List list = this.marketPriceMapper.queryMarketPriceDateGroupNew(cropId, companyId, null, type, startTime.toString(), endTime.toString(), priceType);
        if (list.size() == 0) {
            return new ArrayList<PriceGroup>();
        }
        DateTime parse = DateUtil.parse((CharSequence)((PriceGroup)list.get(0)).getDate());
        Long newDay = DateUtil.between((Date)parse, (Date)endTime, (DateUnit)DateUnit.DAY);
        return this.supplementDateNew(regionList, list, parse, Integer.valueOf(newDay.intValue()));
    }

    public List<PriceType> queryPriceList(Integer companyId) {
        return this.priceTypeMapper.queryPriceTypeId(companyId);
    }

    public List<RegionVo> queryRegionAll() {
        return this.marketPriceMapper.queryRegionAll();
    }

    public List<PriceGroupData> priceGroupDate(Integer companyId, Integer cropId, Integer type, String date) {
        List priceTypes = this.priceTypeMapper.queryPriceTypeId(companyId);
        if (priceTypes == null || priceTypes.size() == 0) {
            return new ArrayList<PriceGroupData>();
        }
        List priceGroupData = this.marketPriceMapper.priceGroupDate(cropId, companyId, priceTypes, type, date);
        priceTypes.forEach(pr -> {
            List collect = priceGroupData.stream().map(p -> p.getPriceId()).collect(Collectors.toList());
            if (collect.size() == 0 || !collect.contains(pr.getId())) {
                PriceGroupData dataPr = new PriceGroupData();
                dataPr.setPriceId(pr.getId());
                dataPr.setPriceName(pr.getPriceName());
                dataPr.setPrice(Long.valueOf(-1L));
                dataPr.setMaxPrice(Long.valueOf(-1L));
                dataPr.setMinPrice(Long.valueOf(-1L));
                priceGroupData.add(dataPr);
            }
        });
        return priceGroupData;
    }

    public Integer savePriceGroup(MarketPriceGroup marketPriceGroup) {
        if (marketPriceGroup.getBreedId() == null || marketPriceGroup.getCropId() == null || marketPriceGroup.getSerialId() == null || marketPriceGroup.getPriceId() == null || marketPriceGroup.getCompanyId() == null || marketPriceGroup.getReportTime() == null || marketPriceGroup.getReportTime().isEmpty()) {
            return -2;
        }
        marketPriceGroup.setBusinessId(marketPriceGroup.getReportTime().replace("-", "") + "_" + marketPriceGroup.getCompanyId() + "_" + marketPriceGroup.getSerialId() + "_" + marketPriceGroup.getPriceId());
        try {
            return this.marketPriceGroupMapper.saveGroup(marketPriceGroup);
        }
        catch (DuplicateKeyException duplicateKeyException) {
            return -1;
        }
    }

    public List<PriceGroup> priceGroupAll(Integer cropId, Integer day) {
        DateTime endTime = DateUtil.parse((CharSequence)DateUtil.today(), (String)"yyyy-MM-dd");
        DateTime startTime = DateUtil.offsetDay((Date)endTime, (int)(-day.intValue()));
        List list = this.marketPriceAllMapper.priceGroupAll(cropId, startTime.toString(), endTime.toString());
        return this.supplementDateAll(list, startTime, day);
    }

    public List<PriceGroupAll> priceGroupDateAll(Integer cropId, String date) {
        return this.marketPriceAllMapper.priceGroupDateAll(cropId, date);
    }

    public JSONObject cropPriceAll(Integer cropId) {
        JSONObject json = new JSONObject();
        List list = this.marketPriceAllMapper.cropPriceAll(cropId);
        json.put("list", (Object)list);
        return json;
    }

    private List<PriceGroup> supplementDateAll(List<PriceGroup> list, DateTime startTime, Integer day) {
        List dateList = this.createDateAll(startTime, day);
        if (list.size() == 0) {
            return dateList;
        }
        List collect = dateList.stream().filter(item -> !list.stream().map(l -> l.getDate()).collect(Collectors.toList()).contains(item.getDate())).collect(Collectors.toList());
        list.addAll(collect);
        return list.stream().sorted(Comparator.comparing(PriceGroup::getDate)).collect(Collectors.toList());
    }

    private List<PriceGroup> createDateAll(DateTime startTime, Integer day) {
        ArrayList<PriceGroup> list = new ArrayList<PriceGroup>();
        for (int i = 0; i <= day; ++i) {
            PriceGroup priceGroupAll = new PriceGroup();
            priceGroupAll.setDate(DateUtil.offsetDay((Date)startTime, (int)i).toDateStr());
            ArrayList<PriceGroupData> pList = new ArrayList<PriceGroupData>();
            PriceGroupData priceGroupData = new PriceGroupData();
            priceGroupData.setPrice(Long.valueOf(-1L));
            pList.add(priceGroupData);
            priceGroupAll.setList(pList);
            list.add(priceGroupAll);
        }
        return list;
    }

    private List<PriceGroup> supplementDate(List<PriceType> priceTypes, List<PriceGroup> list, DateTime startTime, Integer day) {
        List dateList = this.createDate(startTime, day, priceTypes);
        if (list.size() == 0) {
            return dateList;
        }
        for (PriceGroup priceGroup : list) {
            List collect = priceGroup.getList().stream().map(ii -> ii.getPriceId()).collect(Collectors.toList());
            priceTypes.forEach(item -> {
                if (!collect.contains(item.getId())) {
                    PriceGroupData p = new PriceGroupData();
                    p.setPriceId(item.getId());
                    p.setPriceName(item.getPriceName());
                    p.setPrice(Long.valueOf(-1L));
                    priceGroup.getList().add(p);
                }
            });
        }
        List collect = dateList.stream().filter(item -> !list.stream().map(l -> l.getDate()).collect(Collectors.toList()).contains(item.getDate())).collect(Collectors.toList());
        list.addAll(collect);
        return list.stream().sorted(Comparator.comparing(PriceGroup::getDate)).collect(Collectors.toList());
    }

    private List<PriceGroup> supplementDateNew(List<PriceType> regionList, List<PriceGroup> list, DateTime startTime, Integer day) {
        List dateList = this.createDateNew(startTime, day, regionList);
        if (list.size() == 0) {
            return dateList;
        }
        for (PriceGroup priceGroup : list) {
            List collect = priceGroup.getList().stream().map(ii -> ii.getRegionId()).collect(Collectors.toList());
            regionList.forEach(item -> {
                if (!collect.contains(item.getId())) {
                    PriceGroupData p = new PriceGroupData();
                    p.setRegionId(item.getId());
                    p.setRegionName(item.getPriceName());
                    p.setPrice(Long.valueOf(-1L));
                    priceGroup.getList().add(p);
                }
            });
        }
        List collect = dateList.stream().filter(item -> !list.stream().map(l -> l.getDate()).collect(Collectors.toList()).contains(item.getDate())).collect(Collectors.toList());
        list.addAll(collect);
        return list.stream().sorted(Comparator.comparing(PriceGroup::getDate)).collect(Collectors.toList());
    }

    private List<PriceGroup> createDate(DateTime startTime, Integer day, List<PriceType> priceTypes) {
        ArrayList<PriceGroup> list = new ArrayList<PriceGroup>();
        for (int i = 0; i <= day; ++i) {
            PriceGroup priceGroup = new PriceGroup();
            priceGroup.setDate(DateUtil.offsetDay((Date)startTime, (int)i).toDateStr());
            ArrayList listData = new ArrayList();
            priceTypes.forEach(item -> {
                PriceGroupData pgd = new PriceGroupData();
                pgd.setPrice(Long.valueOf(-1L));
                pgd.setPriceId(item.getId());
                pgd.setPriceName(item.getPriceName());
                listData.add(pgd);
            });
            priceGroup.setList(listData);
            list.add(priceGroup);
        }
        return list;
    }

    private List<PriceGroup> createDateNew(DateTime startTime, Integer day, List<PriceType> regionList) {
        ArrayList<PriceGroup> list = new ArrayList<PriceGroup>();
        for (int i = 0; i <= day; ++i) {
            PriceGroup priceGroup = new PriceGroup();
            priceGroup.setDate(DateUtil.offsetDay((Date)startTime, (int)i).toDateStr());
            ArrayList listData = new ArrayList();
            regionList.forEach(item -> {
                PriceGroupData pgd = new PriceGroupData();
                pgd.setPrice(Long.valueOf(-1L));
                pgd.setRegionId(item.getId());
                pgd.setRegionName(item.getPriceName());
                listData.add(pgd);
            });
            priceGroup.setList(listData);
            list.add(priceGroup);
        }
        return list;
    }

    private void conversionPrice(MarketPrice marketPrice) {
        if (marketPrice.getBackupPriceUnit() == 2) {
            Long repair = marketPrice.getBackupPrice() % 2L;
            marketPrice.setPrice(Long.valueOf(marketPrice.getBackupPrice() / 2L + repair));
        } else if (marketPrice.getBackupPriceUnit() == 3) {
            Long repair = marketPrice.getBackupPrice() % 2000L >= 1000L ? 1L : 0L;
            marketPrice.setPrice(Long.valueOf(marketPrice.getBackupPrice() / 2000L + repair));
        } else {
            marketPrice.setPrice(marketPrice.getBackupPrice());
        }
    }

    private void conversionNum(MarketPrice marketPrice) {
        if (marketPrice.getBackupNumUnit() == 2) {
            marketPrice.setNum(Long.valueOf(marketPrice.getBackupNum() * 2L));
        } else if (marketPrice.getBackupNumUnit() == 3) {
            marketPrice.setNum(Long.valueOf(marketPrice.getBackupNum() * 2000L));
        } else {
            marketPrice.setNum(marketPrice.getBackupNum());
        }
    }
}

