/*
 * Decompiled with CFR 0.152.
 */
package com.farm.task;

import com.farm.bean.DepotCapacityStatistics;
import com.farm.bean.DepotInfo;
import com.farm.mapper.DepotDataStatisticsMapper;
import com.farm.mapper.DepotInfoMapper;
import com.farm.mapper.DepotStorageMapper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class DataDealTask {
    private static final Logger log = LoggerFactory.getLogger(DataDealTask.class);
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    private DepotInfoMapper depotInfoMapper;
    @Autowired
    private DepotStorageMapper depotStorageMapper;
    @Autowired
    private DepotDataStatisticsMapper depotDataStatisticsMapper;

    public Boolean putLock(String key) {
        return this.redisTemplate.opsForValue().setIfAbsent((Object)("lym" + key), (Object)"", 2L, TimeUnit.SECONDS);
    }

    @Scheduled(cron="0 50 23 * * ?")
    public void statisticsDepotCapacity() {
        Boolean flag = this.putLock("statisticsDepotCapacity");
        if (flag.booleanValue()) {
            List depotInfoList = this.depotInfoMapper.queryDepotInfoList();
            if (depotInfoList.size() <= 0) {
                return;
            }
            ArrayList depotCapacityStatisticsList = new ArrayList();
            depotInfoList.forEach(depotInfo -> depotCapacityStatisticsList.add(DepotCapacityStatistics.generateCapacityStatistics((DepotInfo)depotInfo)));
            this.depotDataStatisticsMapper.insertCapacityStatisticsList(depotCapacityStatisticsList);
            log.error("\u672c\u673a\u6267\u884c\uff1a\u7edf\u8ba1\u679c\u5e93\u5b58\u91cf\u6570\u636e");
        } else {
            log.error("\u672c\u673a\u4e0d\u6267\u884c\uff1a\u7edf\u8ba1\u679c\u5e93\u5b58\u91cf\u6570\u636e");
        }
    }

    public void executeDepotStorage() {
        Boolean flag = this.putLock("executeDepotStorage");
        if (flag.booleanValue()) {
            Calendar cal = Calendar.getInstance();
            cal.add(12, 1);
            String formatTime = new SimpleDateFormat("yyyy-MM-dd HH:mm").format(cal.getTime());
            List depotStorageList = this.depotStorageMapper.listDepotStorageNoExecute(formatTime);
            if (depotStorageList.size() < 1) {
                return;
            }
            depotStorageList.forEach(depotStorage -> {
                this.depotInfoMapper.storageDepotNowCapacity(depotStorage.getDepotId(), depotStorage.getAmount(), depotStorage.getType());
                DepotInfo depotInfo = this.depotInfoMapper.queryDepotInfoDetail(depotStorage.getDepotId());
                this.depotStorageMapper.updateDepotStorageExecute(depotStorage.getId(), depotInfo.getTotalCapacity(), depotInfo.getNowCapacity());
            });
            log.error("\u672c\u673a\u6267\u884c\uff1a\u679c\u5e93\u51fa\u5165\u5e93");
        } else {
            log.error("\u672c\u673a\u4e0d\u6267\u884c\uff1a\u679c\u5e93\u51fa\u5165\u5e93");
        }
    }
}

