// JavaScript source code

var CanvasTexture = function (parentTexture) {

    this._canvas = document.createElement("canvas");
    this._canvas.width = this._canvas.height = 1024;
    this._context2D = this._canvas.getContext("2d");

    if (parentTexture) {

        this._parentTexture.push(parentTexture);
        parentTexture.image = this._canvas;

    }

    var that = this;
    this._background = document.createElement("img");
    this._background.addEventListener("load", function () {

        that._canvas.width = that._background.naturalWidth;
        that._canvas.height = that._background.naturalHeight;

        that._crossRadius = Math.ceil(Math.min(that._canvas.width, that._canvas.height / 30));
        that._crossMax = Math.ceil(0.70710678 * that._crossRadius);
        that._crossMin = Math.ceil(that._crossMax / 10);
        that._crossThickness = Math.ceil(that._crossMax / 10);

        that._draw();

    }, false);
    this._background.crossOrigin = '';
    this._background.src = "models/models/gltf/audia/ground2.jpg";

    this._draw();

};


CanvasTexture.prototype = {

    constructor: CanvasTexture,

    _canvas: null,
    _context2D: null,
    _xCross: 0,
    _yCross: 0,

    _crossRadius: 57,
    _crossMax: 40,
    _crossMin: 4,
    _crossThickness: 4,

    _parentTexture: [],

    addParent: function (parentTexture) {

        if (this._parentTexture.indexOf(parentTexture) === -1) {

            this._parentTexture.push(parentTexture);
            parentTexture.image = this._canvas;

        }

    },

    setCrossPosition: function (x, y) {

        this._xCross = x * this._canvas.width;
        this._yCross = y * this._canvas.height;

        this._draw();

    },

    _draw: function () {

        if (!this._context2D) return;

        this._context2D.clearRect(0, 0, this._canvas.width, this._canvas.height);
     
        // Background.
        this._context2D.drawImage(this._background, 0, 0);

        // Yellow cross.
        this._context2D.lineWidth = this._crossThickness * 3;
        this._context2D.strokeStyle = "#FFFF00";

        this._context2D.beginPath();
        this._context2D.moveTo(this._xCross - this._crossMax - 2, this._yCross - this._crossMax - 2);
        this._context2D.lineTo(this._xCross - this._crossMin, this._yCross - this._crossMin);

        this._context2D.moveTo(this._xCross + this._crossMin, this._yCross + this._crossMin);
        this._context2D.lineTo(this._xCross + this._crossMax + 2, this._yCross + this._crossMax + 2);

        this._context2D.moveTo(this._xCross - this._crossMax - 2, this._yCross + this._crossMax + 2);
        this._context2D.lineTo(this._xCross - this._crossMin, this._yCross + this._crossMin);

        this._context2D.moveTo(this._xCross + this._crossMin, this._yCross - this._crossMin);
        this._context2D.lineTo(this._xCross + this._crossMax + 2, this._yCross - this._crossMax - 2);

        this._context2D.stroke();

        for (var i = 0; i < this._parentTexture.length; i++) {

            this._parentTexture[i].needsUpdate = true;

        }

    }

};



var width = window.innerWidth;
var height = window.innerHeight;

var canvas;
var planeTexture, cubeTexture, circleTexture;

var container;

var camera, scene, renderer;

var raycaster = new THREE.Raycaster();
var mouse = new THREE.Vector2();
var onClickPosition = new THREE.Vector2();
init();


function init() {

    // A circle on the right.
    circleTexture = new THREE.Texture(undefined, THREE.UVMapping, THREE.RepeatWrapping, THREE.RepeatWrapping);
   // canvas.addParent(circleTexture);
    var circleMaterial = new THREE.MeshBasicMaterial({ map: circleTexture });
    var circleGeometry = new THREE.CircleBufferGeometry(25, 40, 0, Math.PI * 2);
    var uvs = circleGeometry.attributes.uv.array;
    // Set a specific texture mapping.
    for (var i = 0; i < uvs.length; i++) {

        uvs[i] = (uvs[i] - 0.25) * 2;

    }
    var circle = new THREE.Mesh(circleGeometry, circleMaterial);
    circle.position.x = 24;
    circle.position.y = -5;
    circle.position.z = 0;
  //  scene.add(circle);


}


