/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller;

import com.alibaba.fastjson.JSONObject;
import com.farm.util.ResultVo;
import com.qiniu.http.Response;
import com.qiniu.storage.UploadManager;
import com.qiniu.util.Auth;
import com.qiniu.util.StringMap;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.apache.commons.lang.math.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping(value={"/config"})
@RestController
@Api(tags={"\u516c\u5171\u63a5\u53e3"})
@RefreshScope
public class ConfigController {
    private static final Logger log = LoggerFactory.getLogger(ConfigController.class);
    private final UploadManager uploadManager;
    private final Auth auth;
    @Value(value="${qiniu.bucket}")
    private String bucket;
    @Value(value="${qiniu.ip}")
    private String addressIp;
    @Value(value="${qiniu.prefix}")
    private String prefix;
    private StringMap putPolicy;

    @Autowired
    public ConfigController(UploadManager uploadManager, Auth auth) {
        this.uploadManager = uploadManager;
        this.auth = auth;
    }

    private String getUploadToken() {
        return this.auth.uploadToken(this.bucket, null, 3600L, this.putPolicy);
    }

    @PostMapping(value={"/yun"}, consumes={"multipart/form-data"})
    @CrossOrigin
    @ApiOperation(value="\u56fe\u7247\u4e0a\u4f20\u63a5\u53e3")
    public Object uploadYunFile(@RequestParam(value="file") MultipartFile file, @RequestParam(required=false, value="path", defaultValue="common") String path) {
        if (file.isEmpty()) {
            return ResultVo.error();
        }
        String originalFilename = file.getOriginalFilename();
        StringBuilder fileName0 = new StringBuilder(this.prefix);
        fileName0.append("pysd").append(path).append("/").append(RandomUtils.nextInt()).append(LocalDateTime.now().toEpochSecond(ZoneOffset.ofHours(8))).append(originalFilename != null ? originalFilename.substring(originalFilename.indexOf(".")) : "");
        try {
            Response response = this.uploadManager.put(file.getBytes(), fileName0.toString(), this.getUploadToken());
            for (int retry = 0; response.needRetry() && retry < 3; ++retry) {
                response = this.uploadManager.put(file.getBytes(), fileName0.toString(), this.getUploadToken());
            }
            if (response.isOK()) {
                JSONObject jsonObject = JSONObject.parseObject((String)response.bodyString());
                String yunFileName = jsonObject.getString("key");
                String yunFilePath = this.addressIp + yunFileName;
                log.info("\u3010\u6587\u4ef6\u4e0a\u4f20\u81f3\u4e03\u725b\u4e91\u3011\u7edd\u5bf9\u8def\u5f84\uff1a{}", (Object)yunFilePath);
                JSONObject result = new JSONObject();
                result.put("url", (Object)yunFilePath);
                return ResultVo.success((Object)result);
            }
            log.error("\u3010\u6587\u4ef6\u4e0a\u4f20\u81f3\u4e03\u725b\u4e91\u3011\u5931\u8d25\uff0c{}", (Object)JSONObject.parseObject((String)response.toString()));
            return ResultVo.error();
        }
        catch (IOException e) {
            log.error("\u3010\u6587\u4ef6\u4e0a\u4f20\u81f3\u4e03\u725b\u4e91\u3011\u5931\u8d25\uff0c\u7edd\u5bf9\u8def\u5f84\uff1a{}", (Object)System.getProperty("user.dir"));
            return ResultVo.error();
        }
    }
}

