/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller;

import com.alibaba.fastjson.JSONObject;
import com.farm.bean.DetectionElement;
import com.farm.service.DetectionElementService;
import com.farm.util.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/element"})
@Api(tags={"\u68c0\u6d4b\u5143\u7d20"})
public class DetectionElementController {
    @Autowired
    private DetectionElementService elementService;

    @PostMapping(value={"/insert"})
    @ApiOperation(value="\u65b0\u589e\u68c0\u6d4b\u5143\u7d20")
    public Object insertSoilInspection(@RequestBody DetectionElement element) {
        return ResultVo.success((Object)this.elementService.insertDetectionElement(element));
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="\u66f4\u65b0\u68c0\u6d4b\u5143\u7d20")
    public Object updateSoilInspection(@RequestBody DetectionElement element) {
        return ResultVo.success((Object)this.elementService.updateDetectionElement(element));
    }

    @GetMapping(value={"/del"})
    @ApiOperation(value="\u5220\u9664\u68c0\u6d4b\u5143\u7d20")
    public Object del(Integer id) {
        return ResultVo.success((Object)this.elementService.deleteDetectionElement(id));
    }

    @GetMapping(value={"/elementList"})
    @ApiOperation(value="\u68c0\u6d4b\u5143\u7d20\u5217\u8868")
    public Object listPcFertilizePlan(DetectionElement inspectionVO, @RequestParam(required=false, defaultValue="1", value="page") Integer page, @RequestParam(required=false, defaultValue="10", value="pageSize") Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        JSONObject json = this.elementService.listDetectionElement(inspectionVO, start, pageSize);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/eleListByType"})
    @ApiOperation(value="\u6839\u636e\u7c7b\u578b\u83b7\u53d6\u68c0\u6d4b\u5143\u7d20\u5217\u8868")
    public Object eleListByType(Integer type) {
        return ResultVo.success((Object)this.elementService.listEleByType(type));
    }

    @GetMapping(value={"/checkStandard"})
    @ApiOperation(value="\u83b7\u53d6\u6807\u51c6\u7ed3\u679c")
    public Object checkStandard(DetectionElement element) {
        return ResultVo.success((Object)this.elementService.checkStandard(element));
    }
}

