/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.DeviceInfo;
import com.farm.service.DeviceService;
import com.farm.util.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u7269\u8054\u7f51\u8bbe\u5907\u7ba1\u7406"})
@RequestMapping(value={"/device-manage"})
public class DeviceController {
    @Autowired
    private DeviceService deviceService;

    @PostMapping(value={"/upsert"})
    @ApiOperation(value="\u65b0\u589e/\u4fee\u6539")
    public ResultVo upsertDevice(@RequestBody String body) {
        DeviceInfo deviceInfo = (DeviceInfo)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), DeviceInfo.class);
        if (deviceInfo.getId() == null) {
            this.deviceService.insertDevice(deviceInfo);
        } else {
            this.deviceService.updateDevice(deviceInfo);
        }
        return ResultVo.success();
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u83b7\u53d6\u8bbe\u5907\u5217\u8868")
    public ResultVo listDevice(@RequestParam(value="deviceName", required=false, defaultValue="") String deviceName, @RequestParam(value="baseIdStr", required=false, defaultValue="") String baseIdStr, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        return ResultVo.success((Object)this.deviceService.listDevice(deviceName, baseIdStr, start, pageSize));
    }

    @GetMapping(value={"/detail"})
    @ApiOperation(value="\u83b7\u53d6\u8bbe\u5907\u8be6\u60c5")
    public ResultVo queryDeviceDetail(@RequestParam(value="id") Integer id) {
        return ResultVo.success((Object)this.deviceService.queryDeviceDetail(id));
    }

    @PostMapping(value={"/del"})
    @ApiOperation(value="\u5220\u9664")
    public ResultVo deleteDevice(@RequestParam(value="id") Integer id) {
        this.deviceService.deleteDevice(id);
        return ResultVo.success();
    }
}

