/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller;

import com.alibaba.fastjson.JSONObject;
import com.farm.bean.vo.InspectionVO;
import com.farm.service.InspectionService;
import com.farm.util.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/inspection"})
@Api(tags={"\u571f\u58e4\u68c0\u6d4b"})
public class InspectionController {
    @Autowired
    private InspectionService inspectionService;

    @PostMapping(value={"/insert"})
    @ApiOperation(value="\u65b0\u589e\u68c0\u6d4b\u6570\u636e")
    public Object insertInspection(@RequestBody InspectionVO inspection) {
        return ResultVo.success((Object)this.inspectionService.insertInspection(inspection));
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="\u66f4\u65b0\u68c0\u6d4b")
    public Object updateInspection(@RequestBody InspectionVO inspection) {
        return ResultVo.success((Object)this.inspectionService.updateInspection(inspection));
    }

    @GetMapping(value={"/del"})
    @ApiOperation(value="\u5220\u9664\u68c0\u6d4b\u6570\u636e")
    public Object del(Integer id) {
        return ResultVo.success((Object)this.inspectionService.deleteById(id));
    }

    @GetMapping(value={"/inspectionList"})
    @ApiOperation(value="\u6839\u636e\u68c0\u6d4b\u7c7b\u578b\u8fd4\u56de\u5217\u8868")
    public Object listInspection(InspectionVO inspectionVO, @RequestParam(required=false, defaultValue="1", value="page") Integer page, @RequestParam(required=false, defaultValue="10", value="pageSize") Integer pageSize) {
        if (inspectionVO.getType() == null) {
            return ResultVo.error((String)"\u8bf7\u4f20\u5165type\u8bbf\u95ee");
        }
        Integer start = (page - 1) * pageSize;
        JSONObject json = this.inspectionService.listInspection(inspectionVO, start, pageSize);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/queryInspectionById"})
    @ApiOperation(value="\u901a\u8fc7id\u83b7\u53d6\u68c0\u6d4b\u8be6\u60c5")
    public Object queryInspectionById(Integer id) {
        return ResultVo.success((Object)this.inspectionService.queryInspectionById(id));
    }

    @GetMapping(value={"/listCropInfo"})
    @ApiOperation(value="\u83b7\u53d6\u4f5c\u7269\u5217\u8868")
    public Object listCropInfo(@RequestParam(value="search", required=false, defaultValue="") String search) {
        return ResultVo.success((Object)this.inspectionService.listCropInfo(search));
    }
}

