/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.farm.bean.DeviceInfo;
import com.farm.mapper.DeviceMapper;
import com.farm.service.DeviceService;
import com.farm.util.HttpSendUtil;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="deviceService")
public class DeviceServiceImpl
implements DeviceService {
    @Autowired
    private DeviceMapper deviceMapper;
    @Value(value="${farm.serverUrl}")
    private String farmServerUrl;

    public void insertDevice(DeviceInfo deviceInfo) {
        this.deviceMapper.insertDevice(deviceInfo);
    }

    public void updateDevice(DeviceInfo deviceInfo) {
        this.deviceMapper.updateDevice(deviceInfo);
    }

    public JSONObject listDevice(String deviceName, String baseIdStr, Integer start, Integer pageSize) {
        JSONObject jsonObject = new JSONObject();
        Integer count = this.deviceMapper.queryDeviceCount(deviceName, baseIdStr);
        List deviceInfoList = this.deviceMapper.queryDevicePage(deviceName, baseIdStr, start, pageSize);
        deviceInfoList.forEach(deviceInfo -> {
            try {
                deviceInfo.setFieldNames(HttpSendUtil.sendHttpGet((String)(this.farmServerUrl + "field/queryFieldListName?fieldIdString=" + deviceInfo.getFieldIds())));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        jsonObject.put("count", (Object)count);
        jsonObject.put("list", (Object)deviceInfoList);
        return jsonObject;
    }

    public DeviceInfo queryDeviceDetail(Integer id) {
        return this.deviceMapper.queryDeviceDetail(id);
    }

    public void deleteDevice(Integer id) {
        this.deviceMapper.deleteDevice(id);
    }
}

