/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.FieldGrowthPeriod;
import com.farm.bean.FieldInfo;
import com.farm.mapper.FieldGrowthPeriodMapper;
import com.farm.service.FieldGrowthPeriodService;
import com.farm.util.HttpSendUtil;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FieldGrowthPeriodServiceImpl
implements FieldGrowthPeriodService {
    @Autowired
    private FieldGrowthPeriodMapper periodMapper;
    @Value(value="${farm.serverUrl}")
    private String serverUrl;

    public Integer insertFieldGrowthPeriod(FieldGrowthPeriod period) {
        period.setGrowth(period.getType() == 0 ? "\u751f\u957f\u671f" : "\u4f9b\u8d27\u671f");
        FieldGrowthPeriod growth = this.periodMapper.countGrowth(period);
        if (growth == null) {
            return this.periodMapper.insertFieldGrowthPeriod(period);
        }
        return this.periodMapper.updateFieldGrowthPeriod(period);
    }

    public Integer insertBatchFieldGrowthPeriod(List<FieldGrowthPeriod> periods) {
        if (periods.size() > 0) {
            return this.periodMapper.insertBatchFieldGrowthPeriod(periods);
        }
        return 0;
    }

    public Integer updateFieldGrowthPeriod(FieldGrowthPeriod period) {
        period.setGrowth(period.getType() == 0 ? "\u751f\u957f\u671f" : "\u4f9b\u8d27\u671f");
        return this.periodMapper.updateFieldGrowthPeriod(period);
    }

    public Integer deleteFieldGrowthPeriodByFid(String fid) {
        return this.periodMapper.deleteFieldGrowthPeriodByFid(fid);
    }

    public FieldInfo listFieldGrowthPeriodByFid(String fid, String userId) {
        FieldInfo info = null;
        try {
            String s1 = HttpSendUtil.sendHttpGet((String)(this.serverUrl + "field/getFieldInfo?hash=x&fieldId=" + fid));
            String qr = HttpSendUtil.sendHttpGet((String)(this.serverUrl + "fieldCode/list?userId=" + userId + "&fieldId=" + fid + "&companyId=" + 5177));
            JSONObject object1 = JSONObject.parseObject((String)s1);
            String fieldName = object1.getJSONObject("resData").getString("fieldName");
            String cropName = object1.getJSONObject("resData").getString("cropSubName");
            JSONArray fieldCodeList = JSONObject.parseObject((String)qr).getJSONObject("resData").getJSONArray("list");
            String codeUrl = "";
            if (fieldCodeList.size() > 0) {
                codeUrl = JSONObject.parseObject((String)fieldCodeList.get(0).toString()).getString("codeUrl");
            }
            info = FieldInfo.builder().fieldGrowthPeriods(this.periodMapper.listFieldGrowthPeriodByFid(fid)).fieldName(fieldName).cropName(cropName).cropPictures(object1.getJSONObject("resData").getString("cropPictures")).QRUrl(codeUrl).build();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return info;
    }
}

