/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.CropInfo;
import com.farm.bean.FieldInfo;
import com.farm.bean.Inspection;
import com.farm.bean.vo.InspectionVO;
import com.farm.mapper.CropInfoMapper;
import com.farm.mapper.DetectionElementMapper;
import com.farm.mapper.InspectionMapper;
import com.farm.service.InspectionService;
import com.farm.util.HttpSendUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class InspectionServiceImpl
implements InspectionService {
    @Autowired
    private InspectionMapper inspectionMapper;
    @Autowired
    private DetectionElementMapper elementMapper;
    @Autowired
    private CropInfoMapper cropInfoMapper;
    @Value(value="${farm.serverUrl}")
    private String serverUrl;

    public Integer insertInspection(InspectionVO inspection) {
        String s = HttpSendUtil.sendHttpGet((String)(this.serverUrl + "/field-group/queryFieldGroupInList?companyId=" + inspection.getCompanyId() + "&hash=x&userId=" + inspection.getUserId()));
        JSONObject object = JSONObject.parseObject((String)s);
        JSONArray groupList = object.getJSONObject("resData").getJSONArray("list");
        for (int i = 0; i < groupList.size(); ++i) {
            if (!groupList.getJSONObject(i).getInteger("id").equals(inspection.getBaseId())) continue;
            inspection.setBaseName(groupList.getJSONObject(i).getString("groupName"));
        }
        Integer result = this.inspectionMapper.insertSoilInspection((Inspection)inspection);
        this.elementMapper.insertInspectionElement(inspection.getId(), inspection.getElementList());
        if (inspection.getFieldList().size() > 0) {
            this.getFiledInfo(inspection);
            this.inspectionMapper.insertInspectionFieldBatch(inspection.getFieldInfoList(), inspection.getId(), inspection.getType());
        }
        return result;
    }

    public Integer updateInspection(InspectionVO inspection) {
        this.inspectionMapper.deleteInspectionFieldByInspectionIdOrFieldId(inspection.getId(), null);
        this.inspectionMapper.deleteInspectionElementByInspectionIdOrElementId(inspection.getId(), null);
        if (inspection.getFieldList().size() > 0) {
            this.getFiledInfo(inspection);
            this.inspectionMapper.insertInspectionFieldBatch(inspection.getFieldInfoList(), inspection.getId(), inspection.getType());
        }
        this.elementMapper.insertInspectionElement(inspection.getId(), inspection.getElementList());
        return this.inspectionMapper.updateInspection((Inspection)inspection);
    }

    public Integer deleteById(Integer id) {
        this.inspectionMapper.deleteInspectionFieldByInspectionIdOrFieldId(id, null);
        this.inspectionMapper.deleteInspectionElementByInspectionIdOrElementId(id, null);
        return this.inspectionMapper.deleteById(id);
    }

    public JSONObject listInspection(InspectionVO inspection, Integer start, Integer pageSize) {
        JSONObject json = new JSONObject();
        if (inspection.getFieldList() == null || inspection.getFieldList().size() == 0) {
            inspection.setFieldList(null);
        }
        if (inspection.getCropList() == null || inspection.getCropList().size() == 0) {
            inspection.setCropList(null);
        }
        Integer count = this.inspectionMapper.countInspection(inspection);
        List list = this.inspectionMapper.listInspection(inspection, start, pageSize);
        json.put("count", (Object)count);
        json.put("list", (Object)list);
        return json;
    }

    public InspectionVO queryInspectionById(Integer id) {
        InspectionVO inspectionVO = this.inspectionMapper.queryInspectionById(id);
        if (inspectionVO != null) {
            inspectionVO.setElementList(this.elementMapper.listElementByInspectionId(id));
        }
        return inspectionVO;
    }

    public List<CropInfo> listCropInfo(String search) {
        return this.cropInfoMapper.listCropInfo(search);
    }

    public void getFiledInfo(InspectionVO inspection) {
        ArrayList infoList = new ArrayList();
        inspection.getFieldList().stream().forEach(id -> {
            try {
                String s1 = HttpSendUtil.sendHttpGet((String)(this.serverUrl + "field/getFieldInfo?hash=x&fieldId=" + id));
                JSONObject object1 = JSONObject.parseObject((String)s1);
                String fieldName = object1.getJSONObject("resData").getString("fieldName");
                infoList.add(FieldInfo.builder().fieldId(id).fieldName(fieldName).build());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        inspection.setFieldInfoList(infoList);
    }
}

