/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller;

import com.alibaba.fastjson.JSONObject;
import com.farm.service.TaskInfoService;
import com.farm.util.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/task"})
@Api(tags={"\u4efb\u52a1\u76f8\u5173\u63a5\u53e3"})
public class TaskInfoController {
    @Resource
    private TaskInfoService taskInfoService;
    private static final String baseDir = "/Users/benyuan/Desktop/version/";

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u4efb\u52a1\u5217\u8868")
    public Object selectOne(@RequestParam(name="page", required=false, defaultValue="1") Integer page, @RequestParam(name="pageSize", required=false, defaultValue="10") Integer pageSize, @RequestParam(name="operator", required=false, defaultValue="") String operator, @RequestParam(name="taskName", required=false, defaultValue="") String taskName, @RequestParam(name="exeDate", required=false, defaultValue="") String exeDate, @RequestParam(name="baseId", required=false, defaultValue="") Integer baseId) {
        Integer start = (page - 1) * pageSize;
        List list = this.taskInfoService.queryAllByLimit(start, pageSize, operator, taskName, exeDate, baseId);
        Integer count = this.taskInfoService.queryCount(operator, taskName, exeDate, baseId);
        JSONObject json = new JSONObject();
        json.put("list", (Object)list);
        json.put("count", (Object)count);
        return ResultVo.success((Object)json);
    }

    @PostMapping(value={"/del"})
    public Object delete(@RequestParam(value="idList") List<Integer> idList) {
        this.taskInfoService.removeByIds(idList);
        return ResultVo.success();
    }

    @PostMapping(value={"/upsert"})
    @ApiOperation(value="\u65b0\u5efa\u4efb\u52a1")
    public Object upsertTask(@RequestBody String body) {
        JSONObject json = JSONObject.parseObject((String)body);
        this.taskInfoService.upsertTask(json);
        return ResultVo.success();
    }

    @PostMapping(value={"/upload"})
    @ApiOperation(value="\u4e0a\u4f20\u6587\u4ef6\u8fd4\u56de\u5730\u5740")
    public Object uploadFile(@RequestParam(value="file") MultipartFile file) {
        Long timeSecond = LocalDateTime.now().toEpochSecond(ZoneOffset.ofHours(8));
        File versionDir = new File(baseDir + timeSecond);
        if (!versionDir.exists()) {
            Boolean mkFlag = versionDir.mkdirs();
            if (!mkFlag.booleanValue()) {
                versionDir.delete();
                versionDir.mkdirs();
            }
        } else if (!versionDir.isDirectory()) {
            versionDir.delete();
            versionDir.mkdirs();
        }
        String fileUrl = baseDir + timeSecond + "/" + timeSecond + ".zip";
        File toFile = new File(fileUrl);
        try {
            file.transferTo(toFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01");
        }
        JSONObject json = new JSONObject();
        json.put("fileUrl", (Object)fileUrl);
        return ResultVo.success((Object)json);
    }
}

