/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller;

import com.alibaba.fastjson.JSONObject;
import com.farm.bean.AgriserveFertilizePlan;
import com.farm.service.ProductManageService;
import com.farm.util.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.geo.Point;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/agriServe/fertilize"})
@Api(tags={"\u65bd\u80a5\u65b9\u6848\u76f8\u5173\u63a5\u53e3"})
public class AgriserveFertilizePlanController {
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private ProductManageService productManageService;

    @GetMapping(value={"/near"})
    @ApiOperation(value="\u9644\u8fd1\u7684\u65bd\u80a5\u65b9\u6848")
    public ResultVo queryNearPlan(Double lng, Double lat, @RequestParam(value="fieldDoubleStatusId", defaultValue="", required=false) Integer fieldDoubleStatusId, @RequestParam(value="level", defaultValue="", required=false) String level, @RequestParam(value="cropName", defaultValue="", required=false) String cropName) {
        AgriserveFertilizePlan it;
        String phone;
        Point point = new Point(lng.doubleValue(), lat.doubleValue());
        Criteria criteria = Criteria.where((String)"location").near(point);
        if (StringUtils.isNotBlank((String)cropName)) {
            criteria.and("cropName").is((Object)cropName);
        }
        if (StringUtils.isNotBlank((String)level)) {
            criteria.and("targetYield").is((Object)level);
        }
        if (StringUtils.isNotBlank((String)(phone = this.productManageService.queryFieldPhone(fieldDoubleStatusId)))) {
            criteria.and("userPhone").is((Object)phone);
        }
        if ((it = (AgriserveFertilizePlan)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)criteria), AgriserveFertilizePlan.class)) == null) {
            Criteria criteria1 = Criteria.where((String)"location").near(point);
            criteria1.and("userPhone").exists(false);
            if (StringUtils.isNotBlank((String)cropName)) {
                criteria1.and("cropName").is((Object)cropName);
            }
            if (StringUtils.isNotBlank((String)level)) {
                criteria1.and("targetYield").is((Object)level);
            }
            it = (AgriserveFertilizePlan)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)criteria1), AgriserveFertilizePlan.class);
        }
        List list = new ArrayList();
        if (it != null) {
            Criteria criteria2 = Criteria.where((String)"location").is((Object)new Double[]{it.getLocation()[0], it.getLocation()[1]});
            if (StringUtils.isNotBlank((String)it.getUserPhone())) {
                criteria2.and("userPhone").is((Object)it.getUserPhone());
            } else {
                criteria2.and("userPhone").exists(false);
            }
            criteria2.and("cropName").is((Object)it.getCropName()).and("targetYield").is((Object)it.getTargetYield());
            Query query = Query.query((CriteriaDefinition)criteria2);
            query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"_id"}));
            list = this.mongoTemplate.find(query, AgriserveFertilizePlan.class);
        }
        JSONObject json = new JSONObject();
        json.put("list", list);
        return ResultVo.success((Object)json);
    }

    @PostMapping(value={"/add"})
    @ApiOperation(value="\u65b0\u589e\u65bd\u80a5\u65b9\u6848")
    public ResultVo upsertPlan(@RequestBody AgriserveFertilizePlan plan) {
        this.mongoTemplate.insert((Object)plan);
        return ResultVo.success();
    }

    @PostMapping(value={"/pcadd"})
    @ApiOperation(value="PC\u65b0\u589e\u65bd\u80a5\u65b9\u6848")
    public ResultVo upsertPlanByPC(@RequestBody AgriserveFertilizePlan plan) {
        this.mongoTemplate.insert((Object)plan);
        return ResultVo.success();
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u65bd\u80a5\u65b9\u6848\u5217\u8868")
    public Object queryPlanList(@RequestParam(required=false, defaultValue="", value="phone") String phone, @RequestParam(required=false, defaultValue="", value="cropName") String cropName, @RequestParam(required=false, defaultValue="", value="userName") String userName, @RequestParam(required=false, defaultValue="", value="regionCode") String regionCode) {
        Criteria criteria = Criteria.where((String)"phone").is((Object)"");
        Query query = new Query((CriteriaDefinition)criteria);
        List list = this.mongoTemplate.find(query, JSONObject.class, "t_agriserve_fertilize_plan");
        Integer count = 0;
        JSONObject json = new JSONObject();
        json.put("list", (Object)list);
        json.put("count", (Object)count);
        return ResultVo.success((Object)json);
    }
}

