/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.AgriservePublish;
import com.farm.bean.AgriservePublishReply;
import com.farm.service.AgriservePublishService;
import com.farm.util.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/agriServe"})
@Api(tags={"\u519c\u4e1a\u670d\u52a1\u8d34\u76f8\u5173"})
public class AgriservePublishController {
    @Resource
    private AgriservePublishService agriservePublishService;

    @GetMapping(value={"/publish/list"})
    @ApiOperation(value="\u53d1\u5e16\u5217\u8868")
    public ResultVo queryPublishList(@RequestParam(defaultValue="", required=false, value="phone") String phone, @RequestParam(defaultValue="", required=false, value="type") Integer type, @RequestParam(defaultValue="", required=false, value="publishTypes") String publishTypes, @RequestParam(value="mark") Integer mark, @RequestParam(defaultValue="1", required=false, value="page") Integer page, @RequestParam(defaultValue="10", required=false, value="pageSize") Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        JSONObject json = new JSONObject();
        List<Object> pTypeList = new ArrayList();
        if (StringUtils.isNotBlank((String)publishTypes)) {
            pTypeList = Arrays.asList(publishTypes.split(","));
        }
        List list = this.agriservePublishService.queryPublishList(start, pageSize, phone, type, pTypeList, mark);
        Integer count = this.agriservePublishService.queryPublishCount(phone, type, pTypeList, mark);
        json.put("list", (Object)list);
        json.put("count", (Object)count);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/publish/detail"})
    @ApiOperation(value="\u5e16\u5b50\u8be6\u60c5")
    public ResultVo selectOne(String phone, Integer id) {
        JSONObject json = this.agriservePublishService.queryById(id, phone);
        return ResultVo.success((Object)json);
    }

    @PostMapping(value={"/publish/del"})
    @ApiOperation(value="\u5220\u9664\u5e16\u5b50")
    public Object delete(@RequestParam(value="idStr") String idStr) {
        List<String> idList = Arrays.asList(idStr.split(","));
        this.agriservePublishService.removeByIds(idList);
        return ResultVo.success();
    }

    @PostMapping(value={"/publish/upsert"})
    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539\u5e16\u5b50")
    public Object upsertPublish(@RequestBody String body) {
        AgriservePublish publish = (AgriservePublish)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), AgriservePublish.class);
        if (publish.getId() != null) {
            this.agriservePublishService.update(publish);
        } else {
            this.agriservePublishService.insert(publish);
        }
        return ResultVo.success();
    }

    @PostMapping(value={"/star"})
    @ApiOperation(value="\u70b9\u8d5e\u6216\u53d6\u6d88\u5e16\u5b50")
    public Object starPublish(@RequestBody String body) {
        JSONObject json = JSONObject.parseObject((String)body);
        Integer id = json.getInteger("publishid");
        String phone = json.getString("phone");
        JSONObject resJson = this.agriservePublishService.starPublish(phone, id);
        return ResultVo.success((Object)resJson);
    }

    @GetMapping(value={"/reply/list"})
    @ApiOperation(value="\u83b7\u53d6\u5e16\u5b50\u8bc4\u8bba\u5217\u8868")
    public Object queryReplyList(@RequestParam Integer id, @RequestParam(defaultValue="1", required=false, value="page") Integer page, @RequestParam(defaultValue="10", required=false, value="pageSize") Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        JSONObject json = this.agriservePublishService.queryReplyList(id, start, pageSize);
        return ResultVo.success((Object)json);
    }

    @PostMapping(value={"/reply/add"})
    @ApiOperation(value="\u8bc4\u8bba\u5e16\u5b50")
    public Object addReply(@RequestBody String body) {
        AgriservePublishReply reply = (AgriservePublishReply)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), AgriservePublishReply.class);
        reply = this.agriservePublishService.addReply(reply);
        return ResultVo.success((Object)reply);
    }

    @GetMapping(value={"/publish/group-type"})
    @ApiOperation(value="\u5e16\u5b50\u4f9b\u9700\u7edf\u8ba1")
    public Object queryReplyListGroupType() {
        JSONObject json = this.agriservePublishService.queryReplyListGroupType();
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/publish/group-pType"})
    @ApiOperation(value="\u5e16\u5b50\u53d1\u5e03\u9700\u6c42\u5360\u6bd4\u60c5\u51b5")
    public Object queryReplyListGroupPType(@RequestParam(defaultValue="", required=false, value="type") Integer type) {
        List list = this.agriservePublishService.queryReplyListGroupPType(type);
        return ResultVo.success((Object)list);
    }

    @GetMapping(value={"/publish/pc-list"})
    @ApiOperation(value="pc\u519c\u4e8b\u670d\u52a1\u4fe1\u606f\u5217\u8868")
    public Object querySearchPublishList(@RequestParam(defaultValue="", required=false, value="type") Integer type, @RequestParam(defaultValue="", required=false, value="search") String search, @RequestParam(defaultValue="1", required=false, value="page") Integer page, @RequestParam(defaultValue="10", required=false, value="pageSize") Integer limit) {
        Integer start = (page - 1) * limit;
        JSONObject json = this.agriservePublishService.querySearchPublishList(start, limit, type, search);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/publish/summary"})
    @ApiOperation(value="pc\u519c\u4e8b\u670d\u52a1-\u6570\u636e\u7edf\u8ba1")
    public Object querySearchPublishSummary(@RequestParam(defaultValue="", required=false, value="type") Integer type, @RequestParam(defaultValue="", required=false, value="startTime") String startDate, @RequestParam(defaultValue="", required=false, value="endTime") String endDate, @RequestParam(defaultValue="", required=false, value="publishTypes") String publishTypes) {
        List<Object> typeList = new ArrayList();
        if (StringUtils.isNotBlank((String)publishTypes)) {
            typeList = Arrays.asList(publishTypes.split(","));
        }
        if (StringUtils.isNotBlank((String)endDate)) {
            endDate = LocalDate.parse(endDate).plusDays(1L).toString();
        }
        JSONObject json = this.agriservePublishService.querySearchPublishSummary(type, startDate, endDate, typeList);
        return ResultVo.success((Object)json);
    }
}

