/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.FarmserveExpert;
import com.farm.bean.FarmserveExpertImport;
import com.farm.bean.FarmserveExpertQa;
import com.farm.service.FarmserveExpertService;
import com.farm.util.ExcelExpertListener;
import com.farm.util.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/expert"})
@Api(tags={"\u4e13\u5bb6\u670d\u52a1"})
public class FarmserveExpertController {
    @Resource
    private FarmserveExpertService farmserveExpertService;

    @GetMapping(value={"/detail"})
    public Object selectOne(Integer id) {
        FarmserveExpert dto = this.farmserveExpertService.queryById(id);
        return ResultVo.success((Object)dto);
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u4e13\u5bb6\u5217\u8868")
    public Object queryList(@RequestParam(defaultValue="1", required=false, value="page") Integer page, @RequestParam(defaultValue="10", required=false, value="pageSize") Integer limit) {
        Integer offset = (page - 1) * limit;
        List list = this.farmserveExpertService.queryList(offset, limit);
        return ResultVo.success((Object)list);
    }

    @GetMapping(value={"/qa/list"})
    @ApiOperation(value="\u4e13\u5bb6\u95ee\u7b54\u5217\u8868")
    public Object queryExpertQaList(@RequestParam Integer expertId, @RequestParam(defaultValue="1", required=false, value="page") Integer page, @RequestParam(defaultValue="10", required=false, value="pageSize") Integer limit) {
        Integer offset = (page - 1) * limit;
        JSONObject json = this.farmserveExpertService.queryExpertQaList(expertId, offset, limit);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/qa/detail"})
    @ApiOperation(value="\u4e13\u5bb6\u95ee\u7b54\u8be6\u60c5")
    public Object queryExpertQaDetail(@RequestParam Integer id, @RequestParam(defaultValue="1", required=false, value="page") Integer page, @RequestParam(defaultValue="10", required=false, value="pageSize") Integer limit) {
        Integer offset = (page - 1) * limit;
        JSONObject json = this.farmserveExpertService.queryExpertQaDetail(id, offset, limit);
        return ResultVo.success((Object)json);
    }

    @PostMapping(value={"/qa/delSelf"})
    @ApiOperation(value="\u5220\u9664\u81ea\u5df1\u7684\u56de\u590d")
    public Object queryExpertQaDetail(@RequestParam Integer id) {
        this.farmserveExpertService.deleteSelfAndSub(id);
        return ResultVo.success();
    }

    @PostMapping(value={"/qa/tipOff"})
    @ApiOperation(value="\u95ee\u7b54\u4e3e\u62a5")
    public Object tipOffExpertQa(@RequestParam Integer id) {
        JSONObject json = this.farmserveExpertService.tipOffExpertQa(id);
        return ResultVo.success((Object)json);
    }

    @PostMapping(value={"/qa/answer"})
    @ApiOperation(value="\u8bc4\u8bba")
    public Object answerExpertQa(@RequestBody String body) {
        FarmserveExpertQa reply = (FarmserveExpertQa)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), FarmserveExpertQa.class);
        reply = this.farmserveExpertService.answerExpertQa(reply);
        return ResultVo.success((Object)reply);
    }

    @GetMapping(value={"/qa/hot-list"})
    @ApiOperation(value="\u70ed\u95e8\u8bc4\u8bba\u5217\u8868")
    public Object queryHotQaList(@RequestParam(value="search", required=false, defaultValue="") String search, @RequestParam(value="cropIds", required=false) String cropIds, @RequestParam(value="beginDate", required=false) String beginDate, @RequestParam(value="endDate", required=false) String endDate, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize) {
        Integer offset = (page - 1) * pageSize;
        List<Object> cropList = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)cropIds)) {
            cropList = Arrays.asList(cropIds.split(","));
        }
        JSONObject json = this.farmserveExpertService.queryHotQaList(offset, pageSize, cropList, search, beginDate, endDate);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/qa/msg-count"})
    @ApiOperation(value="\u6d88\u606f\u6570\u91cf")
    public Object queryMsgCount(@RequestParam(value="userId") String userId) {
        return ResultVo.success((Object)this.farmserveExpertService.queryMsgCount(userId));
    }

    @GetMapping(value={"/qa/msg-list"})
    @ApiOperation(value="\u6d88\u606f\u5217\u8868")
    public Object queryMsgList(@RequestParam(value="userId") String userId, @RequestParam(value="type") Integer type, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize) {
        Integer offset = (page - 1) * pageSize;
        JSONObject jsonObject = type == 0 ? this.farmserveExpertService.queryAskMsgList(userId, offset, pageSize) : this.farmserveExpertService.queryReplyMsgList(userId, offset, pageSize);
        return ResultVo.success((Object)jsonObject);
    }

    @PostMapping(value={"/qa/read"})
    @ApiOperation(value="\u6d88\u606f\u8bbe\u7f6e\u4e3a\u5df2\u8bfb")
    public Object readMsg(Integer id) {
        this.farmserveExpertService.readMsg(id);
        return ResultVo.success();
    }

    @PostMapping(value={"/upsert"})
    @ApiOperation(value="\u65b0\u589e/\u4fee\u6539")
    public ResultVo upsertExpert(@RequestBody String body) {
        FarmserveExpert farmserveExpert = (FarmserveExpert)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), FarmserveExpert.class);
        boolean existPhone = this.farmserveExpertService.queryExistPhone(farmserveExpert.getPhone());
        if (farmserveExpert.getId() == null) {
            if (existPhone) {
                return ResultVo.error((String)String.format("\u8be5\u624b\u673a\u53f7%s\u5df2\u5b58\u5728", farmserveExpert.getPhone()));
            }
            this.farmserveExpertService.insert(farmserveExpert);
        } else {
            FarmserveExpert dto = this.farmserveExpertService.queryById(farmserveExpert.getId());
            if (!dto.getPhone().equals(farmserveExpert.getPhone()) && existPhone) {
                return ResultVo.error((String)String.format("\u624b\u673a\u53f7\u3010%s\u3011\u5df2\u5b58\u5728", farmserveExpert.getPhone()));
            }
            this.farmserveExpertService.update(farmserveExpert);
        }
        return ResultVo.success();
    }

    @PostMapping(value={"/del"})
    @ApiOperation(value="\u51bb\u7ed3/\u5220\u9664")
    public ResultVo delAndBlockExpert(@RequestParam(value="id") Integer id, @RequestParam(value="block", required=false) Integer block) {
        this.farmserveExpertService.delAndBlockExpert(id, block);
        return ResultVo.success();
    }

    @GetMapping(value={"/page"})
    @ApiOperation(value="\u6761\u4ef6\u67e5\u8be2")
    public ResultVo queryExpertPage(@RequestParam(value="search", required=false, defaultValue="") String search, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        return ResultVo.success((Object)this.farmserveExpertService.queryExpertPage(search, start, pageSize));
    }

    @GetMapping(value={"/qa/page"})
    @ApiOperation(value="\u95ee\u7b54\u5217\u8868")
    public ResultVo queryExpertQaPage(@RequestParam(value="tipOff", required=false) Integer tipOff, @RequestParam(value="search", required=false, defaultValue="") String search, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        return ResultVo.success((Object)this.farmserveExpertService.queryExpertQaPage(tipOff, search, start, pageSize));
    }

    @PostMapping(value={"/qa/del"})
    @ApiOperation(value="\u5220\u9664/\u7f6e\u9876")
    public ResultVo delAndTopExpertQa(@RequestParam(value="id") Integer id, @RequestParam(value="top", required=false) Integer top) {
        this.farmserveExpertService.delAndTopExpertQa(id, top);
        return ResultVo.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/import"})
    @ApiOperation(value="\u6279\u91cf\u5bfc\u5165\u4e13\u5bb6")
    public ResultVo importExpert(@RequestParam(value="file") MultipartFile file) {
        List list = null;
        ExcelExpertListener excelListener = new ExcelExpertListener();
        String errMsg = null;
        InputStream inputStream = null;
        try {
            inputStream = file.getInputStream();
            EasyExcel.read((InputStream)inputStream, FarmserveExpertImport.class, (ReadListener)excelListener).sheet().doRead();
            list = excelListener.getList();
            errMsg = excelListener.getErrMsg();
            if (StringUtils.isNotBlank((CharSequence)errMsg)) {
                ResultVo resultVo = ResultVo.error((String)errMsg);
                return resultVo;
            }
            if (list.size() < 1) {
                ResultVo resultVo = ResultVo.error((String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
                return resultVo;
            }
            List existPhoneList = this.farmserveExpertService.queryExistPhoneList(list);
            if (existPhoneList.size() > 0) {
                ResultVo resultVo = ResultVo.error((String)String.format("\u8be5\u624b\u673a\u53f7%s\u5df2\u5b58\u5728", existPhoneList.toString()));
                return resultVo;
            }
            this.farmserveExpertService.batchInsert(list);
            ResultVo resultVo = ResultVo.success();
            return resultVo;
        }
        catch (Exception e) {
            errMsg = excelListener.getErrMsg();
            if (errMsg == null) {
                errMsg = "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a";
            }
            ResultVo resultVo = ResultVo.error((String)("\u6279\u91cf\u65b0\u589e\u5931\u8d25:" + errMsg));
            return resultVo;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (list != null && list.size() != 0) {
                list.clear();
            }
        }
    }

    @GetMapping(value={"/detail/user"})
    @ApiOperation(value="\u6839\u636euserId\u67e5\u8be6\u60c5")
    public ResultVo queryDetailByUserId(@RequestParam(value="userId") String userId) {
        return ResultVo.success((Object)this.farmserveExpertService.queryDetailByUserId(userId));
    }
}

