/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller;

import com.farm.bean.GrowthPeriod;
import com.farm.service.GrowthPeriodService;
import com.farm.util.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/growth-period"})
@Api(tags={"\u7269\u5019\u671f"})
public class GrowthPeriodController {
    @Autowired
    private GrowthPeriodService growthPeriodService;

    @PostMapping(value={"/upsert"})
    @ApiOperation(value="\u6dfb\u52a0/\u4fee\u6539")
    public ResultVo upsertGrowthPeriod(@RequestBody List<GrowthPeriod> growthPeriodList) {
        growthPeriodList.forEach(growthPeriod -> {
            if (growthPeriod.getId() == null) {
                this.growthPeriodService.insert(growthPeriod);
            } else {
                this.growthPeriodService.update(growthPeriod);
            }
        });
        return ResultVo.success(growthPeriodList);
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u4f5c\u7269\u7269\u5019\u671f\u5217\u8868")
    public ResultVo queryGrowthPeriodByCropType(@RequestParam(value="cropType") Integer cropType, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        return ResultVo.success((Object)this.growthPeriodService.queryGrowthPeriodByCropType(cropType, start, pageSize));
    }

    @PostMapping(value={"/del"})
    @ApiOperation(value="\u5220\u9664")
    public ResultVo deleteGrowthPeriod(@RequestParam(value="idString", required=false, defaultValue="") String idString) {
        List<Object> idList = idString.equals("") ? new ArrayList() : Arrays.asList(idString.split(","));
        this.growthPeriodService.deleteGrowthPeriod(idList);
        return ResultVo.success();
    }

    @GetMapping(value={"/detail"})
    @ApiOperation(value="\u8be6\u60c5")
    public ResultVo queryGrowthPeriodDetail(@RequestParam(value="id") Integer id) {
        return ResultVo.success((Object)this.growthPeriodService.queryGrowthPeriodDetail(id));
    }
}

