/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller;

import com.alibaba.fastjson.JSONObject;
import com.farm.bean.MedicationRecord;
import com.farm.service.InsectService;
import com.farm.util.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/record"})
@Api(tags={"\u6027\u8bf1\u5242\u4e0a\u836f\u8bb0\u5f55"})
public class MedicationRecordController {
    @Autowired
    private InsectService insectService;

    @ApiOperation(value="\u6027\u8bf1\u5242\u7c7b\u578b\u4ee5\u53ca\u8bbe\u5907\u5730\u5740")
    @GetMapping(value={"/queryTypeAndAddress"})
    public ResultVo queryTypeAndAddress() {
        JSONObject js = this.insectService.queryTypeAndAddress();
        return ResultVo.success((Object)js);
    }

    @ApiOperation(value="\u589e\u52a0/\u4fee\u6539\u4e0a\u836f\u8bb0\u5f55")
    @PostMapping(value={"/upsert"})
    public ResultVo upsert(@RequestBody MedicationRecord record) {
        this.insectService.upsert(record);
        return ResultVo.success();
    }

    @ApiOperation(value="\u4e0a\u836f\u8bb0\u5f55\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/queryAllRecords"})
    public ResultVo queryAllRecords(@RequestParam(value="type", required=false) String type, @RequestParam(value="operate", required=false) String operate, @RequestParam(value="startTime", required=false) String startTime, @RequestParam(value="endTime", required=false) String endTime, @RequestParam(value="page", required=false, defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize) {
        Integer start = (pageNum - 1) * pageSize;
        JSONObject jsonObject = this.insectService.queryAllRecords(type, operate, startTime, endTime, start, pageSize);
        return ResultVo.success((Object)jsonObject);
    }

    @ApiOperation(value="\u5220\u9664\u4e0a\u836f\u8bb0\u5f55")
    @PostMapping(value={"/deleteRecords"})
    public ResultVo deleteRecords(@RequestParam(value="list") List<Integer> list) {
        this.insectService.deleteRecords(list);
        return ResultVo.success();
    }
}

