/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.api.utils.StringUtils;
import com.codingcube.simpleauth.limit.annotation.SimpleLimit;
import com.farm.bean.ZnmField;
import com.farm.bean.resultMap.FieldInfoResultMap;
import com.farm.service.ConfigService;
import com.farm.service.ProductManageService;
import com.farm.util.HttpSendUtil;
import com.farm.util.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.time.LocalDate;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u751f\u4ea7\u7ba1\u7406\u7cfb\u7edf"})
@RequestMapping(value={"/pdManage"})
public class ProductManageController {
    private static final Logger log = LoggerFactory.getLogger(ProductManageController.class);
    @Value(value="${farm.serverUrl}")
    private String farmServerUrl;
    @Autowired
    private ProductManageService productManageService;
    @Autowired
    private ConfigService configService;

    @GetMapping(value={"/queryWeather"})
    @ApiOperation(value="\u83b7\u53d6\u4e09\u5929\u5929\u6c14\u4fe1\u606f ")
    public Object queryWeather(@RequestParam(name="xAxis") String xAxis, @RequestParam(name="phone") String phone, @RequestParam(name="yAxis") String yAxis) {
        this.configService.postUserActivities("1001", phone);
        String url = this.farmServerUrl + "weixinrequest/getPhoneIndexWeather?yAxis=" + yAxis + "&xAxis=" + xAxis + "&hash=x";
        try {
            String result = HttpSendUtil.sendHttpGet((String)url);
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return ResultVo.success();
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u5929\u5929\u6c14\u6570\u636e\u8be6\u60c5")
    @GetMapping(value={"/queryWeatherDetail"})
    public Object queryWeatherDetail(@RequestParam(name="xAxis") String xAxis, @RequestParam(name="phone", defaultValue="", required=false) String phone, @RequestParam(name="yAxis") String yAxis) {
        if (!StringUtils.isBlank((CharSequence)phone)) {
            this.configService.postUserActivities("1002", phone);
        }
        String url = this.farmServerUrl + "weixinrequest/getWeatherBaseInfo?yAxis=" + yAxis + "&xAxis=" + xAxis + "&hash=x";
        try {
            String result = HttpSendUtil.sendHttpGet((String)url);
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return ResultVo.success();
        }
    }

    @ApiOperation(value="\u83b7\u53d615\u5929\u5185\u7684\u5929\u6c14\u5217\u8868")
    @GetMapping(value={"/queryWeatherDays"})
    public Object queryWeatherDays(@RequestParam(name="cityCode") String cityCode, @RequestParam(name="phone") String phone) {
        this.configService.postUserActivities("1003", phone);
        String url = this.farmServerUrl + "weixinrequest/getWeatherSeriesInfo?cityCode=" + cityCode + "&hash=x";
        try {
            String result = HttpSendUtil.sendHttpGet((String)url);
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return ResultVo.success();
        }
    }

    @ApiOperation(value="\u6839\u636e\u8ddd\u79bb\u6392\u5e8f\u67e5\u8be2\u5f53\u524d\u7528\u6237\u7684\u7530\u5757\u4fe1\u606f")
    @GetMapping(value={"/queryFieldByDistance"})
    public Object queryFieldByDistance(@RequestParam(name="xAxis") String xAxis, @RequestParam(name="yAxis") String yAxis, @RequestParam(name="cropSubId", required=false, defaultValue="") String cropSubId, @RequestParam(name="search", required=false, defaultValue="") String search, @RequestParam(name="page", required=false, defaultValue="1") Integer page, @RequestParam(name="pageSize", required=false, defaultValue="10") Integer pageSize, @RequestParam(name="phone") String phone, @RequestParam(name="mark", required=false) Integer mark, @RequestParam(name="regionCode", required=false) String regionCode) {
        this.configService.postUserActivities("1004", phone);
        JSONObject json = this.productManageService.queryFieldByDistance(xAxis, yAxis, cropSubId, search, page, pageSize, phone, mark, regionCode);
        return ResultVo.success((Object)json);
    }

    @ApiOperation(value="\u6839\u636e\u9762\u79ef\u6392\u5e8f\u67e5\u8be2\u5f53\u524d\u7528\u6237\u7684\u7530\u5757\u4fe1\u606f ")
    @GetMapping(value={"/queryFieldByArea"})
    public Object queryFieldByArea(@RequestParam(name="cropSubId", required=false, defaultValue="") String cropSubId, @RequestParam(name="page", required=false, defaultValue="1") Integer page, @RequestParam(name="pageSize", required=false, defaultValue="10") Integer pageSize, @RequestParam(name="search", required=false, defaultValue="") String search, @RequestParam(name="phone") String phone, @RequestParam(name="mark", required=false) Integer mark, @RequestParam(name="regionCode", required=false) String regionCode) {
        this.configService.postUserActivities("1005", phone);
        JSONObject json = this.productManageService.queryFieldByArea(cropSubId, page, pageSize, search, phone, mark, regionCode);
        return ResultVo.success((Object)json);
    }

    @ApiOperation(value="\u67e5\u8be2\u7530\u5757\u8be6\u60c5\u4fe1\u606f ")
    @GetMapping(value={"/queryFieldDetailInfo"})
    public Object queryFieldDetailInfo(@RequestParam(value="fieldDoubleStatusId") Integer fieldDoubleStatusId, @RequestParam(name="phone", defaultValue="", required=false) String phone) {
        if (!StringUtils.isBlank((CharSequence)phone)) {
            this.configService.postUserActivities("1006", phone);
        }
        JSONObject json = this.productManageService.queryFieldDetailInfo(fieldDoubleStatusId, phone);
        return ResultVo.success((Object)json);
    }

    @ApiOperation(value="\u67e5\u8be2\u7530\u5757\u8be6\u60c5\u4fe1\u606f ")
    @GetMapping(value={"/znm/field-detail"})
    public Object detailFieldDetailByZnm(String code) {
        JSONObject json = new JSONObject();
        ZnmField fieldZnm = this.productManageService.detailFieldIdByZnm(code);
        if (fieldZnm != null && fieldZnm.getFieldId() != null) {
            json = this.productManageService.queryFieldDetailInfo(fieldZnm.getFieldId(), "");
            json.put("znmInfo", (Object)fieldZnm);
        }
        return ResultVo.success((Object)json);
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7ecf\u7eac\u5ea6\u7684\u79ef\u6e29\u79ef\u96e8\u5892\u60c5\u6570\u636e")
    @GetMapping(value={"/getDaySoilWeatherInfo"})
    public Object getDaySoilWeatherInfo(@RequestParam(name="xAxis") String xAxis, @RequestParam(name="cropSubId") Integer cropSubId, @RequestParam(name="phone") String phone, @RequestParam(name="yAxis") String yAxis) {
        if (!StringUtils.isBlank((CharSequence)phone)) {
            this.configService.postUserActivities("1007", phone);
        }
        LocalDate date = LocalDate.now();
        String url = cropSubId != null && (cropSubId == 3 || cropSubId == 4 || cropSubId == 5) ? this.farmServerUrl + "field/getDaySoilWeatherInfoByCropLy?cropSubId=" + cropSubId + "&xAxis=" + xAxis + "&yAxis=" + yAxis + "&year=" + date.getYear() + "&hash=x" : this.farmServerUrl + "field/getDaySoilWeatherInfoLy?xAxis=" + xAxis + "&yAxis=" + yAxis + "&year=" + date.getYear() + "&hash=x";
        try {
            return HttpSendUtil.sendHttpGet((String)url);
        }
        catch (IOException e) {
            e.printStackTrace();
            return ResultVo.success();
        }
    }

    @ApiOperation(value="\u65b0\u589e\u7530\u5757\u4fe1\u606f ")
    @PostMapping(value={"/addFieldInfo"})
    public Object addFieldInfo(@RequestBody JSONObject fieldJson) {
        FieldInfoResultMap fieldInfo = (FieldInfoResultMap)JSONObject.toJavaObject((JSON)fieldJson, FieldInfoResultMap.class);
        if (fieldInfo.getArea() >= 5000.0) {
            return ResultVo.error((String)"\u5708\u7530\u9762\u79ef\u8fc7\u5927");
        }
        Integer code = 330825;
        try {
            boolean index = this.productManageService.validateFieldInArea(fieldInfo.getBoundary(), code);
            if (!index) {
                return ResultVo.error((String)"\u8bf7\u5728\u8303\u56f4\u5185\u5708\u7530");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return ResultVo.error((String)"\u8bf7\u68c0\u67e5\u8fb9\u754c\u662f\u5426\u4ea4\u53c9");
        }
        try {
            String regionCode = this.productManageService.queryRegionCodeInArea(Double.valueOf(Double.parseDouble(fieldInfo.getLng())), Double.valueOf(Double.parseDouble(fieldInfo.getLat())));
            fieldInfo.setRegionCode(regionCode);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        this.productManageService.addFieldInfo(fieldInfo);
        this.configService.postUserActivities("1008", fieldInfo.getPhone());
        return ResultVo.success((Object)fieldInfo);
    }

    @ApiOperation(value="\u4fee\u6539\u7530\u5757\u4fe1\u606f ")
    @PostMapping(value={"/updateFieldInfo"})
    public Object updateFieldInfo(@RequestBody JSONObject fieldJson) {
        FieldInfoResultMap fieldInfo = (FieldInfoResultMap)JSONObject.toJavaObject((JSON)fieldJson, FieldInfoResultMap.class);
        if (fieldInfo.getArea() >= 5000.0) {
            return ResultVo.error((String)"\u5708\u7530\u9762\u79ef\u8fc7\u5927");
        }
        Integer code = 330825;
        fieldInfo.setId(fieldInfo.getFieldDoubleStatusId());
        try {
            boolean index = this.productManageService.validateFieldInArea(fieldInfo.getBoundary(), code);
            if (!index) {
                return ResultVo.error((String)"\u8bf7\u5728\u8303\u56f4\u5185\u5708\u7530");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return ResultVo.error((String)"\u8bf7\u68c0\u67e5\u8fb9\u754c\u662f\u5426\u4ea4\u53c9");
        }
        try {
            String regionCode = this.productManageService.queryRegionCodeInArea(Double.valueOf(Double.parseDouble(fieldInfo.getLng())), Double.valueOf(Double.parseDouble(fieldInfo.getLat())));
            fieldInfo.setRegionCode(regionCode);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        this.productManageService.updateFieldInfo(fieldInfo);
        this.configService.postUserActivities("1009", fieldInfo.getPhone());
        return ResultVo.success((Object)fieldInfo);
    }

    @ApiOperation(value="\u67e5\u8be2\u75c5\u866b\u5bb3\u7684\u5217\u8868")
    @GetMapping(value={"/queryInsectList"})
    public Object queryInsectList(@RequestParam(name="page", required=false, defaultValue="1") Integer page, @RequestParam(name="phone") String phone, @RequestParam(name="cropSubId", required=false, defaultValue="") String cropSubId, @RequestParam(name="pageSize", required=false, defaultValue="10") Integer pageSize) {
        this.configService.postUserActivities("1010", phone);
        Integer begin = (page - 1) * pageSize;
        JSONObject json = this.productManageService.queryInsectList(begin, pageSize, cropSubId);
        return ResultVo.success((Object)json);
    }

    @ApiOperation(value="\u67e5\u8be2\u75c5\u866b\u5bb3\u7684\u8be6\u60c5")
    @GetMapping(value={"/queryInsectDetail"})
    public Object queryInsectDetail(@RequestParam(name="id") Integer id, @RequestParam(name="phone") String phone) {
        this.configService.postUserActivities("1011", phone);
        JSONObject json = this.productManageService.queryInsectDetail(id);
        return ResultVo.success((Object)json);
    }

    @ApiOperation(value="\u67e5\u8be2\u4f5c\u7269\u7684\u751f\u80b2\u671f")
    @GetMapping(value={"/queryGrowthPeriod"})
    public Object queryGrowthPeriod(@RequestParam(name="xAxis") String xAxis, @RequestParam(name="cropSubName") String cropSubName, @RequestParam(name="phone") String phone, @RequestParam(name="yAxis") String yAxis) {
        this.configService.postUserActivities("1012", phone);
        String url = this.farmServerUrl + "field/queryGrowthPeriod?xAxis=" + xAxis + "&yAxis=" + yAxis + "&cropSubName=" + cropSubName;
        try {
            String result = HttpSendUtil.sendHttpGet((String)url);
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return ResultVo.success();
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u4f5c\u7269\u7684\u751f\u80b2\u671f\u8be6\u60c5")
    @GetMapping(value={"/queryGrowthPeriodDetail"})
    public Object queryGrowthPeriodDetail(@RequestParam(name="growthName") String growthName, @RequestParam(name="phone", defaultValue="", required=false) String phone, @RequestParam(name="cropSubId") Integer cropSubId) {
        if (!StringUtils.isBlank((CharSequence)phone)) {
            this.configService.postUserActivities("1013", phone);
        }
        String url = this.farmServerUrl + "field/queryGrowthPeriodDetail?growthName=" + growthName + "&cropSubId=" + cropSubId;
        try {
            String result = HttpSendUtil.sendHttpGet((String)url);
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return ResultVo.success();
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u6d88\u606f\u5217\u8868")
    @GetMapping(value={"/queryMessageCenter"})
    public Object queryMessageCenter(@RequestParam(name="page", required=false, defaultValue="1") Integer page, @RequestParam(name="phone") String phone, @RequestParam(name="fieldDoubleStatusId", required=false, defaultValue="") String fieldDoubleStatusId, @RequestParam(name="types", required=false, defaultValue="") String types, @RequestParam(name="pageSize", required=false, defaultValue="10") Integer pageSize) {
        this.configService.postUserActivities("1014", phone);
        Integer begin = (page - 1) * pageSize;
        JSONObject json = this.productManageService.queryMessageCenter(phone, begin, pageSize, types, fieldDoubleStatusId);
        return ResultVo.success((Object)json);
    }

    @ApiOperation(value="\u91cd\u5927\u707e\u5bb3\u7edf\u8ba1")
    @GetMapping(value={"/queryDisasterWeatherCount"})
    public Object queryDisasterWeatherCount(@RequestParam(name="phone") String phone, @RequestParam(name="year") Integer year) {
        this.configService.postUserActivities("1015", phone);
        JSONObject json = this.productManageService.queryDisasterWeatherCount(year);
        return ResultVo.success((Object)json);
    }

    @PostMapping(value={"/upsertDisasterWeatherCount"})
    public ResultVo upsertDisasterWeatherCount(@RequestParam(value="label") String label, @RequestParam(value="count") Integer count, @RequestParam(value="year") Integer year) {
        this.productManageService.upsertDisasterWeatherCount(label, count, year);
        return ResultVo.success();
    }

    @ApiOperation(value="\u83b7\u53d6\u7ecf\u7eac\u5ea6\u7684\u6d77\u62d4\u5761\u5ea6")
    @GetMapping(value={"/querySlopeElevation"})
    public Object querySlopeElevation(@RequestParam(value="phone") String phone, @RequestParam(name="xAxis") String xAxis, @RequestParam(name="yAxis") String yAxis) {
        this.configService.postUserActivities("1016", phone);
        String url = this.farmServerUrl + "field/getSlopeElevation?yAxis=" + yAxis + "&xAxis=" + xAxis + "&hash=x&boundary=1";
        try {
            String result = HttpSendUtil.sendHttpPost((String)url, (String)"", (String)"", (String)"");
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return ResultVo.success();
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u7530\u5757\u571f\u58e4\u80a5\u529b ")
    @GetMapping(value={"/queryFieldSoilInfo"})
    public Object queryFieldSoilInfo(@RequestParam(value="fieldDoubleStatusId") Integer fieldDoubleStatusId, @RequestParam(value="phone", required=false, defaultValue="") String phone) {
        this.configService.postUserActivities("1017", phone);
        return this.productManageService.queryFieldSoilInfo(fieldDoubleStatusId, phone);
    }

    @ApiOperation(value="\u83b7\u53d6 \u571f\u58e4\u5892\u60c5\u548c\u6e29\u5ea6\u63a5\u53e3 ")
    @GetMapping(value={"/querySolieSqTemp"})
    public Object querySolieSqTemp(@RequestParam(value="phone") String phone, @RequestParam(name="xAxis") String xAxis, @RequestParam(name="year") Integer year, @RequestParam(name="cropSubId", required=false) Integer cropSubId, @RequestParam(name="yAxis") String yAxis) {
        this.configService.postUserActivities("1018", phone);
        return this.productManageService.querySolieSqTemp(xAxis, yAxis, year, cropSubId);
    }

    @ApiOperation(value="\u83b7\u53d6\u79ef\u6e29\u79ef\u96e8")
    @GetMapping(value={"/getAccuWeather"})
    public Object getAccuWeather(@RequestParam(value="phone") String phone, @RequestParam(name="xAxis") String xAxis, @RequestParam(name="year") Integer year, @RequestParam(name="yAxis") String yAxis) {
        this.configService.postUserActivities("1019", phone);
        return this.productManageService.getAccuWeather(xAxis, yAxis, year);
    }

    @ApiOperation(value="\u67e5\u8be2\u7530\u5757\u5173\u8054\u7684\u75c5\u866b\u5bb3\u4fe1\u606f")
    @GetMapping(value={"/queryInsectListByFieldId"})
    public Object queryInsectListByFieldId(@RequestParam(name="page", required=false, defaultValue="1") Integer page, @RequestParam(name="phone") String phone, @RequestParam(name="cropSubId", required=false, defaultValue="") String cropSubId, @RequestParam(name="fieldDoubleStatusId") String fieldDoubleStatusId, @RequestParam(name="pageSize", required=false, defaultValue="10") Integer pageSize) {
        this.configService.postUserActivities("1020", phone);
        Integer begin = (page - 1) * pageSize;
        JSONObject json = this.productManageService.queryInsectListByFieldId(phone, begin, pageSize, fieldDoubleStatusId, cropSubId);
        return ResultVo.success((Object)json);
    }

    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u5708\u7530\u8303\u56f4")
    @GetMapping(value={"/queryUserFieldRange"})
    public Object queryUserFieldRange(@RequestParam(name="phone") String phone) {
        this.configService.postUserActivities("1021", phone);
        Integer code = 330825;
        JSONObject json = this.productManageService.queryUserFieldRange(phone, code);
        return ResultVo.success((Object)json);
    }

    @ApiOperation(value="\u5224\u65ad\u5708\u7530\u662f\u5426\u5728\u9f99\u6e38\u8303\u56f4\u5185")
    @GetMapping(value={"/validateFieldInArea"})
    public Object validateFieldInArea(@RequestParam(name="boundary") String boundary, @RequestParam(name="phone") String phone) {
        this.configService.postUserActivities("1022", phone);
        Integer code = 330825;
        try {
            boolean index = this.productManageService.validateFieldInArea(boundary, code);
            return ResultVo.success((Object)index);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return ResultVo.error((String)"\u8bf7\u68c0\u67e5\u8fb9\u754c\u662f\u5426\u4ea4\u53c9");
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u7ecf\u7eac\u5ea6\u5bf9\u5e94\u7684\u5730\u5740")
    @GetMapping(value={"/queryAddressByXY"})
    public Object queryAddressByXY(@RequestParam(name="lng") String lng, @RequestParam(name="lat") String lat, @RequestParam(name="phone") String phone) {
        String url = "http://119.3.228.0:8083/lyFormatAddress?lng=" + lng + "&lat=" + lat;
        try {
            String result = HttpSendUtil.sendHttpGet((String)url);
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return ResultVo.error();
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u5c5e\u533a\u57df ")
    @GetMapping(value={"/regionCode"})
    public Object queryRegionCodeInArea(@RequestParam Double lng, @RequestParam Double lat) {
        String regionCode = this.productManageService.queryRegionCodeInArea(lng, lat);
        return ResultVo.success((Object)regionCode);
    }

    @ApiOperation(value="\u5220\u9664\u7528\u6237\u7530")
    @PostMapping(value={"/field/del"})
    public Object delUserField(@RequestParam String phone, @RequestParam Integer fieldId) {
        this.productManageService.delUserField(phone, fieldId);
        return ResultVo.success();
    }

    @SimpleLimit(value=5, seconds=6, ban=10)
    @ApiOperation(value="\u6839\u636e\u8ddd\u79bb\u6392\u5e8f\u67e5\u8be2\u5f53\u524d\u7528\u6237\u7684\u7530\u5757\u4fe1\u606f")
    @GetMapping(value={"/api/queryFieldByDistance"})
    public Object queryFieldByDistanceApi(HttpServletRequest request, @RequestParam(name="xAxis") String xAxis, @RequestParam(name="yAxis") String yAxis, @RequestParam(name="cropSubId", required=false, defaultValue="") String cropSubId, @RequestParam(name="search", required=false, defaultValue="") String search, @RequestParam(name="page", required=false, defaultValue="1") Integer page, @RequestParam(name="pageSize", required=false, defaultValue="10") Integer pageSize, @RequestParam(name="phone") String phone, @RequestParam(name="mark", required=false) Integer mark, @RequestParam(name="regionCode", required=false) String regionCode) {
        String secret = request.getHeader("Secret");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)secret) || !org.apache.commons.lang3.StringUtils.equals((CharSequence)secret, (CharSequence)"cadd82c8ec2a4cd9b6153de80c4ef082")) {
            return ResultVo.error((String)"\u9a8c\u8bc1\u5931\u8d25");
        }
        this.configService.postUserActivities("1004", phone);
        if (pageSize > 1000) {
            pageSize = 1000;
        }
        JSONObject json = this.productManageService.queryFieldByDistance(xAxis, yAxis, cropSubId, search, page, pageSize, phone, mark, regionCode);
        return ResultVo.success((Object)json);
    }
}

