/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.resultMap.ShopInfoResultMap;
import com.farm.bean.resultMap.ShopProductResultMap;
import com.farm.service.ServeService;
import com.farm.util.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u793e\u4f1a\u5316\u670d\u52a1\u7cfb\u7edf"})
@RequestMapping(value={"/serve"})
public class ServeController {
    @Autowired
    private ServeService serveService;

    @GetMapping(value={"/queryUserShopInfo"})
    @ApiOperation(value="\u6839\u636e\u624b\u673a\u53f7\u67e5\u8be2\u7528\u6237\u7684\u5e97\u94fa\u4fe1\u606f ")
    public Object queryUserShopInfo(@RequestParam(name="phone") String phone) {
        return this.serveService.queryUserShopInfo(phone);
    }

    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539 \u7528\u6237\u5e97\u94fa\u4fe1\u606f ")
    @PostMapping(value={"/addOrUpdateShopInfo"})
    public ResultVo addOrUpdateShopInfo(@RequestBody JSONObject shopJson) {
        ShopInfoResultMap shopInfo = (ShopInfoResultMap)JSONObject.toJavaObject((JSON)shopJson, ShopInfoResultMap.class);
        return this.serveService.addOrUpdateShopInfo(shopInfo);
    }

    @ApiOperation(value="\u6839\u636e\u5e97\u94faid\u67e5\u8be2\u5e97\u94fa\u7684\u5546\u54c1\u5217\u8868 ")
    @GetMapping(value={"/queryShopProductList"})
    public Object queryShopProduct(@RequestParam(name="shopId") Integer shopId, @RequestParam(name="productType", required=false, defaultValue="") String productType, @RequestParam(name="page", required=false, defaultValue="1") Integer page, @RequestParam(name="pageSize", required=false, defaultValue="10") Integer pageSize) {
        Integer begin = (page - 1) * pageSize;
        JSONObject json = this.serveService.queryShopProductList(shopId, productType, begin, pageSize);
        return ResultVo.success((Object)json);
    }

    @ApiOperation(value="\u6839\u636e\u624b\u673a\u53f7\u67e5\u8be2\u5e97\u94fa\u7684\u5546\u54c1\u5217\u8868 ")
    @GetMapping(value={"/queryShopProductListByPhone"})
    public Object queryShopProductByPhone(@RequestParam(name="phone") String phone, @RequestParam(name="productType", required=false, defaultValue="") String productType, @RequestParam(name="page", required=false, defaultValue="1") Integer page, @RequestParam(name="pageSize", required=false, defaultValue="10") Integer pageSize) {
        Integer begin = (page - 1) * pageSize;
        JSONObject json = this.serveService.queryShopProductListByPhone(phone, productType, begin, pageSize);
        return ResultVo.success((Object)json);
    }

    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539\u5546\u54c1 ")
    @PostMapping(value={"/addOrUpdateProduct"})
    public Object addOrUpdateProduct(@RequestBody JSONObject productJson) {
        ShopProductResultMap product = (ShopProductResultMap)JSONObject.toJavaObject((JSON)productJson, ShopProductResultMap.class);
        this.serveService.addOrUpdateProduct(product);
        return ResultVo.success();
    }

    @ApiOperation(value="\u7528\u6237\u5220\u9664\u5546\u54c1 ")
    @PostMapping(value={"/delProduct"})
    public Object delProduct(@RequestParam(name="shopId") Integer shopId, @RequestParam(name="productId") String productId) {
        this.serveService.delProduct(shopId, productId);
        return ResultVo.success();
    }

    @ApiOperation(value="\u67e5\u8be2\u5339\u914d\u7684\u5546\u94fa\u5217\u8868")
    @GetMapping(value={"/queryMatchingShop"})
    public Object queryMatchingShop(@RequestParam(value="types") String types, @RequestParam(value="xAxis") String xAxis, @RequestParam(value="yAxis") String yAxis) {
        return this.serveService.queryMatchingShop(types, xAxis, yAxis);
    }

    @ApiOperation(value="\u4e00\u952e\u63a8\u9001\u5339\u914d\u7684\u5546\u94fa\u5217\u8868")
    @PostMapping(value={"/sendShopMsg"})
    public Object sendShopMsg(@RequestParam(value="shopIds") String shopIds, @RequestParam(value="sendUserPhone") String sendUserPhone, @RequestParam(value="cropSubId") String cropSubId, @RequestParam(value="productType") String productType) {
        return this.serveService.sendShopMsg(shopIds, sendUserPhone, cropSubId, productType);
    }

    @ApiOperation(value="\u67e5\u8be2\u670d\u52a1\u63d0\u9192\u5217\u8868")
    @GetMapping(value={"/queryShopMsgList"})
    public Object queryShopMsgList(@RequestParam(value="phone") String phone, @RequestParam(name="page", required=false, defaultValue="1") Integer page, @RequestParam(name="pageSize", required=false, defaultValue="10") Integer pageSize) {
        Integer begin = (page - 1) * pageSize;
        JSONObject json = this.serveService.queryShopMsgList(phone, begin, pageSize);
        return ResultVo.success((Object)json);
    }

    @ApiOperation(value="\u66f4\u65b0\u670d\u52a1\u63d0\u9192\u72b6\u6001")
    @PostMapping(value={"/updateShopMsg"})
    public Object updateShopMsg(@RequestParam(value="phone") String phone, @RequestParam(value="status") Integer status, @RequestParam(name="id") Integer id) {
        this.serveService.updateShopMsg(phone, id, status);
        return ResultVo.success();
    }

    @ApiOperation(value="\u66f4\u65b0\u5546\u94fa\u4e0e\u4ea7\u54c1")
    @GetMapping(value={"/updateShopAndProduct"})
    public Object updateShopAndProduct(@RequestParam(value="phone") String phone) {
        this.serveService.updateShopAndProduct(phone);
        return ResultVo.success();
    }

    @GetMapping(value={"/pc-list"})
    @ApiOperation(value="\u540e\u53f0\u8ba4\u8bc1\u7ba1\u7406\u5217\u8868")
    public Object queryShopList(@RequestParam(value="search", required=false, defaultValue="") String search, @RequestParam(name="page", required=false, defaultValue="1") Integer page, @RequestParam(name="pageSize", required=false, defaultValue="10") Integer limit) {
        Integer offset = (page - 1) * limit;
        JSONObject json = this.serveService.queryShopList(search, offset, limit);
        return ResultVo.success((Object)json);
    }

    @PostMapping(value={"/del"})
    @ApiOperation(value="\u5220\u9664\u5e97\u94fa")
    public Object delShop(@RequestBody List<Integer> idList) {
        this.serveService.delShop(idList);
        return ResultVo.success();
    }

    @PostMapping(value={"/addShop"})
    @ApiOperation(value="\u65b0\u589e\u5e97\u94fa\u53ca\u5546\u54c1")
    public Object delShop(@RequestBody JSONObject json) {
        ShopInfoResultMap shop = (ShopInfoResultMap)JSONObject.toJavaObject((JSON)json, ShopInfoResultMap.class);
        ShopInfoResultMap finalShop = this.serveService.addOrUpdateShop(shop);
        if (finalShop.getId() == null) {
            throw new RuntimeException("\u7528\u6237\u624b\u673a\u53f7\u5df2\u5b58\u5728");
        }
        List productList = JSONArray.parseArray((String)json.getJSONArray("list").toString(), ShopProductResultMap.class);
        productList.stream().forEach(product -> {
            product.setShopId(finalShop.getId());
            this.serveService.addOrUpdateProduct(product);
        });
        return ResultVo.success();
    }
}

