/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller;

import com.alibaba.fastjson.JSONObject;
import com.farm.bean.Company;
import com.farm.bean.UserCenter;
import com.farm.service.CompanyService;
import com.farm.service.ProductManageService;
import com.farm.service.UserCenterService;
import com.farm.util.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4e2a\u4eba\u4e2d\u5fc3\u4fe1\u606f"})
@RequestMapping(value={"/user-center"})
public class UserCenterController {
    @Autowired
    private UserCenterService userCenterService;
    @Autowired
    private CompanyService companyService;
    @Autowired
    private ProductManageService productManageService;

    @GetMapping(value={"/userInfo"})
    @ApiOperation(value="\u6839\u636euserId\u83b7\u53d6\u4e2a\u4eba\u4e2d\u5fc3\u4fe1\u606f")
    public ResultVo queryUserInfoByUserId(@RequestParam(value="userId") String userId) {
        UserCenter userCenter = this.userCenterService.queryUserInfoByUserId(userId);
        return ResultVo.success((Object)userCenter);
    }

    @PostMapping(value={"/upsert"})
    @ApiOperation(value="\u6dfb\u52a0/\u4fee\u6539\u7528\u6237\u4fe1\u606f")
    public ResultVo updateUserInfo(@RequestParam(value="name") String name, @RequestParam(value="phone") String phone, @RequestParam(value="card") String card, @RequestParam(value="address") String address, @RequestParam(value="accountBank") String accountBank, @RequestParam(value="bankCard") String bankCard, @RequestParam(value="userId") String userId, @RequestParam(value="avatar") String avatar) {
        this.userCenterService.upsertUserInfo(name, phone, card, address, accountBank, bankCard, userId, avatar);
        return ResultVo.success();
    }

    @PostMapping(value={"/company/upsert"})
    @ApiOperation(value="\u6dfb\u52a0/\u4fee\u6539\u4f01\u4e1a\u4fe1\u606f")
    public ResultVo insertCompanyInfo(@RequestParam(value="id") Integer id, @RequestParam(value="userId") String userId, @RequestParam(value="companyName") String companyName, @RequestParam(value="businessLicensePics") String businessLicensePics, @RequestParam(value="socialCreditCode") String socialCreditCode, @RequestParam(value="lng", required=false) Double lng, @RequestParam(value="lat", required=false) Double lat, @RequestParam(value="address") String address, @RequestParam(value="representName") String representName, @RequestParam(value="representCard") String representCard, @RequestParam(value="representPhone") String representPhone, @RequestParam(value="accountBank") String accountBank, @RequestParam(value="bankCard") String bankCard) {
        this.companyService.upsertCompanyInfo(new Company(id, userId, companyName, businessLicensePics, socialCreditCode, lng, lat, address, representName, representCard, representPhone, accountBank, bankCard));
        return ResultVo.success();
    }

    @GetMapping(value={"/company/detail"})
    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u4f01\u4e1a\u4fe1\u606f")
    public ResultVo queryCompanyInfoByCompanyId(@RequestParam(value="companyId", required=false) Integer companyId, @RequestParam(value="userId", required=false) String userId) {
        return ResultVo.success((Object)this.companyService.queryCompanyInfoByCompanyId(companyId, userId));
    }

    @GetMapping(value={"/fieldList"})
    @ApiOperation(value="\u7528\u6237\u9644\u8fd1\u7684\u7530")
    public Object queryUserNearFieldList(@RequestParam(defaultValue="", required=false, value="lng") Double lng, @RequestParam(defaultValue="", required=false, value="lat") Double lat, @RequestParam(defaultValue="", required=false, value="userId") String userId, @RequestParam(defaultValue="", required=false, value="regionCode") String regionCode, @RequestParam(defaultValue="", required=false, value="fieldName") String fieldName, @RequestParam(defaultValue="", required=false, value="cropSubId") Integer cropSubId, @RequestParam(defaultValue="1", required=false, value="page") Integer page, @RequestParam(defaultValue="10", required=false, value="pageSize") Integer pageSize) {
        Integer offset = (page - 1) * pageSize;
        JSONObject json = this.userCenterService.queryUserNearFieldList(offset, pageSize, lng, lat, regionCode, userId, fieldName, cropSubId);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/regionCode"})
    public ResultVo queryRegionCodeByLocation(@RequestParam(value="lng") Double lng, @RequestParam(value="lat") Double lat) {
        return ResultVo.success((Object)this.productManageService.queryRegionCodeInArea(lng, lat));
    }

    @GetMapping(value={"/fertilizer/pass"})
    @ApiOperation(value="\u5df2\u901a\u8fc7\u80a5\u6599\u62a5\u5907\u7684\u4f01\u4e1a")
    public ResultVo queryFertilizerPassCompany() {
        return ResultVo.success((Object)this.userCenterService.queryFertilizerPassCompany());
    }

    @GetMapping(value={"/represented"})
    @ApiOperation(value="\u8865\u8d34\u7533\u62a5\u88ab\u4ee3\u7406\u4eba\u5217\u8868")
    public ResultVo queryFormRepresentedUserList(@RequestParam(value="name", required=false, defaultValue="") String name, @RequestParam(defaultValue="1", required=false, value="page") Integer page, @RequestParam(defaultValue="100", required=false, value="pageSize") Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        return ResultVo.success((Object)this.userCenterService.queryFormRepresentedUserList(name, start, pageSize));
    }

    @GetMapping(value={"/search"})
    @ApiOperation(value="\u7528\u6237\u641c\u7d22")
    public ResultVo queryUserSearch(@RequestParam(value="name", required=false, defaultValue="") String search, @RequestParam(defaultValue="1", required=false, value="page") Integer page, @RequestParam(defaultValue="10", required=false, value="pageSize") Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        JSONObject json = this.userCenterService.queryUserListBySearch(search, start, pageSize);
        return ResultVo.success((Object)json);
    }
}

