/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller.datav;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.GrainNews;
import com.farm.bean.GrainOverview;
import com.farm.bean.GrainOverviewMap;
import com.farm.bean.GrainPurchaseCondition;
import com.farm.service.GrainStorageService;
import com.farm.util.ExcelUtil;
import com.farm.util.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/grainStorage"})
@Api(tags={"\u667a\u6167\u7cae\u50a8"})
public class DatavGrainStorageController {
    @Autowired
    private GrainStorageService grainStorageService;

    @GetMapping(value={"/map/statistics"})
    @ApiOperation(value="\u5730\u56fe\u8ba2\u5355\u7cae\u6570\u636e")
    public ResultVo queryGrainStorageStatisticsMap() {
        return ResultVo.success((Object)this.grainStorageService.queryGrainStorageStatisticsMap());
    }

    @PostMapping(value={"/map/statistics/upsert"})
    @ApiOperation(value="\u7f16\u8f91\u5730\u56fe\u8ba2\u5355\u7cae\u6570\u636e")
    public ResultVo upsertGrainStorageStatisticsMap(@RequestBody List<GrainOverviewMap> grainOverviewMapList) {
        this.grainStorageService.upsertGrainStorageStatisticsMap(grainOverviewMapList);
        return ResultVo.success();
    }

    @GetMapping(value={"/overview"})
    @ApiOperation(value="\u8ba2\u5355\u7cae\u6982\u51b5")
    public ResultVo queryGrainOverview(@RequestParam(value="type") Integer type) {
        return ResultVo.success((Object)this.grainStorageService.queryGrainOverview(type));
    }

    @PostMapping(value={"/overview/upsert"})
    @ApiOperation(value="\u65b0\u589e/\u4fee\u6539\u8ba2\u5355\u7cae\u6982\u51b5")
    public ResultVo upsertGrainOverview(@RequestBody List<GrainOverview> grainOverviewList) {
        this.grainStorageService.upsertGrainOverview(grainOverviewList);
        return ResultVo.success();
    }

    @GetMapping(value={"/purchase-condition"})
    @ApiOperation(value="\u8ba2\u5355\u7cae\u98df\u6536\u8d2d\u60c5\u51b5\u5217\u8868")
    public ResultVo queryGrainPurchaseCondition(@RequestParam(value="year", required=false) Integer year, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        return ResultVo.success((Object)this.grainStorageService.queryGrainPurchaseCondition(year, start, pageSize));
    }

    @PostMapping(value={"/purchase-condition/upsert"})
    @ApiOperation(value="\u65b0\u589e/\u4fee\u6539\u8ba2\u5355\u7cae\u98df\u6536\u8d2d\u60c5\u51b5")
    public ResultVo upsertGrainPurchaseCondition(@RequestBody List<GrainPurchaseCondition> grainPurchaseConditionList) {
        this.grainStorageService.upsertGrainPurchaseCondition(grainPurchaseConditionList);
        return ResultVo.success();
    }

    @PostMapping(value={"/notice/upsert"})
    @ApiOperation(value="\u65b0\u589e/\u4fee\u6539\u8ba2\u5355\u7cae\u516c\u544a")
    public ResultVo upsertGrainNotice(@RequestBody String body) {
        GrainNews grainNews = (GrainNews)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), GrainNews.class);
        this.grainStorageService.upsertGrainNotice(grainNews);
        return ResultVo.success();
    }

    @GetMapping(value={"/notice/detail"})
    @ApiOperation(value="\u8ba2\u5355\u7cae\u516c\u544a\u8be6\u60c5")
    public ResultVo queryGrainNoticeDetail(@RequestParam(value="id") Integer id, @RequestParam(value="userId", required=false, defaultValue="") String userId) {
        return ResultVo.success((Object)this.grainStorageService.queryGrainNoticeDetail(id, userId));
    }

    @PostMapping(value={"/notice/delete"})
    @ApiOperation(value="\u5220\u9664\u8ba2\u5355\u7cae\u516c\u544a")
    public ResultVo deleteGrainNotice(@RequestParam(value="id") Integer id) {
        this.grainStorageService.deleteGrainNotice(id);
        return ResultVo.success();
    }

    @PostMapping(value={"/notice/disable"})
    @ApiOperation(value="\u7f6e\u9876\u3001\u505c\u7528\u516c\u544a")
    public ResultVo disableGrainNotice(@RequestParam(value="id") Integer id, @RequestParam(value="top", required=false) Integer top, @RequestParam(value="status", required=false) Integer status) {
        this.grainStorageService.disableGrainNotice(id, top, status);
        return ResultVo.success();
    }

    @GetMapping(value={"/notice/page"})
    @ApiOperation(value="\u516c\u544a\u5217\u8868")
    public ResultVo queryGrainNoticePage(@RequestParam(value="title", required=false, defaultValue="") String title, @RequestParam(value="status", required=false) Integer status, @RequestParam(value="type", required=false, defaultValue="") String type, @RequestParam(value="startTime", required=false, defaultValue="") String startTime, @RequestParam(value="endTime", required=false, defaultValue="") String endTime, @RequestParam(value="isTop", required=false) Integer isTop, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize, @RequestParam(value="apiType", required=false, defaultValue="1") Integer apiType) {
        Integer start = (page - 1) * pageSize;
        return ResultVo.success((Object)this.grainStorageService.queryGrainNoticePage(title, status, type, startTime, endTime, isTop, start, pageSize, apiType));
    }

    @GetMapping(value={"/notice/new"})
    @ApiOperation(value="\u6700\u65b0\u516c\u544a")
    public ResultVo queryGrainNoticeNew(@RequestParam(value="startTime", required=false, defaultValue="") String startTime, @RequestParam(value="endTime", required=false, defaultValue="") String endTime) {
        return ResultVo.success((Object)this.grainStorageService.queryGrainNoticeNew(startTime, endTime));
    }

    @PostMapping(value={"/generate-news"})
    public ResultVo generateNew() {
        this.grainStorageService.generateNew();
        return ResultVo.success();
    }

    @PostMapping(value={"/importFileData"})
    public ResultVo importFileData(@RequestParam(value="file") MultipartFile file) {
        return ResultVo.success((Object)this.grainStorageService.importFileData(file));
    }

    @GetMapping(value={"/exportFileData"})
    public void exportFileData(HttpServletRequest request, HttpServletResponse response) {
        ExcelUtil.exportListData((HttpServletRequest)request, (HttpServletResponse)response, new ArrayList(), (String)"\u5927\u6237\u8ba2\u5355\u7cae\u6570\u636e", (String)"order");
    }

    @GetMapping(value={"/noticeList"})
    public ResultVo noticeList(@RequestParam(value="regionCode", required=false, defaultValue="") Long regionCode, @RequestParam(value="dateType", required=false, defaultValue="") Integer dateType, @RequestParam(value="date", required=false, defaultValue="") String date, @RequestParam(value="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize) {
        return ResultVo.success((Object)this.grainStorageService.noticeList(regionCode, dateType, date, pageNum, pageSize));
    }

    @PostMapping(value={"/delData"})
    public ResultVo delData(@RequestParam(value="id") Integer id) {
        return ResultVo.success((Object)this.grainStorageService.delData(id));
    }

    @PostMapping(value={"/countPlus"})
    public ResultVo countPlus(@RequestParam(value="id") Integer id) {
        this.grainStorageService.countPlus(id);
        return ResultVo.success();
    }
}

