/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller.datav;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.Configuration;
import com.farm.bean.DatavFoodProduct;
import com.farm.bean.DatavIndustrialResources;
import com.farm.bean.DatavIndustryPercentage;
import com.farm.bean.DatavOutputValue;
import com.farm.bean.DatavYieldArea;
import com.farm.service.ConfigService;
import com.farm.service.DatavHomePCService;
import com.farm.util.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/homeP"})
@Api(tags={"\u5927\u5c4f\u9996\u9875"})
public class DatavHomePController {
    @Autowired
    private ConfigService configService;
    @Autowired
    private DatavHomePCService datavHomePCService;

    @ApiOperation(value="\u5355\u9879json\u914d\u7f6e")
    @GetMapping(value={"/json/{code}"})
    public ResultVo queryConfigJson(@PathVariable String code) {
        Configuration configuration = this.configService.queryByCode(code);
        String val = configuration.getValue();
        JSONObject json = JSONObject.parseObject((String)val);
        return ResultVo.success((Object)json);
    }

    @ApiOperation(value="\u5355\u9879String\u914d\u7f6e")
    @GetMapping(value={"/str/{code}"})
    public ResultVo queryConfigStr(@PathVariable String code) {
        Configuration configuration = this.configService.queryByCode(code);
        String val = configuration.getValue();
        return ResultVo.success((Object)val);
    }

    @ApiOperation(value="\u5355\u9879String\u914d\u7f6e")
    @GetMapping(value={"/str"})
    public ResultVo queryConfig(String code) {
        Configuration configuration = this.configService.queryByCode(code);
        String val = configuration.getValue();
        return ResultVo.success((Object)val);
    }

    @PostMapping(value={"/upsert/config"})
    @ApiOperation(value="\u65b0\u589e/\u4fee\u6539\u6570\u636e\u914d\u7f6e")
    public ResultVo upsertDataMaintenance(@RequestBody String body) {
        Configuration configuration = (Configuration)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), Configuration.class);
        this.configService.upsertDataMaintenance(configuration);
        return ResultVo.success();
    }

    @GetMapping(value={"/config"})
    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u6570\u636e\u914d\u7f6e")
    public ResultVo queryConfigByCode(@RequestParam(value="code") String code) {
        return ResultVo.success((Object)this.configService.queryByCode(code));
    }

    @ApiOperation(value="\u6a21\u5757\u6d3b\u8dc3\u5ea6")
    @GetMapping(value={"/module-activity"})
    public ResultVo queryModuleActivities(@RequestParam(required=false, defaultValue="") String modules, @RequestParam(required=false, defaultValue="") String date) {
        if (StringUtils.isBlank((String)date)) {
            date = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM"));
        }
        String[] moduleArray = modules.split(",");
        JSONObject json = this.configService.queryModuleActivities(moduleArray, date);
        return ResultVo.success((Object)json);
    }

    @ApiOperation(value="\u5b50\u6a21\u5757\u6d3b\u8dc3\u5ea6")
    @GetMapping(value={"/child/module-activity"})
    public ResultVo queryChildModuleActivities(@RequestParam(required=false, defaultValue="") String modules, @RequestParam(required=false, defaultValue="") String date) {
        if (StringUtils.isBlank((String)date)) {
            date = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM"));
        }
        String[] moduleArray = modules.split(",");
        JSONObject json = this.configService.queryChildModuleActivities(moduleArray, date);
        return ResultVo.success((Object)json);
    }

    @ApiOperation(value="\u7528\u6237\u6d3b\u8dc3\u5ea6")
    @GetMapping(value={"/user-activity"})
    public ResultVo queryUserActivities(@RequestParam(required=false, defaultValue="") String modules, @RequestParam(required=false, defaultValue="") String date) {
        String[] moduleArray = modules.split(",");
        JSONObject json = this.configService.queryUserActivities(moduleArray, date);
        return ResultVo.success((Object)json);
    }

    @ApiOperation(value="\u65b0\u589e\u6d3b\u8dc3\u5ea6")
    @PostMapping(value={"/user-activity"})
    public ResultVo postUserActivities(String module, String phone) {
        this.configService.postUserActivities(module, phone);
        return ResultVo.success();
    }

    @GetMapping(value={"/food-product/overview"})
    @ApiOperation(value="\u7cae\u98df\u751f\u4ea7\u6982\u51b5")
    public ResultVo queryFoodProductOverviewByRegionCode(@RequestParam(value="regionCode", required=false, defaultValue="330825") String regionCode) {
        return ResultVo.success((Object)this.datavHomePCService.queryFoodProductOverviewByRegionCode(regionCode));
    }

    @PostMapping(value={"/upsert/food-product"})
    @ApiOperation(value="\u65b0\u589e/\u4fee\u6539\u7cae\u98df\u751f\u4ea7\u6982\u51b5")
    public ResultVo upsertFoodProductOverview(@RequestBody List<DatavFoodProduct> datavFoodProductList) {
        this.datavHomePCService.upsertFoodProductOverview(datavFoodProductList);
        return ResultVo.success();
    }

    @GetMapping(value={"/resource-statistics"})
    @ApiOperation(value="\u4ea7\u4e1a\u8d44\u6e90\u7edf\u8ba1")
    public ResultVo queryResourceStatisticsByRegionCode(@RequestParam(value="regionCode", required=false, defaultValue="330825") String regionCode) {
        return ResultVo.success((Object)this.datavHomePCService.queryResourceStatisticsByRegionCode(regionCode));
    }

    @GetMapping(value={"/industrial-resources"})
    @ApiOperation(value="\u4ea7\u4e1a\u8d44\u6e90")
    public ResultVo queryIndustrialResourcesByRegionCode(@RequestParam(value="regionCode", required=false, defaultValue="330825") String regionCode) {
        return ResultVo.success((Object)this.datavHomePCService.queryIndustrialResourcesByRegionCode(regionCode));
    }

    @PostMapping(value={"/upsert/industrial-resources"})
    @ApiOperation(value="\u65b0\u589e/\u4fee\u6539\u4ea7\u4e1a\u8d44\u6e90")
    public ResultVo upsertIndustrialResources(@RequestBody DatavIndustrialResources datavIndustrialResources) {
        this.datavHomePCService.upsertIndustrialResources(datavIndustrialResources);
        return ResultVo.success();
    }

    @GetMapping(value={"/output/trend"})
    @ApiOperation(value="\u4ea7\u503c\u8d8b\u52bf")
    public ResultVo queryOutputTrendByRegionCode(@RequestParam(value="regionCode", required=false, defaultValue="330825") String regionCode) {
        return ResultVo.success((Object)this.datavHomePCService.queryOutputTrendByRegionCode(regionCode));
    }

    @PostMapping(value={"/upsert/output-trend"})
    @ApiOperation(value="\u65b0\u589e/\u4fee\u6539\u4ea7\u503c\u8d8b\u52bf")
    public ResultVo upsertOutputTrend(@RequestBody List<DatavOutputValue> datavOutputValueList) {
        this.datavHomePCService.upsertOutputTrend(datavOutputValueList);
        return ResultVo.success();
    }

    @GetMapping(value={"/industry-percentage"})
    @ApiOperation(value="\u4ea7\u4e1a\u5360\u6bd4")
    public ResultVo queryIndustryPercentageByRegionCode(@RequestParam(value="regionCode", required=false, defaultValue="330825") String regionCode) {
        return ResultVo.success((Object)this.datavHomePCService.queryIndustryPercentageByRegionCode(regionCode));
    }

    @PostMapping(value={"/upsert/industry-percentage"})
    @ApiOperation(value="\u65b0\u589e/\u4fee\u6539\u4ea7\u4e1a\u5360\u6bd4")
    public ResultVo upsertIndustryPercentage(@RequestBody DatavIndustryPercentage datavIndustryPercentage) {
        this.datavHomePCService.upsertIndustryPercentage(datavIndustryPercentage);
        return ResultVo.success();
    }

    @GetMapping(value={"/yield-area"})
    @ApiOperation(value="\u9762\u79ef/\u4ea7\u91cf\u7edf\u8ba1")
    public ResultVo queryYieldAreaStatistics() {
        return ResultVo.success((Object)this.datavHomePCService.queryYieldAreaStatistics());
    }

    @PostMapping(value={"/upsert/yield-area"})
    @ApiOperation(value="\u65b0\u589e/\u4fee\u6539 \u9762\u79ef-\u4ea7\u91cf\u7edf\u8ba1")
    public ResultVo upsertYieldAreaStatistics(@RequestBody List<DatavYieldArea> datavYieldAreaList) {
        this.datavHomePCService.upsertYieldAreaStatistics(datavYieldAreaList);
        return ResultVo.success();
    }

    @GetMapping(value={"/yield-area/user"})
    @ApiOperation(value="\u7528\u6237\u9762\u79ef/\u4ea7\u91cf\u7edf\u8ba1")
    public ResultVo queryUserYieldAreaStatistics(@RequestParam(value="regionCode", required=false, defaultValue="330825") String regionCode, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="50") Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        return ResultVo.success((Object)this.datavHomePCService.queryUserYieldAreaStatistics(regionCode, start, pageSize));
    }

    @GetMapping(value={"/landlord-agribusiness"})
    @ApiOperation(value="\u6307\u5b9a\u533a\u57df\u5927\u6237\u548c\u519c\u8d44")
    public ResultVo queryLandlordAgribusinessByRegionCode(@RequestParam(value="regionCode", required=false, defaultValue="330825") String regionCode) {
        return ResultVo.success((Object)this.datavHomePCService.queryLandlordAgribusinessByRegionCode(regionCode));
    }

    @GetMapping(value={"/landlord-agribusiness/detail"})
    @ApiOperation(value="\u5927\u6237\u519c\u8d44\u8be6\u60c5")
    public ResultVo queryLandlordAgribusinessDetail(@RequestParam(value="id") Integer id, @RequestParam(value="type") Integer type) {
        return ResultVo.success((Object)this.datavHomePCService.queryLandlordAgribusinessDetail(id, type));
    }
}

