/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller.datav;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.DeviceMonitorInsect;
import com.farm.bean.FieldDoubleStatus;
import com.farm.bean.resultMap.InsectCountDataResultMap;
import com.farm.bean.resultMap.InsectDeviceCountResultMap;
import com.farm.dto.DeviceMonitorSite;
import com.farm.dto.InsectInOrUpReq;
import com.farm.mapper.DeviceMonitorSiteMapper;
import com.farm.mapper.FarmCropRecordMapper;
import com.farm.mapper.FieldDoubleStatusMapper;
import com.farm.service.InsectService;
import com.farm.util.HttpSendUtil;
import com.farm.util.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Metrics;
import org.springframework.data.geo.Point;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/insect"})
@Api(tags={"\u75c5\u866b\u5bb3\u76f8\u5173\u63a5\u53e3"})
public class DatavInsectController {
    @Autowired
    private InsectService insectService;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private FieldDoubleStatusMapper fieldDoubleStatusMapper;
    @Autowired
    private DeviceMonitorSiteMapper deviceMonitorSiteMapper;
    @Autowired
    private FarmCropRecordMapper farmCropRecordMapper;

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u75c5\u866b\u5bb3\u53d1\u751f\u8d8b\u52bf")
    @GetMapping(value={"/queryInsectByDate"})
    public ResultVo queryInsectByDate() {
        JSONObject json = this.insectService.queryInsectByDate();
        return ResultVo.success((Object)json);
    }

    @PostMapping(value={"/inOrUpInsect"})
    @ApiOperation(value="\u75c5\u866b\u5bb3\u8be6\u60c5\u4ee5\u53ca\u8d8b\u52bf\u7f16\u8f91")
    public ResultVo inOrUpInsect(@Valid @RequestBody InsectInOrUpReq inOrUpReq) {
        return this.insectService.inOrUpInsect(inOrUpReq);
    }

    @ApiOperation(value="\u67e5\u8be2\u75c5\u866b\u5bb3\u8bbe\u5907\u4fe1\u606f")
    @GetMapping(value={"/queryInsectDeviceList"})
    public ResultVo queryInsectDeviceList() {
        JSONObject json = this.insectService.queryInsectDeviceList();
        return ResultVo.success((Object)json);
    }

    @ApiOperation(value="\u667a\u6167\u7cae\u8111\u5927\u5c4f-\u67e5\u8be2\u75c5\u866b\u5bb3\u8bbe\u5907\u4fe1\u606f")
    @GetMapping(value={"/queryInsectDevices4DataV"})
    public ResultVo queryInsectDevices4DataV() {
        JSONObject json = this.insectService.queryInsectDevicesData();
        return ResultVo.success((Object)json);
    }

    @ApiOperation(value="\u67e5\u8be2 \u866b\u5b50\u5217\u8868")
    @GetMapping(value={"/queryInsectInfoList"})
    public ResultVo queryInsectInfoList() {
        JSONObject json = this.insectService.queryInsectInfoList();
        return ResultVo.success((Object)json);
    }

    @ApiOperation(value="\u6309\u5929-\u8bbe\u5907\u67e5\u8be2\u866b\u5bb3\u6c47\u603b\u6570\u636e")
    @GetMapping(value={"/listInsectCountGroupDay"})
    public ResultVo listInsectCountGroupDay(@RequestParam(required=false) Integer insectType, String startTime, String endTime) {
        JSONObject json = this.insectService.listInsectCountGroupDay(insectType, startTime, endTime);
        return ResultVo.success((Object)json);
    }

    @ApiOperation(value="\u67e5\u8be2\u866b\u5bb3\u7edf\u8ba1\u6570\u636e")
    @GetMapping(value={"/queryInsectCountData"})
    public ResultVo queryInsectCountData(Integer insectType, Integer deviceId, String startTime, String endTime) {
        JSONObject json = this.insectService.queryInsectCountData(insectType, deviceId, startTime, endTime);
        return ResultVo.success((Object)json);
    }

    @ApiOperation(value="\u67e5\u8be2\u6027\u8bf1\u5242\u6355\u6349\u7684\u866b\u5b50\u6570\u91cf")
    @GetMapping(value={"/queryInsectTrapperData"})
    public ResultVo queryInsectTrapperData(Integer deviceId, String startTime, String endTime) {
        JSONObject json = this.insectService.queryInsectTrapperData(deviceId, startTime, endTime);
        return ResultVo.success((Object)json);
    }

    @ApiOperation(value="\u67e5\u8be2\u866b\u5bb3\u7edf\u8ba1\u6570\u636e")
    @GetMapping(value={"/machineSumData"})
    public ResultVo queryMachineSumData(@RequestParam(value="deviceType", required=false, defaultValue="") Integer deviceType, @RequestParam(value="qType", required=false, defaultValue="0") Integer qType, @RequestParam(value="deviceId") Integer deviceId, @RequestParam(value="startDate", required=false, defaultValue="") String startDate, @RequestParam(value="endDate", required=false, defaultValue="") String endDate) {
        JSONObject json = new JSONObject();
        json = qType == 0 ? this.insectService.queryMachineSumDataByYear(deviceType, deviceId, startDate, endDate) : this.insectService.queryMachineSumDataByMonth(deviceType, deviceId, startDate, endDate);
        return ResultVo.success((Object)json);
    }

    @ApiOperation(value="\u5386\u5e74\u4eca\u65e5\u75c5\u866b\u6570\u636e")
    @GetMapping(value={"/dataHistoryToday"})
    public ResultVo queryDataHistoryToday(@RequestParam(value="deviceType", required=false, defaultValue="") Integer deviceType, @RequestParam(value="deviceId") Integer deviceId) {
        JSONObject json = this.insectService.queryDataHistoryToday(deviceType, deviceId);
        return ResultVo.success((Object)json);
    }

    @ApiOperation(value="\u67e5\u8be2\u8bbe\u5907\u89c6\u9891\u4f5c\u7269\u8bc6\u522b")
    @GetMapping(value={"/queryDeviceCropDiscern"})
    public ResultVo queryDeviceCropDiscern(Integer deviceId, String phone) {
        JSONObject json = this.insectService.queryDeviceCropDiscern(deviceId);
        return ResultVo.success((Object)json);
    }

    @ApiOperation(value="\u67e5\u8be2\u76d1\u63a7\u573a/\u70b9\u5217\u8868")
    @GetMapping(value={"/monitorList"})
    public ResultVo queryMonitorList() {
        JSONObject json = this.insectService.queryMonitorList();
        return ResultVo.success((Object)json);
    }

    @ApiOperation(value="\u76d1\u6d4b\u70b9\u5b9e\u65f6\u5371\u5bb3")
    @GetMapping(value={"/monitor/summary"})
    public ResultVo queryMonitorInTimeData(@RequestParam Integer monitorId, @RequestParam(required=false, defaultValue="", value="insectType") Integer insectType) {
        List list = this.insectService.queryCountListNearly(monitorId, insectType);
        Integer maxCount = 0;
        if (list != null && list.size() > 0) {
            maxCount = list.stream().map(InsectCountDataResultMap::getCount).max(Integer::compareTo).get();
        }
        JSONObject json = this.insectService.queryById(monitorId, maxCount, insectType);
        json.put("list", (Object)list);
        return ResultVo.success((Object)json);
    }

    @ApiOperation(value="\u76d1\u6d4b\u70b9\u5217\u8868\u5b9e\u65f6\u5371\u5bb3")
    @GetMapping(value={"/monitor/summary-list"})
    public ResultVo queryMonitorInTimeList(@RequestParam(required=false, defaultValue="7", value="") Integer insectType) {
        JSONObject json = new JSONObject();
        List list = this.insectService.queryCountListNearlyByDevice(insectType);
        for (InsectDeviceCountResultMap it : list) {
            Integer level = 0;
            Integer count = it.getCount();
            if (0 < count && count <= 50) {
                level = 1;
            } else if (count <= 80) {
                level = 2;
            } else if (count <= 100) {
                level = 3;
            } else if (count > 100) {
                level = 4;
            }
            it.setLevel(level);
        }
        json.put("list", (Object)list);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/field/list"})
    @ApiOperation(value="\u8ddd\u79bb\u67e5\u8be2-\u7530\u5757\u5217\u8868")
    public Object queryNearList(@RequestParam Double lng, @RequestParam Double lat, @RequestParam(required=false, defaultValue="10", value="distance") Integer distance, @RequestParam(value="monitorId", required=false, defaultValue="") Integer monitorId, @RequestParam(value="insectType", required=false, defaultValue="7") Integer insectType, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="100") Integer pageSize) {
        JSONObject json = new JSONObject();
        Point point = new Point(lng.doubleValue(), lat.doubleValue());
        Distance dist = new Distance((double)distance.intValue(), (Metric)Metrics.KILOMETERS);
        Circle circle = new Circle(point, dist);
        Criteria criteria = Criteria.where((String)"location").withinSphere(circle);
        Query query = Query.query((CriteriaDefinition)criteria);
        query.with((Pageable)PageRequest.of((int)(page - 1), (int)pageSize));
        query.fields().exclude("_id");
        List list = this.mongoTemplate.find(query, JSONObject.class, "t_field_double_status");
        list.forEach(it -> it.put("img", (Object)("https://imgs.shuxitech.com/farm/field_img/" + it.getString("img"))));
        json.put("list", (Object)list);
        if (monitorId != null) {
            List deviceList = this.insectService.queryCountListNearly(monitorId, insectType);
            Integer maxCount = 0;
            if (deviceList != null && deviceList.size() > 0) {
                maxCount = deviceList.stream().map(InsectCountDataResultMap::getCount).max(Integer::compareTo).get();
            }
            JSONObject pointJson = this.insectService.queryById(monitorId, maxCount, insectType);
            json.putAll((Map)pointJson);
        }
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/history/list"})
    public Object queryInsectHistoryList(Integer fieldId, @RequestParam(value="cropType", required=false, defaultValue="1") Integer cropType, @RequestParam(value="monitorId", required=false, defaultValue="") Integer siteId, @RequestParam(value="beginDate", required=false, defaultValue="") String beginDate, @RequestParam(value="endDate", required=false, defaultValue="") String endDate) throws IOException {
        JSONObject json = this.insectService.queryInsectHistoryList(fieldId, siteId, beginDate, endDate, cropType);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/device"})
    public Object queryInsectsByDevice(@RequestParam(value="wlwDeviceId", required=false) Integer wlwDeviceId, @RequestParam(value="cropType", required=false, defaultValue="1") Integer cropType) {
        String response = wlwDeviceId == null ? HttpSendUtil.sendHttpGet((String)("http://119.3.228.0:8083/lym/devicepestpredict?cropType=" + cropType)) : HttpSendUtil.sendHttpGet((String)("http://119.3.228.0:8083/lym/devicepestpredict?wlwDeviceId=" + wlwDeviceId + "&cropType=" + cropType));
        JSONObject json = JSONObject.parseObject((String)response);
        ArrayList list = new ArrayList();
        json.getJSONArray("list").forEach(item -> list.add(JSONObject.parseObject((String)item.toString())));
        return ResultVo.success(list);
    }

    @GetMapping(value={"/monitor"})
    public Object predictInsectsByMonitor(@RequestParam(value="siteId", required=false) Integer siteId, @RequestParam(value="cropType", required=false, defaultValue="1") Integer cropType) {
        String response = siteId == null ? HttpSendUtil.sendHttpGet((String)("http://119.3.228.0:8083/lym/sitepestpredict?cropType=" + cropType)) : HttpSendUtil.sendHttpGet((String)("http://119.3.228.0:8083/lym/sitepestpredict?siteId=" + siteId + "&cropType=" + cropType));
        JSONObject json = JSONObject.parseObject((String)response);
        ArrayList list = new ArrayList();
        json.getJSONArray("list").forEach(item -> {
            Integer itemSiteId = JSONObject.parseObject((String)item.toString()).getInteger("siteId");
            DeviceMonitorSite deviceMonitorSite = this.insectService.querySiteNameBySiteId(itemSiteId);
            JSONObject jsonObject = JSONObject.parseObject((String)item.toString());
            ArrayList levelList = new ArrayList();
            JSONObject temp = new JSONObject();
            temp.put("siteName", (Object)deviceMonitorSite.getName());
            temp.put("siteId", (Object)deviceMonitorSite.getId());
            temp.put("boundary", (Object)deviceMonitorSite.getBoundary());
            jsonObject.getJSONArray("predictionList").forEach(obj -> {
                String date = JSONObject.parseObject((String)obj.toString()).getString("date");
                String level = JSONObject.parseObject((String)obj.toString()).getString("level");
                JSONObject jsonObj = new JSONObject();
                jsonObj.put("date", (Object)date);
                jsonObj.put("level", (Object)level);
                levelList.add(jsonObj);
            });
            temp.put("levelList", levelList);
            list.add(temp);
        });
        return ResultVo.success(list);
    }

    @GetMapping(value={"/harm-predict"})
    public ResultVo queryHarmPredict(@RequestParam(value="startTime") String startTime, @RequestParam(value="endTime") String endTime) throws IOException {
        String response = HttpSendUtil.sendHttpGet((String)("http://119.3.228.0:8083/lym/pestleveldistribution?startDate=" + startTime + "&endDate=" + endTime));
        return ResultVo.success((Object)JSONObject.parseObject((String)response));
    }

    @GetMapping(value={"/fieldDetail"})
    public Object queryFieldDetail(@RequestParam(value="fieldId") Integer fieldId, @RequestParam(value="cropType", required=false, defaultValue="1") Integer cropType, @RequestParam(value="startDate") String startDate, @RequestParam(value="endDate") String endDate) throws IOException {
        JSONObject json = this.insectService.queryFieldDetail(fieldId, startDate, endDate, cropType);
        Integer pointId = this.insectService.queryFieldNearSite(fieldId);
        List list = this.insectService.queryCountListNearly(pointId, Integer.valueOf(7));
        Integer maxCount = 0;
        if (list != null && list.size() > 0) {
            maxCount = list.stream().map(InsectCountDataResultMap::getCount).max(Integer::compareTo).get();
        }
        JSONObject nowInsectData = this.insectService.queryById(pointId, maxCount, Integer.valueOf(7));
        json.put("nearDate", (Object)nowInsectData);
        return ResultVo.success((Object)json);
    }

    @PostMapping(value={"/upsert"})
    public ResultVo upsertMonitorInsect(@RequestBody String body) {
        DeviceMonitorInsect deviceMonitorInsect = (DeviceMonitorInsect)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), DeviceMonitorInsect.class);
        this.insectService.upsertMonitorInsect(deviceMonitorInsect);
        return ResultVo.success();
    }

    @GetMapping(value={"/field"})
    public ResultVo queryFieldInsect(@RequestParam(value="fieldId") Integer fieldId, @RequestParam(value="cropType", required=false, defaultValue="1") Integer cropType) throws IOException {
        FieldDoubleStatus fieldInfo = this.fieldDoubleStatusMapper.queryFieldDoubleStatusByFieldId(fieldId);
        String response = HttpSendUtil.sendHttpGet((String)("http://119.3.228.0:8083/lym/fieldpestpredict?lng=" + fieldInfo.getLng() + "&lat=" + fieldInfo.getLat() + "&cropType=" + cropType));
        JSONObject json = JSONObject.parseObject((String)response);
        json.put("dutyMan", (Object)(fieldInfo.getDutyMan() == null || fieldInfo.getDutyMan().equals("") ? "\u5f90\u7ea2\u6e05" : fieldInfo.getDutyMan()));
        json.put("record", (Object)this.farmCropRecordMapper.queryRecordListByFieldIdDate(fieldId, Integer.valueOf(0), Integer.valueOf(20), "", Integer.valueOf(7)));
        Integer pointId = this.insectService.queryFieldNearSite(fieldId);
        DeviceMonitorSite site = this.deviceMonitorSiteMapper.queryById(pointId);
        json.put("siteName", (Object)site.getName());
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/device/history/count"})
    public ResultVo queryAllDeviceInsectCountByTime(@RequestParam(value="deviceId", required=false) Integer deviceId, @RequestParam(value="startTime", required=false, defaultValue="") String startTime, @RequestParam(value="endTime", required=false, defaultValue="") String endTime) {
        return ResultVo.success((Object)this.insectService.queryAllDeviceInsectCountByTime(deviceId, startTime, endTime));
    }

    @GetMapping(value={"/devicelarvapredict"})
    public ResultVo queryDevicelarvapredict(@RequestParam(value="startTime") String startTime, @RequestParam(value="endTime") String endTime, @RequestParam(value="wlwDeviceId") String wlwDeviceId) throws IOException {
        String response = HttpSendUtil.sendHttpGet((String)("http://119.3.228.0:8083/lym/devicelarvapredict?wlwDeviceId=" + wlwDeviceId + "&insectType=7&startDate=" + startTime + "&endDate=" + endTime));
        JSONObject json = JSONObject.parseObject((String)response);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/getStatistics"})
    public ResultVo getStatistics(@RequestParam(value="type") Integer type) {
        return this.insectService.getStatistics(type);
    }

    @GetMapping(value={"/getResult"})
    public ResultVo getResult(@RequestParam(value="dateType") Integer dateType, @RequestParam(value="date") String date) {
        return this.insectService.getResult(dateType, date);
    }
}

