/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller.datav;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.AgriserveMachineArea;
import com.farm.bean.AgriserveMachineInspectImport;
import com.farm.service.MachineService;
import com.farm.util.ExcelExpertListener;
import com.farm.util.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/social"})
@Api(tags={"\u793e\u4f1a\u5316\u670d\u52a1\u76f8\u5173\u63a5\u53e3"})
public class DatavMachineController {
    @Autowired
    private MachineService machineService;

    @ApiOperation(value="\u519c\u673a\u5206\u7c7b\u7edf\u8ba1")
    @GetMapping(value={"/machine/group-type"})
    public Object queryMachineByType(String regionCode) {
        JSONObject json = this.machineService.queryMachineByType(regionCode);
        return ResultVo.success((Object)json);
    }

    @ApiOperation(value="\u519c\u673a\u6d3b\u8dc3\u5ea6")
    @GetMapping(value={"/machine/group-status"})
    public Object queryMachineByStatus(String regionCode) {
        JSONObject json = this.machineService.queryMachineByStatus(regionCode);
        return ResultVo.success((Object)json);
    }

    @ApiOperation(value="\u5404\u5408\u4f5c\u793e\u519c\u673a\u62e5\u6709\u91cf")
    @GetMapping(value={"/machine/group-landlord"})
    public Object queryMachineByLandlord(String regionCode) {
        JSONObject json = this.machineService.queryMachineByLandlord(regionCode);
        return ResultVo.success((Object)json);
    }

    @ApiOperation(value="\u5404\u5408\u4f5c\u793e\u5404\u519c\u673a\u7c7b\u578b\u62e5\u6709\u91cf")
    @GetMapping(value={"/machine/group-landlordType"})
    public Object queryMachineByLandlordAndType(String regionCode) {
        JSONObject json = this.machineService.queryMachineByLandlordAndType(regionCode);
        return ResultVo.success((Object)json);
    }

    @ApiOperation(value="\u519c\u673a\u5217\u8868")
    @GetMapping(value={"/machine/list"})
    public Object queryMachineList(String regionCode, @RequestParam(required=false, defaultValue="1", value="page") Integer page, @RequestParam(required=false, defaultValue="10", value="pageSize") Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        JSONObject json = this.machineService.queryMachineList(regionCode, start, pageSize);
        return ResultVo.success((Object)json);
    }

    @ApiOperation(value="\u519c\u673a\u6295\u4fdd\u5217\u8868")
    @GetMapping(value={"/machine/insure-list"})
    public Object queryMachineInsureList(String regionCode) {
        JSONObject json = this.machineService.queryMachineInsureList(regionCode);
        return ResultVo.success((Object)json);
    }

    @ApiOperation(value="\u793e\u4f1a\u5316\u670d\u52a1\u6d88\u606f\u7edf\u8ba1")
    @GetMapping(value={"/msg/list"})
    public Object querySocialMsgSummaryList(String regionCode) {
        JSONObject json = this.machineService.querySocialMsgSummaryList(regionCode);
        return ResultVo.success((Object)json);
    }

    @ApiOperation(value="\u519c\u673a\u5730\u56fe-\u5408\u4f5c\u793e\u7edf\u8ba1")
    @GetMapping(value={"/machine/landlord-list"})
    public Object queryMachineSummaryListByLandlord(String regionCode, @RequestParam(required=false, defaultValue="", value="types") String types) {
        List<Object> machineTypeList = types.equals("") ? new ArrayList() : Arrays.asList(types.split(","));
        JSONObject json = this.machineService.queryMachineSummaryListByLandlord(regionCode, machineTypeList);
        return ResultVo.success((Object)json);
    }

    @ApiOperation(value="\u519c\u673a\u5730\u56fe-\u67e5\u8be2\u519c\u6237\u7ec4\u7ec7\u519c\u673a\u8be6\u60c5")
    @GetMapping(value={"/machine/phone-detail"})
    public Object queryMachineListByLandlord(String phone) {
        JSONObject json = this.machineService.queryMachineListByLandlord(phone);
        return ResultVo.success((Object)json);
    }

    @ApiOperation(value="\u519c\u673a\u4f5c\u4e1a\u60c5\u51b5")
    @GetMapping(value={"/machine/workArea"})
    public ResultVo queryMachineWorkAreas(String regionCode, @RequestParam(defaultValue="", required=false) Integer year) {
        if (year == null) {
            year = LocalDate.now().getYear();
        }
        JSONObject json = this.machineService.queryMachineWorkAreas(regionCode, year);
        return ResultVo.success((Object)json);
    }

    @PostMapping(value={"/upsert/machine-workArea"})
    @ApiOperation(value="\u65b0\u589e/\u4fee\u6539\u519c\u673a\u4f5c\u4e1a\u60c5\u51b5")
    public ResultVo upsertMachineWorkArea(@RequestBody List<AgriserveMachineArea> agriserveMachineAreaList) {
        this.machineService.upsertMachineWorkArea(agriserveMachineAreaList);
        return ResultVo.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/import"})
    @ApiOperation(value="\u6279\u91cf\u5bfc\u5165\u519c\u673a")
    public ResultVo importMachine(@RequestParam(value="file") MultipartFile file) {
        List list = null;
        ExcelExpertListener excelListener = new ExcelExpertListener();
        String errMsg = null;
        InputStream inputStream = null;
        try {
            inputStream = file.getInputStream();
            EasyExcel.read((InputStream)inputStream, AgriserveMachineInspectImport.class, (ReadListener)excelListener).sheet().doRead();
            list = excelListener.getList();
            System.out.println("\u5bfc\u5165\u7684\u96c6\u5408\u4e3a\uff1a=======================" + list);
            errMsg = excelListener.getErrMsg();
            if (StringUtils.isNotBlank((CharSequence)errMsg)) {
                ResultVo resultVo = ResultVo.error((String)errMsg);
                return resultVo;
            }
            if (list.size() < 1) {
                ResultVo resultVo = ResultVo.error((String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
                return resultVo;
            }
            ResultVo resultVo = this.machineService.batchInsertMachine(list);
            return resultVo;
        }
        catch (Exception e) {
            e.printStackTrace();
            errMsg = excelListener.getErrMsg();
            if (errMsg == null) {
                errMsg = "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a";
            }
            ResultVo resultVo = ResultVo.error((String)("\u6279\u91cf\u65b0\u589e\u5931\u8d25:" + errMsg));
            return resultVo;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (list != null && list.size() != 0) {
                list.clear();
            }
        }
    }
}

