/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller.datav;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.DatavFieldYieldLevelImBo;
import com.farm.service.ProductManageService;
import com.farm.util.ExcelExpertListener;
import com.farm.util.ExportUtil;
import com.farm.util.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping(value={"/product-manage"})
@Api(tags={"\u6570\u5b57\u7cae\u7530\u751f\u4ea7\u7ba1\u7406"})
@RestController
public class DatavPMController {
    @Autowired
    private ProductManageService productManageService;

    @GetMapping(value={"/fertilize-list"})
    @ApiOperation(value="\u571f\u5730\u5386\u5e74\u4ea9\u5747\u80a5\u6599\u7528\u91cf\u53d8\u5316")
    public ResultVo queryFieldFertilizeList(String regionCode, String year) {
        JSONObject json = this.productManageService.queryFieldFertilizeList(regionCode, year);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/fertilize-percent"})
    @ApiOperation(value="\u5e74\u80a5\u6599\u6295\u5165\u767e\u5206\u6bd4")
    public ResultVo queryFieldFertilizePercent(String regionCode, String year) {
        JSONObject json = this.productManageService.queryFieldFertilizePercent(regionCode, year);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/field/yield-level"})
    @ApiOperation(value="\u5404\u6751\u8015\u5730\u8d28\u91cf\u7b49\u7ea7")
    public ResultVo queryFieldYieldLevelList(String regionCode) {
        JSONObject json = this.productManageService.queryFieldYieldLevelList(regionCode);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/field/fertilizer-level"})
    @ApiOperation(value="\u5404\u6751\u571f\u58e4\u80a5\u529b\u7b49\u7ea7")
    public ResultVo queryFieldFertilizerLevelList(String regionCode, String element) {
        JSONObject json = this.productManageService.queryFieldFertilizerLevelList(regionCode, element);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/landlord/list"})
    @ApiOperation(value="\u79cd\u690d\u4e3b\u4f53\u5217\u8868")
    public ResultVo queryLandlordList(String regionCode) {
        JSONObject json = this.productManageService.queryLandlordList(regionCode);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/landlord/field-list"})
    @ApiOperation(value="\u79cd\u690d\u4e3b\u4f53\u7530\u5757\u5217\u8868")
    public ResultVo queryLandlordFieldList(String phone, @RequestParam(defaultValue="1", required=false, value="page") Integer page, @RequestParam(defaultValue="100", required=false, value="pageSize") Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        JSONObject json = this.productManageService.queryLandlordFieldList(phone, start, pageSize);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/exportYieldLevelData"})
    public void exportData(@RequestParam(value="regionCode") String regionCode, @RequestParam(value="type", defaultValue="0", required=false) Integer type, HttpServletResponse response) {
        JSONArray list = null;
        if (type == 1 && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)regionCode)) {
            JSONObject json = this.productManageService.queryFieldYieldLevelListAll(regionCode);
            list = json.getJSONArray("list");
        } else {
            list = new JSONArray();
        }
        List selectValue = this.productManageService.querySelectValue();
        new ExportUtil().exportExport(response, list, "\u533a\u57df\u5730\u529b\u7edf\u8ba1", "datavFieldYieldLevel", selectValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/importYieldLevelData"})
    public ResultVo importData(@RequestParam(value="file") MultipartFile file) {
        List list = null;
        ExcelExpertListener excelListener = new ExcelExpertListener();
        String errMsg = null;
        InputStream inputStream = null;
        try {
            inputStream = file.getInputStream();
            EasyExcel.read((InputStream)inputStream, DatavFieldYieldLevelImBo.class, (ReadListener)excelListener).sheet().doRead();
            list = excelListener.getList();
            errMsg = excelListener.getErrMsg();
            if (StringUtils.isNotBlank((CharSequence)errMsg)) {
                ResultVo resultVo = ResultVo.error((String)errMsg);
                return resultVo;
            }
            if (list.size() < 1) {
                ResultVo resultVo = ResultVo.error((String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
                return resultVo;
            }
            ResultVo resultVo = ResultVo.success((Object)this.productManageService.saveByFile(list));
            return resultVo;
        }
        catch (Exception e) {
            errMsg = excelListener.getErrMsg();
            if (errMsg == null) {
                errMsg = "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a";
            }
            ResultVo resultVo = ResultVo.error((String)("\u6279\u91cf\u65b0\u589e\u5931\u8d25:" + errMsg));
            return resultVo;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (list != null && list.size() != 0) {
                list.clear();
            }
        }
    }
}

