/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller.datav;

import com.alibaba.fastjson.JSONObject;
import com.farm.bean.RecycleStatistics;
import com.farm.bean.RecycleTown;
import com.farm.service.RecyclePointInfoService;
import com.farm.util.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/recycle"})
@Api(tags={"\u5e9f\u5f03\u7269\u5927\u5c4f"})
public class DatavRecycleController {
    @Autowired
    private RecyclePointInfoService recyclePointService;

    @GetMapping(value={"/typePoints"})
    @ApiOperation(value="\u5e9f\u5f03\u7269\u7ad9\u70b9\u5206\u7c7b\u7edf\u8ba1")
    public Object queryPointsByType(@RequestParam(required=false, defaultValue="", value="") String regionCode, @RequestParam(required=false, defaultValue="1", value="page") Integer page, @RequestParam(required=false, defaultValue="10", value="pageSize") Integer pageSize) {
        Integer offset = (page - 1) * pageSize;
        JSONObject json = this.recyclePointService.queryPointsByType(regionCode, offset, pageSize);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/typeAmount"})
    @ApiOperation(value="\u519c\u8d44\u5e9f\u5f03\u7269\u6570\u636e\u7edf\u8ba1")
    public Object queryAmountByType(@RequestParam(required=false, defaultValue="", value="") String regionCode) {
        JSONObject json = this.recyclePointService.queryAmountByType(regionCode);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/statistics"})
    @ApiOperation(value="\u9f99\u6e38\u53bf\u519c\u8d44\u5e9f\u5f03\u7269\u7edf\u8ba1")
    public ResultVo queryRecycleStatistics() {
        return ResultVo.success((Object)this.recyclePointService.queryRecycleStatistics());
    }

    @PostMapping(value={"/statistics/upsert"})
    @ApiOperation(value="\u65b0\u589e/\u4fee\u6539\u9f99\u6e38\u53bf\u519c\u8d44\u5e9f\u5f03\u7269\u7edf\u8ba1")
    public ResultVo upsertRecycleStatistics(@RequestBody RecycleStatistics recycleStatistics) {
        this.recyclePointService.upsertRecycleStatistics(recycleStatistics);
        return ResultVo.success();
    }

    @GetMapping(value={"/town-statistics"})
    @ApiOperation(value="\u5404\u4e61\u9547\u5e9f\u5f03\u7269\u7edf\u8ba1\u5217\u8868")
    public ResultVo queryRecycleTown() {
        return ResultVo.success((Object)this.recyclePointService.queryRecycleTown());
    }

    @PostMapping(value={"/town-statistics/upsert"})
    @ApiOperation(value="\u65b0\u589e/\u4fee\u6539\u5404\u4e61\u9547\u5e9f\u5f03\u7269\u7edf\u8ba1")
    public ResultVo upsertRecycleTown(@RequestBody List<RecycleTown> recycleTownList) {
        this.recyclePointService.upsertRecycleTown(recycleTownList);
        return ResultVo.success();
    }
}

