/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller.datav;

import com.alibaba.fastjson.JSONObject;
import com.farm.bean.SubsidyAmountSummary;
import com.farm.bean.SubsidyMapData;
import com.farm.bean.SubsidySummaryYear;
import com.farm.bean.resultMap.LabelResultMap;
import com.farm.service.SubsidyFormInfoService;
import com.farm.util.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.time.LocalDate;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/subsidy"})
@Api(tags={"\u5927\u5c4f-\u60e0\u519c"})
public class DatavSubsidyController {
    @Autowired
    private SubsidyFormInfoService subsidyFormService;

    @GetMapping(value={"/summary-project"})
    @ApiOperation(value="\u9f99\u6e38\u53bf\u60e0\u519c\u8865\u8d34\u653f\u7b56\u60c5\u51b5\u5386\u5e74\u53d8\u5316")
    public ResultVo querySubsidySummaryByYear(@RequestParam(required=false, defaultValue="", value="regionCode") String regionCode) {
        return ResultVo.success((Object)this.subsidyFormService.querySubsidySummaryByYear(regionCode));
    }

    @PostMapping(value={"/upsert/summary-project"})
    @ApiOperation(value="\u65b0\u589e/\u4fee\u6539\u8865\u8d34\u5386\u5e74\u53d8\u5316")
    public ResultVo upsertSubsidySummaryByYear(@RequestBody List<SubsidySummaryYear> subsidySummaryYearList) {
        this.subsidyFormService.upsertSubsidySummaryByYear(subsidySummaryYearList);
        return ResultVo.success();
    }

    @GetMapping(value={"/summary-town"})
    @ApiOperation(value="\u5404\u4e61\u9547\u5404\u7c7b\u8865\u8d34\u91d1\u989d\u4eba\u6570\u7edf\u8ba1")
    public ResultVo querySubsidySummaryByTown(@RequestParam(required=false, defaultValue="330825", value="regionCode") String regionCode, @RequestParam(required=false, defaultValue="2021", value="year") Integer year, @RequestParam(value="type", required=false, defaultValue="0") Integer type) {
        JSONObject json = this.subsidyFormService.querySubsidySummaryByTown(regionCode, year, type);
        return ResultVo.success((Object)json);
    }

    @PostMapping(value={"/upsert/summary-plant"})
    @ApiOperation(value="\u65b0\u589e/\u4fee\u6539\u89c4\u6a21\u79cd\u7cae\u8865\u8d34")
    public ResultVo upsertSubsidySummaryByPlant(@RequestBody List<LabelResultMap> labelResultMapList) {
        this.subsidyFormService.upsertSubsidySummaryByPlant(labelResultMapList);
        return ResultVo.success();
    }

    @GetMapping(value={"/summary-plant"})
    @ApiOperation(value="\u89c4\u6a21\u79cd\u7cae\u8865\u8d34")
    public ResultVo querySubsidySummaryByPlant(@RequestParam(required=false, defaultValue="330825", value="regionCode") String regionCode, @RequestParam(required=false, defaultValue="2021", value="year") Integer year) {
        JSONObject json = this.subsidyFormService.querySubsidySummaryByPlant(regionCode, year);
        return ResultVo.success((Object)json);
    }

    @PostMapping(value={"/upsert/summary-machine"})
    @ApiOperation(value="\u65b0\u589e/\u4fee\u6539\u9ad8\u8017\u519c\u673a\u8865\u8d34")
    public ResultVo upsertSubsidySummaryByMachine(@RequestBody List<LabelResultMap> labelResultMapList) {
        this.subsidyFormService.upsertSubsidySummaryByMachine(labelResultMapList);
        return ResultVo.success();
    }

    @GetMapping(value={"/summary-machine"})
    @ApiOperation(value="\u9ad8\u8017\u519c\u673a\u8865\u8d34")
    public ResultVo querySubsidySummaryByMachine(@RequestParam(required=false, defaultValue="330825", value="regionCode") String regionCode, @RequestParam(required=false, defaultValue="2021", value="year") Integer year) {
        JSONObject json = this.subsidyFormService.querySubsidySummaryByMachine(regionCode, year);
        return ResultVo.success((Object)json);
    }

    @PostMapping(value={"/upsert/summary-agriProduct"})
    @ApiOperation(value="\u65b0\u589e/\u4fee\u6539\u519c\u8d44\u4ea7\u54c1\u8865\u8d34")
    public ResultVo upsertSubsidySummaryByAgriProduct(@RequestBody List<LabelResultMap> labelResultMapList) {
        this.subsidyFormService.upsertSubsidySummaryByAgriProduct(labelResultMapList);
        return ResultVo.success();
    }

    @GetMapping(value={"/summary-agriProduct"})
    @ApiOperation(value="\u519c\u8d44\u4ea7\u54c1\u8865\u8d34\u7533\u8bf7")
    public ResultVo querySubsidySummaryByAgriProduct(@RequestParam(required=false, defaultValue="330825", value="regionCode") String regionCode, @RequestParam(required=false, defaultValue="2021", value="year") Integer year) {
        JSONObject json = this.subsidyFormService.querySubsidySummaryByAgriProduct(regionCode, year);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/detail-landlord"})
    @ApiOperation(value="\u5927\u6237\u7533\u9886\u8be6\u7ec6\u6e05\u5355")
    public ResultVo querySubsidyLandlord(@RequestParam String userId, @RequestParam(name="userName", required=false) String userName, @RequestParam(name="type", required=false) Integer type, @RequestParam(name="page", required=false, defaultValue="1") Integer page, @RequestParam(name="pageSize", required=false, defaultValue="10") Integer pageSize) {
        Integer offset = (page - 1) * pageSize;
        JSONObject json = this.subsidyFormService.querySubsidyLandlord(userId, offset, pageSize, type, userName);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/userSum-region"})
    @ApiOperation(value="\u533a\u57df\u7edf\u8ba1\u7528\u6237\u6570\u91cf")
    public ResultVo queryUserSumByRegion(@RequestParam(name="year", required=false, defaultValue="2021") Integer year, @RequestParam(name="type", required=false, defaultValue="0") Integer type) {
        JSONObject json = this.subsidyFormService.queryUserSumByRegion(year, type);
        return ResultVo.success((Object)json);
    }

    @PostMapping(value={"/upsert/summary-typeAll"})
    @ApiOperation(value="\u65b0\u589e/\u4fee\u6539\u60e0\u519c\u653f\u7b56\u8865\u8d34\u6570\u636e\u7edf\u8ba1")
    public ResultVo upsertSummaryTypeAll(@RequestBody List<SubsidyAmountSummary> subsidySummaryAmountList) {
        this.subsidyFormService.upsertSummaryTypeAll(subsidySummaryAmountList);
        return ResultVo.success();
    }

    @GetMapping(value={"/summary-typeAll"})
    @ApiOperation(value="\u60e0\u519c\u653f\u7b56\u8865\u8d34\u6570\u636e\u7edf\u8ba1")
    public ResultVo querySummaryTypeAll(@RequestParam(name="year", required=false) Integer year, @RequestParam(value="regionCode") Integer regionCode) {
        if (year == null) {
            year = LocalDate.now().getYear();
        }
        JSONObject json = this.subsidyFormService.querySummaryTypeAll(year, regionCode);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/summary-type"})
    @ApiOperation(value="\u5355\u7c7b\u578b\u8865\u8d34\u6570\u636e\u7edf\u8ba1")
    public ResultVo querySummarySingleType(@RequestParam(name="type", required=false, defaultValue="") Integer type, @RequestParam(name="year", required=false) Integer year) {
        if (year == null) {
            year = LocalDate.now().getYear();
        }
        JSONObject json = this.subsidyFormService.querySummarySingleType(type, year);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/summary-apply"})
    @ApiOperation(value="\u8865\u8d34\u7533\u8bf7\u516c\u793a")
    public ResultVo querySummaryApplyList(@RequestParam(name="type", required=false) Integer type, @RequestParam(name="regionCode", required=false, defaultValue="330825") String regionCode, @RequestParam(name="page", required=false, defaultValue="1") Integer page, @RequestParam(name="pageSize", required=false, defaultValue="10") Integer limit, @RequestParam(name="years", required=false) String years) {
        Integer offset = (page - 1) * limit;
        JSONObject json = this.subsidyFormService.querySummaryApplyList(type, regionCode, offset, limit, years);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/map-data"})
    public ResultVo querySubsidyMapData(@RequestParam(name="regionCode", required=false, defaultValue="330825") String regionCode) {
        return ResultVo.success((Object)this.subsidyFormService.querySubsidyMapData(regionCode));
    }

    @PostMapping(value={"/map-data"})
    public ResultVo upsertSubsidyMapData(@RequestBody List<SubsidyMapData> subsidyMapDataList) {
        this.subsidyFormService.upsertSubsidyMapData(subsidyMapDataList);
        return ResultVo.success();
    }
}

