/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller.fertilize;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.FertilizePointNewImport;
import com.farm.bean.fertilize.FertilizePointNew;
import com.farm.service.FertilizeCropPlanService;
import com.farm.service.FertilizePointNewService;
import com.farm.util.ExcelExpertListener;
import com.farm.util.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/fertilize-point"})
@Api(tags={"\u7cbe\u51c6\u65bd\u80a5-\u6837\u70b9\u7ef4\u62a4"})
public class FertilizePointController {
    private static final Logger log = LoggerFactory.getLogger(FertilizePointController.class);
    @Autowired
    private FertilizePointNewService fertilizePointNewService;
    @Autowired
    private FertilizeCropPlanService fertilizeCropPlanService;

    @PostMapping(value={"/upsert"})
    @ApiOperation(value="\u65b0\u589e/\u4fee\u6539")
    public ResultVo upsertFertilizePoint(@RequestBody String body) {
        try {
            FertilizePointNew fertilizePoint = (FertilizePointNew)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), FertilizePointNew.class);
            if (fertilizePoint.getId() == null) {
                this.fertilizePointNewService.insert(fertilizePoint);
            } else {
                this.fertilizePointNewService.update(fertilizePoint);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ResultVo.error();
        }
        return ResultVo.success();
    }

    @GetMapping(value={"/detail"})
    @ApiOperation(value="\u8be6\u60c5")
    public ResultVo queryFertilizePointDetail(@RequestParam(value="id") Integer id) {
        FertilizePointNew fertilizePointNew = this.fertilizePointNewService.queryFertilizePointDetail(id);
        return ResultVo.success((Object)fertilizePointNew);
    }

    @GetMapping(value={"/page"})
    @ApiOperation(value="\u6761\u4ef6\u5206\u9875")
    public ResultVo queryFertilizePointPage(@RequestParam(value="regionCodes", required=false, defaultValue="") String regionCodes, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        List<Object> regionCodeList = regionCodes.equals("") ? new ArrayList() : Arrays.asList(regionCodes.split(","));
        return ResultVo.success((Object)this.fertilizePointNewService.queryFertilizePointPage(regionCodeList, start, pageSize));
    }

    @PostMapping(value={"/del"})
    @ApiOperation(value="\u5220\u9664/\u505c\u7528")
    public ResultVo delAndDisableFertilizePoint(@RequestParam(value="id") Integer id, @RequestParam(value="status", required=false) Integer status) {
        if (status == null) {
            this.fertilizePointNewService.deleteFertilizePoint(id);
        } else {
            this.fertilizePointNewService.disableFertilizePoint(id, status);
        }
        return ResultVo.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/import"})
    @ApiOperation(value="\u6279\u91cf\u5bfc\u5165")
    public ResultVo importFertilizePointBatch(@RequestParam(value="file") MultipartFile file) {
        List list = null;
        String errMsg = null;
        InputStream inputStream = null;
        ExcelExpertListener excelListener = new ExcelExpertListener();
        try {
            inputStream = file.getInputStream();
            EasyExcel.read((InputStream)inputStream, FertilizePointNewImport.class, (ReadListener)excelListener).sheet().doRead();
            list = excelListener.getList();
            errMsg = excelListener.getErrMsg();
            if (StringUtils.isNotBlank((CharSequence)errMsg)) {
                ResultVo resultVo = ResultVo.error((String)errMsg);
                return resultVo;
            }
            if (list.size() < 1) {
                ResultVo resultVo = ResultVo.error((String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
                return resultVo;
            }
            this.fertilizePointNewService.batchInsert(list);
            ResultVo resultVo = ResultVo.success();
            return resultVo;
        }
        catch (Exception e) {
            log.error("import valid error:{}", (Object)e.getMessage());
            errMsg = excelListener.getErrMsg();
            ResultVo resultVo = ResultVo.error((String)("\u6279\u91cf\u65b0\u589e\u5931\u8d25:" + errMsg));
            return resultVo;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (list != null && list.size() != 0) {
                list.clear();
            }
        }
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u6837\u70b9\u5217\u8868")
    public ResultVo queryFertilizePointList() {
        return ResultVo.success((Object)this.fertilizePointNewService.queryFertilizePointList());
    }

    @GetMapping(value={"/queryFertilizePointBySampleNo"})
    @ApiOperation(value="\u6837\u70b9\u660e\u7ec6")
    public ResultVo queryFertilizePointBySampleNo(@RequestParam(value="sampleNo") String sampleNo) {
        return ResultVo.success((Object)this.fertilizePointNewService.queryFertilizePointBySampleNo(sampleNo));
    }

    @GetMapping(value={"/getPlanInfoBySampleNo"})
    @ApiOperation(value="\u6837\u70b9\u660e\u7ec6")
    public ResultVo getPlanInfoBySampleNo(@RequestParam(value="tn") String tn, @RequestParam(value="ap") String ap, @RequestParam(value="ak") String ak, @RequestParam(value="crop") String crop) {
        return ResultVo.success((Object)this.fertilizePointNewService.getPlanInfoBySampleNo(tn, ap, ak, crop));
    }

    @GetMapping(value={"/count-map"})
    public ResultVo queryFertilizePointCountByRegionCode() {
        return ResultVo.success((Object)this.fertilizePointNewService.queryFertilizePointCountByRegionCode());
    }

    @GetMapping(value={"/avg"})
    public ResultVo queryFertilizePointAvgByRegionCode(@RequestParam(value="regionCode", required=false, defaultValue="") String regionCode) {
        return ResultVo.success((Object)this.fertilizePointNewService.queryFertilizePointAvgByRegionCode(regionCode));
    }

    @GetMapping(value={"/avgList"})
    public ResultVo queryAvgListByRegionCode(@RequestParam(value="regionCode", required=false) String regionCode, @RequestParam(value="type", required=false) String type, @RequestParam(value="period", required=false) String period) {
        return ResultVo.success((Object)this.fertilizePointNewService.queryAvgListByRegionCodePeriod(regionCode, type, period));
    }

    @GetMapping(value={"/refreshData"})
    @ApiOperation(value="\u5237\u65b0\u6570\u636e")
    public ResultVo refreshData() {
        return ResultVo.success((Object)this.fertilizePointNewService.refreshData());
    }

    @GetMapping(value={"/getPlanByPoint/{pointId}"})
    @ApiOperation(value="\u6839\u636e\u571f\u58e4\u6837\u70b9\u83b7\u53d6\u65bd\u80a5\u65b9\u6848\u4fe1\u606f")
    public ResultVo getPlanByPoint(@PathVariable(value="pointId") Integer pointId) {
        return ResultVo.success((Object)this.fertilizePointNewService.getPlanByPoint(pointId));
    }

    @GetMapping(value={"/getPlanPointInfoByCropPlan/{cropPlanId}"})
    @ApiOperation(value="\u6839\u636e\u4f5c\u7269\u65b9\u6848ID\u83b7\u53d6\u65bd\u80a5\u65b9\u6848\u4fe1\u606f")
    public ResultVo getPlanByCropPlanId(@PathVariable(value="cropPlanId") Integer cropPlanId) {
        return ResultVo.success((Object)this.fertilizeCropPlanService.queryFertilizeCropPlanDetail(cropPlanId));
    }
}

