/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller.fertilize;

import com.alibaba.fastjson.JSONObject;
import com.farm.bean.fertilize.SoilRemediationPage;
import com.farm.service.FertilizeSoilRemediationService;
import com.farm.util.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/fertilize/soilRemediation"})
@Api(tags={"\u7cbe\u51c6\u65bd\u80a5-\u571f\u58e4\u6cbb\u7406"})
public class FertilizeSolidRemediationController {
    private static final Logger log = LoggerFactory.getLogger(FertilizeSolidRemediationController.class);
    @Autowired
    FertilizeSoilRemediationService fertilizeSoilRemediationService;

    @GetMapping(value={"/getList"})
    @ApiOperation(value="\u6761\u4ef6\u67e5\u8be2")
    public ResultVo querySolidRemediationPage(SoilRemediationPage soilRemediationPage) {
        Integer start = (soilRemediationPage.getPage() - 1) * soilRemediationPage.getPageSize();
        soilRemediationPage.setStart(start);
        long count = this.fertilizeSoilRemediationService.getListPageCount(soilRemediationPage);
        List soilRemediationList = this.fertilizeSoilRemediationService.getListPage(soilRemediationPage);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("count", (Object)count);
        jsonObject.put("list", (Object)soilRemediationList);
        return ResultVo.success((Object)jsonObject);
    }

    @PostMapping(value={"/importFileData"})
    public ResultVo importFileData(@RequestParam(value="file") MultipartFile file) throws IOException {
        try {
            JSONObject vo = this.fertilizeSoilRemediationService.importFileData(file);
            return ResultVo.success((Object)vo);
        }
        catch (Exception e) {
            ResultVo.error((String)e.getMessage());
            return ResultVo.success();
        }
    }

    @GetMapping(value={"/export"})
    @ApiOperation(value="\u5bfc\u51fa\u6570\u636e")
    public void exportSoilRemediationData(HttpServletResponse response, SoilRemediationPage soilRemediationPage) throws IOException {
        this.fertilizeSoilRemediationService.exportSoilRemediationData(response, soilRemediationPage);
    }

    @GetMapping(value={"/getLGEph"})
    @ApiOperation(value="\u571f\u58e4\u6cbb\u7406\u6210\u6548-PH")
    public ResultVo getLandGovernanceEffectivenessPh(SoilRemediationPage soilRemediationPage) {
        return ResultVo.success((Object)this.fertilizeSoilRemediationService.getLandGovernanceEffectivenessPh(soilRemediationPage));
    }

    @GetMapping(value={"/getLGEom"})
    @ApiOperation(value="\u571f\u58e4\u6cbb\u7406\u6210\u6548-\u6709\u673a\u7269")
    public ResultVo getLandGovernanceEffectivenessBOM(SoilRemediationPage soilRemediationPage) {
        return ResultVo.success((Object)this.fertilizeSoilRemediationService.getLandGovernanceEffectivenessBOM(soilRemediationPage));
    }

    @GetMapping(value={"/getLGEtn"})
    @ApiOperation(value="\u571f\u58e4\u6cbb\u7406\u6210\u6548-\u5168\u6c2e")
    public ResultVo getLandGovernanceEffectivenessBTN(SoilRemediationPage soilRemediationPage) {
        return ResultVo.success((Object)this.fertilizeSoilRemediationService.getLandGovernanceEffectivenessBTN(soilRemediationPage));
    }

    @GetMapping(value={"/getLGEap"})
    @ApiOperation(value="\u571f\u58e4\u6cbb\u7406\u6210\u6548-\u6709\u6548\u78f7")
    public ResultVo getLandGovernanceEffectivenessBAP(SoilRemediationPage soilRemediationPage) {
        return ResultVo.success((Object)this.fertilizeSoilRemediationService.getLandGovernanceEffectivenessBAP(soilRemediationPage));
    }

    @GetMapping(value={"/getLGEk"})
    @ApiOperation(value="\u571f\u58e4\u6cbb\u7406\u6210\u6548-\u901f\u6548\u94be")
    public ResultVo getLandGovernanceEffectivenessBK(SoilRemediationPage soilRemediationPage) {
        return ResultVo.success((Object)this.fertilizeSoilRemediationService.getLandGovernanceEffectivenessBK(soilRemediationPage));
    }

    @GetMapping(value={"/getLGEsk"})
    @ApiOperation(value="\u571f\u58e4\u6cbb\u7406\u6210\u6548-\u7f13\u6548\u94be")
    public ResultVo getLandGovernanceEffectivenessBSK(SoilRemediationPage soilRemediationPage) {
        return ResultVo.success((Object)this.fertilizeSoilRemediationService.getLandGovernanceEffectivenessBSK(soilRemediationPage));
    }
}

