/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller.pest;

import com.alibaba.fastjson.JSONObject;
import com.farm.bean.NutrientMiss;
import com.farm.service.NutrientMissService;
import com.farm.util.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/nutrient"})
@Api(tags={"\u7f3a\u7d20\u5e93"})
public class MissNutrientController {
    @Autowired
    private NutrientMissService nutrientMissService;

    @PostMapping(value={"/top-stop"})
    @ApiOperation(value="\u7f6e\u9876\uff0c\u505c\u7528")
    public Object updateTopStopFlag(@RequestParam(name="ids", required=false) List<String> ids, @RequestParam(name="status", required=false) Integer status, @RequestParam(name="topFlag", required=false, defaultValue="") Integer topFlag) {
        if (status != null) {
            this.nutrientMissService.updateNutrientStatus(ids, status);
        }
        if (topFlag != null) {
            this.nutrientMissService.updateNutrientTopFlag(ids, topFlag);
        }
        return ResultVo.success();
    }

    @PostMapping(value={"/del"})
    @ApiOperation(value="\u5220\u9664")
    public Object delNutrientMiss(@RequestParam(name="ids") List<Integer> ids) {
        this.nutrientMissService.removeByIds(ids);
        return ResultVo.success();
    }

    @PostMapping(value={"/upsert"})
    @ApiOperation(value="\u65b0\u589e\u7f16\u8f91")
    public Object upsertNutrientMiss(@RequestBody NutrientMiss nutrientMiss) {
        if (nutrientMiss.getId() == null) {
            nutrientMiss.setStatus(Integer.valueOf(1));
            nutrientMiss.setTopFlag(Integer.valueOf(0));
            this.nutrientMissService.insert(nutrientMiss);
        } else {
            this.nutrientMissService.update(nutrientMiss);
        }
        return ResultVo.success();
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="PC\u7f3a\u7d20\u5e93\u5217\u8868")
    public Object listNutrientMiss(@RequestParam(name="search", required=false, defaultValue="") String search, @RequestParam(name="crops", required=false) List<String> crops, @RequestParam(name="status", required=false) Integer status, @RequestParam(name="topFlag", required=false) Integer topFlag, @RequestParam(name="page", required=false, defaultValue="1") Integer page, @RequestParam(name="pageSize", required=false, defaultValue="10") Integer pageSize) {
        Integer offset = (page - 1) * pageSize;
        Integer count = this.nutrientMissService.countByLimit(status, search, crops, topFlag);
        List list = this.nutrientMissService.queryAllByLimit(status, search, crops, offset, pageSize, topFlag);
        JSONObject json = new JSONObject();
        json.put("list", (Object)list);
        json.put("count", (Object)count);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/detail"})
    @ApiOperation(value="\u7f3a\u7d20\u5e93\u8be6\u60c5")
    public Object detailNutrientMiss(Integer id) {
        NutrientMiss detail = this.nutrientMissService.queryById(id);
        JSONObject json = new JSONObject();
        json.put("detail", (Object)detail);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/validList"})
    @ApiOperation(value="APP\u7f3a\u7d20\u5e93\u5217\u8868")
    public Object listNutrientMiss(@RequestParam(name="search", required=false, defaultValue="") String search, @RequestParam(name="crops", required=false) List<String> crops, @RequestParam(name="page", required=false, defaultValue="1") Integer page, @RequestParam(name="pageSize", required=false, defaultValue="20") Integer pageSize) {
        Integer offset = (page - 1) * pageSize;
        Integer count = this.nutrientMissService.countByLimit(Integer.valueOf(1), search, crops, null);
        List list = this.nutrientMissService.queryAllByLimit(Integer.valueOf(1), search, crops, offset, pageSize, null);
        JSONObject json = new JSONObject();
        json.put("list", (Object)list);
        json.put("count", (Object)count);
        return ResultVo.success((Object)json);
    }
}

