/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller.pest;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.PestControlInfo;
import com.farm.service.PestControlService;
import com.farm.util.HttpSendUtil;
import com.farm.util.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/pest-control"})
@Api(tags={"\u75c5\u866b\u5bb3\u9632\u6cbb"})
public class PestController {
    private static final Logger log = LoggerFactory.getLogger(PestController.class);
    @Autowired
    private PestControlService pestControlService;
    @Value(value="${crop.insectPest.appCode}")
    private String insectPestAppCode;
    @Autowired
    private StringRedisTemplate redisTemplate;
    public static final String KEY = "ruikunInsectToken";
    private static final String CLIENT_ID = "shuxikeji";
    private static final String REDIRECT_URI = "http://www.shuxikeji.com";
    private static final String CLIENT_SECRET = "shuxikeji,rkkj2018";
    private static final String HOST = "https://www.cleverplanting.com";
    private static final String PERMISSIONURL = "/ndj-open-ai/oauth/token";
    private static final String CROPLISTURL = "/ndj-open-ai/ndj-api/v1/crop/get-crop-list";
    private static final String UPLOADFILEURL = "/ndj-open-ai/v1/img-upload/save-discern-img";
    private static final String IDENTIFYINSECTURL = "/ndj-open-ai/ndj-api/v1/discern/ai-discern";
    private static final String ADVISEINSECTURL = "/ndj-open-ai/ndj-api/v1/pests-diseases/findByPdIds";
    private static final String RECOMMENDMEDICINEURL = "/ndj-open-ai/ndj-api/v1/pests-diseases/pestcideByPdId";
    private static final String HOSTNEW = "http://114.115.152.167:8011";
    @Value(value="${farm.serverUrl}")
    private String farmServerUrl;

    @PostMapping(value={"/info/upsert"})
    @ApiOperation(value="\u65b0\u589e/\u4fee\u6539\u75c5\u866b\u5bb3\u5e93")
    public ResultVo upsertPestLibrary(@RequestBody String body) {
        PestControlInfo pestControlInfo = (PestControlInfo)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), PestControlInfo.class);
        if (pestControlInfo.getId() == null) {
            this.pestControlService.insert(pestControlInfo);
        } else {
            this.pestControlService.update(pestControlInfo);
        }
        return ResultVo.success((Object)pestControlInfo);
    }

    @GetMapping(value={"/info/detail"})
    @ApiOperation(value="\u75c5\u866b\u5bb3\u5e93\u8be6\u60c5")
    public ResultVo queryPestLibraryDetail(@RequestParam(value="id") Integer id) {
        return ResultVo.success((Object)this.pestControlService.queryPestLibraryDetail(id));
    }

    @GetMapping(value={"/info/page"})
    @ApiOperation(value="\u75c5\u866b\u5bb3\u5e93\u5217\u8868")
    public ResultVo queryPestLibraryPage(@RequestParam(value="name", required=false, defaultValue="") String name, @RequestParam(value="status", required=false) Integer status, @RequestParam(value="type", required=false) Integer type, @RequestParam(value="cropIdString", required=false, defaultValue="") String cropIdString, @RequestParam(value="remindId", required=false) Integer remindId, @RequestParam(value="dangerLevel", required=false) Integer dangerLevel, @RequestParam(value="startTime", required=false, defaultValue="") String startTime, @RequestParam(value="endTime", required=false, defaultValue="") String endTime, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize) {
        List<Object> cropIdList = cropIdString.equals("") ? new ArrayList() : Arrays.asList(cropIdString.split(","));
        Integer start = (page - 1) * pageSize;
        return ResultVo.success((Object)this.pestControlService.queryPestLibraryPage(name, status, type, cropIdList, remindId, dangerLevel, startTime, endTime, start, pageSize));
    }

    @PostMapping(value={"/info/del"})
    @ApiOperation(value="\u505c\u7528/\u7f6e\u9876/\u5220\u9664\u75c5\u866b\u5bb3\u5e93")
    public ResultVo delDisableTopPestLibrary(@RequestParam(value="id") Integer id, @RequestParam(value="type", required=false) Integer type, @RequestParam(value="status", required=false) Integer status, @RequestParam(value="top", required=false) Integer top) {
        this.pestControlService.delDisableTopPestLibrary(id, type, top, status);
        return ResultVo.success();
    }

    @GetMapping(value={"/info/summary"})
    @ApiOperation(value="\u6570\u636e\u7edf\u8ba1")
    public ResultVo queryPestSummary(@RequestParam(value="name", required=false, defaultValue="") String name, @RequestParam(value="type", required=false) Integer type, @RequestParam(value="cropIdString", required=false, defaultValue="") String cropIdString, @RequestParam(value="startTime", required=false, defaultValue="") String startTime, @RequestParam(value="endTime", required=false, defaultValue="") String endTime, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize) {
        List<Object> cropIdList = cropIdString.equals("") ? new ArrayList() : Arrays.asList(cropIdString.split(","));
        Integer start = (page - 1) * pageSize;
        return ResultVo.success((Object)this.pestControlService.queryPestSummary(name, type, cropIdList, startTime, endTime, start, pageSize));
    }

    @GetMapping(value={"/recommend"})
    public Object queryDiseaseRecommend(String cropId, String pdId) {
        String token = this.queryValidToken();
        JSONObject reqBody = new JSONObject();
        reqBody.put("cropId", (Object)cropId);
        reqBody.put("pdId", (Object)pdId);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", "Bearer " + token);
        String response = HttpSendUtil.sendHttpPost((String)HOST, (String)RECOMMENDMEDICINEURL, (String)"", (String)reqBody.toJSONString(), header);
        JSONObject resJson = JSONObject.parseObject((String)response);
        if (resJson.getInteger("code") == 0) {
            return ResultVo.success((Object)resJson.getJSONArray("data"));
        }
        log.error("\u67e5\u8be2\u63a8\u8350\u7528\u836f\u62a5\u9519\uff1a{}", (Object)resJson);
        return ResultVo.success((Object)new JSONArray());
    }

    public String queryValidToken() {
        String token = (String)this.redisTemplate.opsForValue().get((Object)KEY);
        if (token == null || "".equals(token)) {
            StringBuffer url = new StringBuffer("?");
            url.append("client_id=").append(CLIENT_ID).append("&grant_type=client_credentials").append("&redirect_uri=").append(REDIRECT_URI).append("&client_secret=").append(CLIENT_SECRET);
            String response = HttpSendUtil.sendHttpPost((String)HOST, (String)PERMISSIONURL, (String)url.toString(), (String)"");
            JSONObject resJson = JSONObject.parseObject((String)response);
            if (resJson.getInteger("code") == 0) {
                token = resJson.getJSONObject("data").getString("access_token");
                this.redisTemplate.opsForValue().set((Object)KEY, (Object)token, (long)resJson.getJSONObject("data").getInteger("expires_in").intValue(), TimeUnit.SECONDS);
            } else {
                log.error("\u6388\u6743\u83b7\u53d6token\u62a5\u9519\uff1a{}", (Object)resJson);
            }
        }
        return token;
    }

    @PostMapping(value={"/upload"})
    @ApiOperation(value="\u777f\u5764\u56fe\u7247\u6587\u4ef6\u4e0a\u4f20")
    public Object uploadFile(@RequestParam(value="file") MultipartFile file) {
        String contype = file.getContentType();
        System.out.println(contype);
        String token = this.queryValidToken();
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", "Bearer " + token);
        JSONObject resJson = HttpSendUtil.sendPostFile((String)"https://www.cleverplanting.com/ndj-open-ai/v1/img-upload/save-discern-img", (MultipartFile)file, header);
        if (resJson.getInteger("code") == 0) {
            return ResultVo.success((Object)resJson.getJSONObject("data"));
        }
        log.error("\u4e0a\u4f20\u8bc6\u522b\u56fe\u7247\u62a5\u9519\uff1a{}", (Object)resJson);
        return ResultVo.success((Object)resJson);
    }

    @PostMapping(value={"/uploadBase64"})
    @ApiOperation(value="\u777f\u5764\u56fe\u7247\u6587\u4ef6\u4e0a\u4f20Base64")
    public Object uploadFile(@RequestBody String body) {
        JSONObject obj = JSONObject.parseObject((String)body);
        String base64 = obj.getString("base64");
        JSONObject paramJson = new JSONObject();
        String url = "http://114.115.152.167:8011/pdc/uploadimg";
        paramJson.put("crop", (Object)obj.getString("crop"));
        paramJson.put("base64", (Object)base64);
        String resJson = null;
        JSONObject jsonObject = null;
        try {
            resJson = HttpSendUtil.sendHttpPost((String)url, (String)"", (String)"", (String)paramJson.toJSONString());
            jsonObject = JSONObject.parseObject((String)resJson);
            return ResultVo.success((Object)jsonObject);
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u8bc6\u522b\u56fe\u7247\u62a5\u9519\uff1a{}", (Object)e.getMessage());
            return ResultVo.success((Object)resJson);
        }
    }

    @PostMapping(value={"/identify"})
    @ApiOperation(value="\u75c5\u866b\u5bb3\u8bc6\u522b")
    public ResultVo insertPestIdentify(@RequestParam(value="cropType") String cropType, @RequestParam(value="cameraAngle") String cameraAngle, @RequestParam(value="imageUrl") String imageUrl, @RequestParam(value="userId") String userId) {
        JSONObject reqBody = new JSONObject();
        reqBody.put("crop", (Object)cropType);
        reqBody.put("url", (Object)imageUrl);
        String response = HttpSendUtil.sendHttpPost((String)"http://114.115.152.167:8011/pdc/result", (String)"", (String)"", (String)reqBody.toJSONString());
        JSONObject resJson = JSONObject.parseObject((String)response);
        for (int i = 0; i < 3 && resJson != null && StringUtils.equals((CharSequence)resJson.getString("status"), (CharSequence)"\u672a\u8ba1\u7b97"); ++i) {
            Thread.sleep(1500L);
            resJson = JSONObject.parseObject((String)HttpSendUtil.sendHttpPost((String)"http://114.115.152.167:8011/pdc/result", (String)"", (String)"", (String)reqBody.toJSONString()));
        }
        if (resJson == null) {
            resJson = new JSONObject();
            resJson.put("similarPDs", null);
        }
        resJson.put("cropId", (Object)cropType);
        resJson.put("identifyImg", (Object)imageUrl);
        switch (cropType) {
            case "GJ": {
                resJson.put("cropName", (Object)"\u67d1\u6a58");
                break;
            }
            case "PG": {
                resJson.put("cropName", (Object)"\u82f9\u679c");
                break;
            }
            case "SD": {
                resJson.put("cropName", (Object)"\u6c34\u7a3b");
                break;
            }
            case "XM": {
                resJson.put("cropName", (Object)"\u5c0f\u9ea6");
                break;
            }
            case "YM": {
                resJson.put("cropName", (Object)"\u7389\u7c73");
                break;
            }
            case "LJ": {
                resJson.put("cropName", (Object)"\u8fa3\u6912");
            }
        }
        return ResultVo.success((Object)this.pestControlService.insertPestIdentify(resJson, cropType, imageUrl, cameraAngle, userId));
    }

    @GetMapping(value={"/diseaseDetail"})
    public Object queryDiseaseDetail(String cropId, String pdIds) {
        JSONObject resJson = null;
        String url = this.farmServerUrl + "crop/queryDisInsPesDetailByPdId?pdId=" + pdIds + "&cropId=" + cropId + "&hash=x";
        try {
            String result = HttpSendUtil.sendHttpGet((String)url);
            resJson = JSONObject.parseObject((String)result);
            if (resJson.getInteger("resCode") == 0) {
                resJson = this.pestControlService.insertDiseaseDetailNew(resJson.getJSONObject("resData"), cropId);
            }
            return ResultVo.success((Object)resJson);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u75c5\u866b\u5bb3\u8be6\u60c5\u4e0e\u9632\u6cbb\u5efa\u8bae\u62a5\u9519\uff1a" + e.getMessage());
            return ResultVo.success();
        }
    }
}

