/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller.record;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.FarmCropPlan;
import com.farm.bean.FarmCropRecord;
import com.farm.service.FarmCropPlanService;
import com.farm.service.FarmCropRecordService;
import com.farm.util.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/farm-crop"})
@Api(tags={"\u79cd\u690d\u7ba1\u7406\u65b9\u6848"})
public class FarmCropController {
    @Autowired
    private FarmCropPlanService farmCropPlanService;
    @Autowired
    private FarmCropRecordService farmCropRecordService;

    @PostMapping(value={"/plan-batchAdd"})
    @ApiOperation(value="\u6279\u91cf\u589e\u52a0\u79cd\u690d\u65b9\u6848")
    public ResultVo batchAddPlan(@RequestBody String body) {
        this.farmCropPlanService.batchAdd(body);
        return ResultVo.success();
    }

    @PostMapping(value={"/plan-upsert"})
    @ApiOperation(value="\u65b0\u589e/\u4fee\u6539\u79cd\u690d\u65b9\u6848")
    public ResultVo upsertFarmCropPlan(@RequestBody String body) {
        FarmCropPlan farmCropPlan = (FarmCropPlan)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), FarmCropPlan.class);
        if (farmCropPlan.getId() == null) {
            this.farmCropPlanService.insert(farmCropPlan);
        } else {
            this.farmCropPlanService.update(farmCropPlan);
        }
        return ResultVo.success();
    }

    @GetMapping(value={"/plan-detail"})
    @ApiOperation(value="\u79cd\u690d\u65b9\u6848\u8be6\u60c5")
    public ResultVo queryCropPlanDetail(@RequestParam(value="id") Integer id) {
        return ResultVo.success((Object)this.farmCropPlanService.queryCropPlanDetail(id));
    }

    @GetMapping(value={"/plan-type"})
    @ApiOperation(value="\u6839\u636e\u4f5c\u7269\u67e5\u8be2\u63a8\u8350\u65b9\u6848")
    public ResultVo queryCropPlanByCropType(@RequestParam(value="cropType") Integer cropType) {
        return ResultVo.success((Object)this.farmCropPlanService.queryCropPlanByCropType(cropType));
    }

    @GetMapping(value={"/plan-page"})
    @ApiOperation(value="\u6761\u4ef6\u5206\u9875")
    public ResultVo queryCropPlanPage(@RequestParam(value="cropType", required=false) Integer cropType, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        return ResultVo.success((Object)this.farmCropPlanService.queryCropPlanPage(cropType, start, pageSize));
    }

    @PostMapping(value={"/plan-disable"})
    @ApiOperation(value="\u505c\u7528/\u53d1\u5e03")
    public ResultVo disableCropPlan(@RequestParam(value="id") Integer id, @RequestParam(value="status") Integer status) {
        this.farmCropPlanService.disableCropPlan(id, status);
        return ResultVo.success();
    }

    @PostMapping(value={"/plan-del"})
    @ApiOperation(value="\u5220\u9664\u65b9\u6848")
    public ResultVo deleteCropPlanById(@RequestParam(value="plan") Integer planId) {
        this.farmCropPlanService.deleteCropPlanById(planId);
        return ResultVo.success();
    }

    @PostMapping(value={"/record-batchAdd"})
    @ApiOperation(value="\u6279\u91cf\u65b0\u589e\u519c\u4e8b\u8bb0\u5f55")
    public ResultVo batchAddRecord(@RequestBody String body) {
        this.farmCropRecordService.batchAdd(body);
        return ResultVo.success();
    }

    @PostMapping(value={"/record-upsert"})
    @ApiOperation(value="\u65b0\u589e/\u4fee\u6539\u519c\u4e8b\u8bb0\u5f55")
    public ResultVo upsertCropRecord(@RequestBody String body) {
        FarmCropRecord farmCropRecord = (FarmCropRecord)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), FarmCropRecord.class);
        if (farmCropRecord.getId() == null) {
            this.farmCropRecordService.insert(farmCropRecord);
        } else {
            this.farmCropRecordService.update(farmCropRecord);
        }
        return ResultVo.success();
    }

    @GetMapping(value={"/record-field"})
    @ApiOperation(value="\u67e5\u8be2\u7530\u5757\u7684\u519c\u4e8b\u8bb0\u5f55")
    public ResultVo queryCropRecordListByFieldId(@RequestParam(value="fieldId") Integer fieldId, @RequestParam(value="type") Integer type) {
        return ResultVo.success((Object)this.farmCropRecordService.queryCropRecordListByFieldId(fieldId, type));
    }

    @PostMapping(value={"/record-del"})
    @ApiOperation(value="\u5220\u9664\u519c\u4e8b\u8bb0\u5f55")
    public ResultVo deleteCropRecordById(@RequestParam(value="recordId") Integer recordId) {
        this.farmCropRecordService.deleteCropRecordById(recordId);
        return ResultVo.success();
    }

    @GetMapping(value={"/record-detail"})
    @ApiOperation(value="\u519c\u4e8b\u8bb0\u5f55\u8be6\u60c5")
    public ResultVo queryCropRecordDetail(@RequestParam(value="id") Integer id) {
        return ResultVo.success((Object)this.farmCropRecordService.queryCropRecordDetail(id));
    }

    @GetMapping(value={"/record-system"})
    @ApiOperation(value="\u7cfb\u7edf\u63a8\u8350\u65b9\u6848")
    public ResultVo queryCropRecordSystem(@RequestParam(value="field") Integer fieldId, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        return ResultVo.success((Object)this.farmCropPlanService.queryCropRecordSystem(fieldId, start, pageSize));
    }

    @PostMapping(value={"/use-record"})
    @ApiOperation(value="\u5e94\u7528\u65b9\u6848")
    public ResultVo useCropRecord(@RequestParam(value="recordIdString", required=false, defaultValue="") String recordIdString, @RequestParam(value="fieldId", required=false, defaultValue="") Integer fieldId, @RequestParam(value="type") Integer type) {
        List<Object> recordIdList = recordIdString.equals("") ? new ArrayList() : Arrays.asList(recordIdString.split(","));
        this.farmCropPlanService.useCropRecord(recordIdList, fieldId, type);
        return ResultVo.success();
    }

    @GetMapping(value={"/record-list"})
    @ApiOperation(value="\u7528\u6237\u7530\u5757\u519c\u4e8b\u8bb0\u5f55")
    public ResultVo queryFieldRecordList(@RequestParam(value="fieldId") Integer fieldId, @RequestParam(value="date", required=false, defaultValue="") String date, @RequestParam(value="farmType", required=false) Integer farmType, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        return ResultVo.success((Object)this.farmCropPlanService.queryFieldRecordList(fieldId, start, pageSize, date, farmType));
    }

    @GetMapping(value={"/record-calendar"})
    @ApiOperation(value="\u7528\u6237\u7530\u5757\u519c\u4e8b\u65e5\u5386")
    public ResultVo queryFieldRecordCalendar(@RequestParam(value="fieldId") Integer fieldId, @RequestParam(value="date", required=false, defaultValue="") String date) {
        return ResultVo.success((Object)this.farmCropPlanService.queryFieldRecordCalendar(fieldId, date));
    }

    @GetMapping(value={"/classify-list"})
    public ResultVo queryResourceClassifyList() {
        return ResultVo.success((Object)this.farmCropPlanService.queryResourceClassifyList());
    }

    @GetMapping(value={"/classify/use-ratio"})
    public ResultVo queryClassifyUseRatio(@RequestParam(value="classifyId") Integer classifyId, @RequestParam(value="startTime") String startTime, @RequestParam(value="endTime") String endTime) {
        return ResultVo.success((Object)this.farmCropPlanService.queryClassifyUseRatio(classifyId, startTime, endTime));
    }

    @GetMapping(value={"/type/use-ratio"})
    public ResultVo queryFarmTypeUseRatio(@RequestParam(value="startTime") String startTime, @RequestParam(value="endTime") String endTime) {
        return ResultVo.success((Object)this.farmCropPlanService.queryFarmTypeUseRatio(startTime, endTime));
    }

    @GetMapping(value={"/type/count"})
    public ResultVo queryFarmCountByStat(@RequestParam(value="type") Integer type) {
        return ResultVo.success((Object)this.farmCropPlanService.queryFarmCountByStat(type));
    }

    @GetMapping(value={"/classify/use-order"})
    public ResultVo queryFarmClassifyUseOrder(@RequestParam(value="time") String time, @RequestParam(value="classifyId") Integer classifyId) {
        return ResultVo.success((Object)this.farmCropPlanService.queryFarmClassifyUseOrder(time, classifyId));
    }
}

