/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller.record;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.FarmResourceClassify;
import com.farm.service.FarmResourceClassifyService;
import com.farm.util.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/farm-resource"})
@Api(tags={"\u519c\u4e8b\u8d44\u6e90\u7ef4\u62a4"})
public class FarmResourceClassifyController {
    @Autowired
    private FarmResourceClassifyService farmResourceClassifyService;

    @PostMapping(value={"/upsert"})
    @ApiOperation(value="\u65b0\u589e/\u4fee\u6539")
    public ResultVo upsertResourceClassify(@RequestBody String body) {
        FarmResourceClassify farmResourceClassify = (FarmResourceClassify)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), FarmResourceClassify.class);
        if (farmResourceClassify.getId() == null) {
            this.farmResourceClassifyService.insert(farmResourceClassify);
        } else {
            this.farmResourceClassifyService.update(farmResourceClassify);
        }
        return ResultVo.success();
    }

    @PostMapping(value={"/del"})
    @ApiOperation(value="\u5220\u9664")
    public ResultVo deleteResourceClassify(@RequestParam(value="id") Integer id) {
        this.farmResourceClassifyService.deleteResourceClassify(id);
        return ResultVo.success();
    }

    @PostMapping(value={"/disable-top"})
    @ApiOperation(value="\u505c\u7528/\u7f6e\u9876")
    public ResultVo disableOrTopResourceClassify(@RequestParam(value="id") Integer id, @RequestParam(value="topFlag", required=false) Integer topFlag, @RequestParam(value="status", required=false) Integer status) {
        if (topFlag != null) {
            this.farmResourceClassifyService.topResourceClassify(id, topFlag);
        }
        if (status != null) {
            this.farmResourceClassifyService.disableResourceClassify(id, status);
        }
        return ResultVo.success();
    }

    @GetMapping(value={"/detail"})
    @ApiOperation(value="\u5206\u7c7b\u8be6\u60c5")
    public ResultVo queryResourceClassifyDetail(@RequestParam(value="id") Integer id) {
        return ResultVo.success((Object)this.farmResourceClassifyService.queryResourceClassifyDetail(id));
    }

    @GetMapping(value={"/page"})
    @ApiOperation(value="\u6761\u4ef6\u5206\u9875")
    public ResultVo queryResourceClassifyPage(@RequestParam(value="name", required=false, defaultValue="") String name, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        return ResultVo.success((Object)this.farmResourceClassifyService.queryResourceClassifyPage(name, start, pageSize));
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u5206\u7c7b\u5217\u8868")
    public ResultVo queryResourceClassifyList(@RequestParam(value="search", required=false, defaultValue="") String search) {
        return ResultVo.success((Object)this.farmResourceClassifyService.queryResourceClassifyList(search));
    }
}

