/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller.recycle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.RecycleFormInfo;
import com.farm.service.RecycleFormInfoService;
import com.farm.util.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/recycle-form"})
@Api(tags={"\u5e9f\u5f03\u7269\u56de\u6536-\u8868\u5355"})
public class RecycleFormInfoController {
    @Resource
    private RecycleFormInfoService recycleFormInfoService;

    @GetMapping(value={"/detail"})
    @ApiOperation(value="\u67e5\u8be2\u8868\u5355\u8be6\u60c5")
    public ResultVo selectOne(Integer id) {
        RecycleFormInfo dto = this.recycleFormInfoService.queryById(id);
        return ResultVo.success((Object)dto);
    }

    @PostMapping
    @ApiOperation(value="\u5220\u9664\u8868\u5355")
    public Object delete(@RequestParam(value="idList") List<Integer> idList) {
        this.recycleFormInfoService.removeByIds(idList);
        return ResultVo.success();
    }

    @PostMapping(value={"/upsert"})
    @ApiOperation(value="\u63d0\u4ea4\u5e9f\u5f03\u7269\u56de\u6536\u5355")
    public Object upsertRecycleForm(@RequestBody String body) {
        RecycleFormInfo item = (RecycleFormInfo)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), RecycleFormInfo.class);
        JSONObject json = new JSONObject();
        json.put("flag", (Object)0);
        if (item.getId() == null) {
            json = this.recycleFormInfoService.insert(item);
        } else {
            this.recycleFormInfoService.update(item);
        }
        return ResultVo.success((Object)json);
    }

    @PostMapping(value={"/submitWareHouse"})
    @ApiOperation(value="\u5165\u5e93\u5355\u5b50")
    public Object submitWareHouse(@RequestBody String body) {
        JSONObject json = JSONObject.parseObject((String)body);
        Integer id = json.getInteger("id");
        String remarks = json.getString("remarks");
        this.recycleFormInfoService.submitWareHouse(id, remarks);
        return ResultVo.success();
    }

    @PostMapping(value={"/audit"})
    @ApiOperation(value="\u5ba1\u6838\u5e9f\u5f03\u7269\u56de\u6536\u5355")
    public Object auditRecycleForm(@RequestBody String body) {
        JSONObject json = JSONObject.parseObject((String)body);
        Integer status = json.getInteger("status");
        Integer id = json.getInteger("id");
        Integer desPointId = json.getInteger("desPointId");
        String auditComment = json.getString("auditComment");
        String recycleTime = json.getString("recycleTime");
        JSONObject resJson = this.recycleFormInfoService.auditRecycleForm(status, id, auditComment, recycleTime, desPointId);
        return ResultVo.success((Object)resJson);
    }

    @GetMapping(value={"/user-point/list"})
    @ApiOperation(value="\u7528\u6237\u6216\u7ad9\u70b9\u63d0\u4ea4\u5355\u5386\u53f2\u5217\u8868")
    public Object queryUserOrPointRecycleFormList(@RequestParam(required=false, defaultValue="", value="") String userId, @RequestParam(required=false, defaultValue="", value="") Integer pointId, @RequestParam(required=false, defaultValue="", value="") Integer status, @RequestParam(required=false, value="pageSize", defaultValue="10") Integer pageSize, @RequestParam(required=false, value="page", defaultValue="1") Integer page) {
        Integer offset = (page - 1) * pageSize;
        JSONObject json = this.recycleFormInfoService.queryUserRecycleFormList(userId, offset, pageSize, status, pointId);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/point/list"})
    @ApiOperation(value="\u7ad9\u70b9-\u5f52\u96c6\u76f8\u5173\u5217\u8868")
    public Object queryPointRecycleFormList(@RequestParam(required=false, defaultValue="", value="") Integer pointId, @RequestParam(required=false, defaultValue="", value="") Integer status, @RequestParam(required=false, value="pageSize", defaultValue="10") Integer pageSize, @RequestParam(required=false, value="page", defaultValue="1") Integer page) {
        Integer offset = (page - 1) * pageSize;
        JSONObject json = this.recycleFormInfoService.queryPointRecycleFormList(offset, pageSize, status, pointId);
        return ResultVo.success((Object)json);
    }
}

