/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller.recycle;

import com.farm.service.RecyclePointInfoService;
import com.farm.util.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/recycle-info-summary"})
@Api(tags={"\u519c\u8d44\u5e9f\u5f03\u7269\u56de\u6536\u6c47\u603b"})
public class RecycleInfoSummaryController {
    @Autowired
    private RecyclePointInfoService recyclePointInfoService;

    @GetMapping(value={"/realTime"})
    @ApiOperation(value="\u5b9e\u65f6\u6570\u636e")
    public ResultVo selectSummaryRealTimeData(@RequestParam(value="pointIdList", required=false, defaultValue="") String pointIdList, @RequestParam(value="regionCodeList", required=false, defaultValue="") String regionCodeList, @RequestParam(value="type") Integer type, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        List<Object> pointIdString = pointIdList.equals("") ? new ArrayList() : Arrays.asList(pointIdList.split(","));
        List<Object> regionCodeString = regionCodeList.equals("") ? new ArrayList() : Arrays.asList(regionCodeList.split(","));
        return ResultVo.success((Object)this.recyclePointInfoService.selectSummaryRealTimeData(pointIdString, regionCodeString, type, start, pageSize));
    }

    @GetMapping(value={"/storageAmount"})
    @ApiOperation(value="\u5165\u5e93\u91cf")
    public ResultVo selectSummaryStorageAmountData(@RequestParam(value="pointIdList", required=false, defaultValue="") String pointIdList, @RequestParam(value="regionCodeList", required=false, defaultValue="") String regionCodeList, @RequestParam(value="type") Integer type, @RequestParam(value="timeType") Integer timeType, @RequestParam(value="timeList", required=false, defaultValue="") String timeList, @RequestParam(value="page", defaultValue="1") Integer page, @RequestParam(value="pageSize", defaultValue="20") Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        List<Object> timeString = timeList.equals("") ? new ArrayList() : Arrays.asList(timeList.split(","));
        List<Object> pointIdString = pointIdList.equals("") ? new ArrayList() : Arrays.asList(pointIdList.split(","));
        List<Object> regionCodeString = regionCodeList.equals("") ? new ArrayList() : Arrays.asList(regionCodeList.split(","));
        return ResultVo.success((Object)this.recyclePointInfoService.selectSummaryStorageAmountData(pointIdString, regionCodeString, type, timeType, timeString, start, pageSize));
    }

    @GetMapping(value={"/pointDetail"})
    @ApiOperation(value="\u7ad9\u70b9\u8be6\u60c5")
    public ResultVo selectPointSummaryDataByPointId(@RequestParam(value="pointId") Integer pointId, @RequestParam(value="startTime", required=false, defaultValue="") String startTime, @RequestParam(value="endTime", required=false, defaultValue="") String endTime) {
        return ResultVo.success((Object)this.recyclePointInfoService.selectPointSummaryDataByPointId(pointId, startTime, endTime));
    }
}

