/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller.recycle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.RecycleNews;
import com.farm.service.RecycleNewsService;
import com.farm.util.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/recycle-news"})
@Api(tags={"\u516c\u544a\u901a\u77e5"})
public class RecycleNewsController {
    @Autowired
    private RecycleNewsService recycleNewsService;

    @PostMapping
    @ApiOperation(value="\u6dfb\u52a0\u516c\u544a\u901a\u77e5")
    public ResultVo addRecycleNews(@RequestBody String body) {
        RecycleNews recycleNews = (RecycleNews)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), RecycleNews.class);
        if (recycleNews.getId() == null) {
            this.recycleNewsService.addRecycleNews(recycleNews);
        } else {
            this.recycleNewsService.updateRecycleNews(recycleNews);
        }
        return ResultVo.success();
    }

    @GetMapping(value={"/page"})
    @ApiOperation(value="\u5206\u9875\u516c\u544a\u901a\u77e5\u5217\u8868")
    public ResultVo selectRecycleNewsListByPage(@RequestParam(value="title", required=false, defaultValue="") String title, @RequestParam(value="status", required=false) Integer status, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        return ResultVo.success((Object)this.recycleNewsService.selectRecycleNewsListByPage(title, status, start, pageSize));
    }

    @GetMapping
    @ApiOperation(value="\u67e5\u8be2\u6307\u5b9a\u516c\u544a\u901a\u77e5")
    public ResultVo selectRecycleNewsById(@RequestParam(value="id") Integer id) {
        return ResultVo.success((Object)this.recycleNewsService.selectRecycleNewsById(id));
    }

    @DeleteMapping
    @ApiOperation(value="\u522a\u9664\u6307\u5b9a\u516c\u544a\u901a\u77e5")
    public ResultVo deleteRecycleNewsById(@RequestParam(value="id") Integer id) {
        this.recycleNewsService.deleteRecycleNewsById(id);
        return ResultVo.success();
    }

    @PostMapping(value={"/disable"})
    @ApiOperation(value="\u505c\u7528/\u7f6e\u9876\u76f8\u5173\u653f\u7b56")
    public ResultVo disableAndTopRecycleNewsById(@RequestParam(value="id") Integer id, @RequestParam(value="type") Integer type, @RequestParam(value="status") Integer status) {
        this.recycleNewsService.disableAndTopRecycleNewsById(id, type, status);
        return ResultVo.success();
    }
}

