/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller.recycle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.RecyclePointInfo;
import com.farm.service.RecycleLitterAttritionRateService;
import com.farm.service.RecyclePointInfoService;
import com.farm.util.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/recycle-point"})
@Api(tags={"\u5e9f\u5f03\u7269\u56de\u6536\u70b9"})
public class RecyclePointInfoController {
    @Resource
    private RecyclePointInfoService recyclePointInfoService;
    @Autowired
    private RecycleLitterAttritionRateService recycleLitterAttritionRateService;

    @GetMapping(value={"/detail"})
    @ApiOperation(value="\u56de\u6536\u70b9\u8be6\u60c5")
    public ResultVo selectOne(@RequestParam(required=false, defaultValue="", value="id") Integer id, @RequestParam(required=false, defaultValue="", value="userId") String userId) {
        RecyclePointInfo dto = new RecyclePointInfo();
        if (id != null) {
            dto = this.recyclePointInfoService.queryById(id);
        } else if (StringUtils.isNotBlank((String)userId)) {
            dto = this.recyclePointInfoService.queryByUserId(userId);
        }
        return ResultVo.success((Object)dto);
    }

    @PostMapping
    @ApiOperation(value="\u5220\u9664\u56de\u6536\u70b9")
    public Object delete(@RequestParam(value="idList") List<Integer> idList) {
        this.recyclePointInfoService.removeByIds(idList);
        return ResultVo.success();
    }

    @PostMapping(value={"/litterAttritionRate"})
    @ApiOperation(value="\u6dfb\u52a0\u5e9f\u5f03\u7269\u635f\u8017\u7387")
    public ResultVo addRecycleLitterAttritionRate(@RequestParam(value="pointId") Integer pointId, @RequestParam(value="rate") Double rate, @RequestParam(value="startTime") String startTime, @RequestParam(value="endTime") String endTime) {
        this.recycleLitterAttritionRateService.addRecycleLitterAttritionRate(pointId, rate, startTime, endTime);
        return ResultVo.success();
    }

    @GetMapping(value={"/litterAttritionRate"})
    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u56de\u6536\u70b9\u7684\u5e9f\u5f03\u7269\u635f\u8017\u7387")
    public ResultVo selectRecycleLitterAttritionRateList(@RequestParam(value="pointId") Integer pointId) {
        return ResultVo.success((Object)this.recycleLitterAttritionRateService.selectRecycleLitterAttritionRateList(pointId));
    }

    @DeleteMapping(value={"/litterAttritionRate"})
    @ApiOperation(value="\u5220\u9664\u6307\u5b9a\u7684\u5e9f\u5f03\u7269\u635f\u8017\u7387")
    public ResultVo deleteRecycleLitterAttritionRateById(@RequestParam(value="id") Integer id) {
        this.recycleLitterAttritionRateService.deleteRecycleLitterAttritionRateById(id);
        return ResultVo.success();
    }

    @PostMapping(value={"/upsert"})
    @ApiOperation(value="\u65b0\u589e-\u4fee\u6539\u56de\u6536\u70b9")
    public Object upsertPoint(@RequestBody String body) {
        RecyclePointInfo recyclePointInfo = (RecyclePointInfo)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), RecyclePointInfo.class);
        if (recyclePointInfo.getId() != null) {
            this.recyclePointInfoService.update(recyclePointInfo);
        } else {
            this.recyclePointInfoService.insert(recyclePointInfo);
        }
        return ResultVo.success();
    }

    @GetMapping(value={"/near/list"})
    @ApiOperation(value="\u9644\u8fd1\u7684\u56de\u6536\u70b9")
    public Object queryNearRecycleList(@RequestParam(required=false, value="lng", defaultValue="") Double lng, @RequestParam(required=false, value="lat", defaultValue="") Double lat, @RequestParam(required=false, value="pageSize", defaultValue="10") Integer pageSize, @RequestParam(required=false, value="page", defaultValue="1") Integer page) {
        Integer start = (page - 1) * pageSize;
        JSONObject json = this.recyclePointInfoService.queryNearRecycleList(lng, lat, start, pageSize);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/company-list"})
    @ApiOperation(value="\u5e9f\u5f03\u7269\u56de\u6536\u4f01\u4e1a\u5217\u8868")
    public Object queryRecycleCompanyList(@RequestParam(required=false, value="pageSize", defaultValue="10") Integer pageSize, @RequestParam(required=false, value="page", defaultValue="1") Integer page) {
        Integer start = (page - 1) * pageSize;
        JSONObject json = this.recyclePointInfoService.queryRecycleCompanyList(start, pageSize);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u56de\u6536\u7ad9\u70b9\u5217\u8868")
    public ResultVo queryRecyclePointListByType(@RequestParam(value="types") String types, @RequestParam(value="name", required=false, defaultValue="") String name, @RequestParam(required=false, value="pageSize", defaultValue="10") Integer pageSize, @RequestParam(required=false, value="page", defaultValue="1") Integer page) {
        Integer start = (page - 1) * pageSize;
        List<String> typeList = Arrays.asList(types.split(","));
        return ResultVo.success((Object)this.recyclePointInfoService.queryRecyclePointListByType(typeList, name, start, pageSize));
    }
}

