/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller.subsidy;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.SubsidyConsult;
import com.farm.bean.SubsidyFormInfo;
import com.farm.bean.SubsidyProject;
import com.farm.service.SubsidyConsultService;
import com.farm.service.SubsidyFormInfoService;
import com.farm.service.SubsidyProjectService;
import com.farm.util.EasyPoiUtil;
import com.farm.util.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/subsidy"})
@Api(tags={"\u60e0\u519c\u8865\u8d34\u7cfb\u7edf-\u7edf\u8ba1\u76f8\u5173"})
public class SubsidyController {
    @Autowired
    private SubsidyFormInfoService subsidyFormInfoService;
    @Autowired
    private SubsidyProjectService subsidyProjectService;
    @Autowired
    private SubsidyConsultService subsidyConsultService;

    @GetMapping(value={"/project/list"})
    @ApiOperation(value="\u8865\u8d34\u9879\u76ee\u5217\u8868")
    public ResultVo queryProjectList(@RequestParam(required=false, value="types") String types, @RequestParam(defaultValue="", required=false, value="search") String search, @RequestParam(defaultValue="", required=false, value="status") Integer status, @RequestParam(defaultValue="", required=false, value="year") Integer year, @RequestParam(defaultValue="1", required=false, value="page") Integer page, @RequestParam(defaultValue="100", required=false, value="pageSize") Integer pageSize) {
        Integer offset = (page - 1) * pageSize;
        List<Object> list = new ArrayList();
        if (types != null) {
            list = Arrays.asList(types.split(","));
        }
        JSONObject json = this.subsidyProjectService.queryAllByLimit(offset, pageSize, list, search, status, year);
        return ResultVo.success((Object)json);
    }

    @PostMapping(value={"/project/upsert"})
    @ApiOperation(value="\u53d1\u5e03-\u4fee\u6539\u8865\u8d34\u9879\u76ee")
    public ResultVo queryProjectList(@RequestBody SubsidyProject subsidyProject) {
        if (subsidyProject.getId() == null) {
            this.subsidyProjectService.insert(subsidyProject);
        } else {
            this.subsidyProjectService.update(subsidyProject);
        }
        return ResultVo.success((Object)subsidyProject);
    }

    @PostMapping(value={"/project/del"})
    @ApiOperation(value="\u505c\u7528/\u5220\u9664\u8865\u8d34\u9879\u76ee")
    public ResultVo queryProjectList(@RequestBody String body) {
        JSONObject json = JSONObject.parseObject((String)body);
        Integer id = json.getInteger("id");
        SubsidyProject project = this.subsidyProjectService.queryById(id);
        if (json.containsKey((Object)"state")) {
            project.setState(json.getInteger("state"));
        }
        if (json.containsKey((Object)"status")) {
            project.setStatus(json.getInteger("status"));
        }
        this.subsidyProjectService.update(project);
        return ResultVo.success();
    }

    @GetMapping(value={"/summary"})
    @ApiOperation(value="\u8865\u8d34\u6570\u636e\u6c47\u603b")
    public ResultVo querySubsidyDataSummary(@RequestParam(value="name", required=false, defaultValue="") String name, @RequestParam(value="years", required=false, defaultValue="") String years, @RequestParam(value="type", required=false, defaultValue="") String type, @RequestParam(value="page", defaultValue="1") Integer page, @RequestParam(value="pageSize", defaultValue="20") Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        List<Object> stringList = years.equals("") ? new ArrayList() : Arrays.asList(years.split(","));
        List<Object> typeList = type.equals("") ? new ArrayList() : Arrays.asList(type.split(","));
        return ResultVo.success((Object)this.subsidyProjectService.querySubsidyDataSummary(name, stringList, typeList, start, pageSize));
    }

    @GetMapping(value={"/summary/export"})
    @ApiOperation(value="\u8865\u8d34\u6570\u636e\u6c47\u603b\u5bfc\u51fa")
    public void exportSubsidyDataSummary(HttpServletResponse response, @RequestParam(value="name", required=false, defaultValue="") String name, @RequestParam(value="years", required=false, defaultValue="") String years, @RequestParam(value="type", required=false, defaultValue="") String type) {
        List<Object> yearList = years.equals("") ? new ArrayList() : Arrays.asList(years.split(","));
        List<Object> typeList = type.equals("") ? new ArrayList() : Arrays.asList(type.split(","));
        this.subsidyProjectService.exportSubsidyDataSummary(response, name, yearList, typeList);
    }

    @GetMapping(value={"/project/detail"})
    @ApiOperation(value="\u8865\u8d34\u6570\u636e\u8865\u8d34\u9879\u76ee\u8be6\u60c5")
    public ResultVo querySubsidyProjectById(@RequestParam(value="id") Integer id, @RequestParam(value="startTime", required=false, defaultValue="") String startTime, @RequestParam(value="endTime", required=false, defaultValue="") String endTime) {
        return ResultVo.success((Object)this.subsidyProjectService.querySubsidyProjectById(id, startTime, endTime));
    }

    @GetMapping(value={"/project/detail/export"})
    @ApiOperation(value="\u8865\u8d34\u6570\u636e\u8865\u8d34\u9879\u76ee\u8be6\u60c5\u5bfc\u51fa")
    public void exportSubsidyProjectById(@RequestParam(value="id") Integer id, @RequestParam(value="fileName") String fileName, HttpServletResponse response) {
        JSONObject jsonObject = this.subsidyProjectService.querySubsidyProjectById(id, null, null);
        SubsidyProject subsidyProject = (SubsidyProject)JSONObject.toJavaObject((JSON)jsonObject.getJSONObject("obj"), SubsidyProject.class);
        JSONArray auditPassSubsidyList = jsonObject.getJSONArray("auditPassSubsidyList");
        ArrayList subsidyFormInfoList = new ArrayList();
        auditPassSubsidyList.forEach(item -> subsidyFormInfoList.add((SubsidyFormInfo)item));
        Map map = SubsidyProject.generateExportMap((SubsidyProject)subsidyProject, subsidyFormInfoList);
        try {
            EasyPoiUtil.WordTemplateExport((Map)map, (String)"wordTemplate/projectDetail.docx", (String)fileName, (HttpServletResponse)response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @GetMapping(value={"/project/name"})
    @ApiOperation(value="\u6a21\u7cca\u641c\u7d22\u8865\u8d34\u9879\u76ee\u540d\u79f0")
    public ResultVo querySubsidyProjectName(@RequestParam(value="name", required=false, defaultValue="") String name, @RequestParam(value="page", defaultValue="1") Integer page, @RequestParam(value="pageSize", defaultValue="20") Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        return ResultVo.success((Object)this.subsidyProjectService.querySubsidyProjectName(name, start, pageSize));
    }

    @GetMapping(value={"/consult/detail"})
    @ApiOperation(value="\u8865\u8d34\u54a8\u8be2\u8be6\u60c5")
    public ResultVo querySubsidyConsultListById(@RequestParam(value="id") Integer id) {
        return ResultVo.success((Object)this.subsidyConsultService.querySubsidyConsultListById(id));
    }

    @GetMapping(value={"/consult"})
    @ApiOperation(value="\u8865\u8d34\u54a8\u8be2\u5217\u8868")
    public ResultVo querySubsidyConsultList() {
        return ResultVo.success((Object)this.subsidyConsultService.querySubsidyConsultList());
    }

    @GetMapping(value={"/consult/page"})
    @ApiOperation(value="\u8865\u8d34\u54a8\u8be2\u5206\u9875")
    public ResultVo querySubsidyConsultList(@RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        return ResultVo.success((Object)this.subsidyConsultService.querySubsidyConsultByPage(start, pageSize));
    }

    @PostMapping(value={"/consult/upsert"})
    @ApiOperation(value="\u8865\u8d34\u54a8\u8be2-\u65b0\u589e\u4fee\u6539")
    public ResultVo upsertSubsidyConsult(@RequestBody String body) {
        SubsidyConsult consult = (SubsidyConsult)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), SubsidyConsult.class);
        this.subsidyConsultService.upsertSubsidyConsult(consult);
        return ResultVo.success();
    }

    @PostMapping(value={"/consult/del"})
    @ApiOperation(value="\u8865\u8d34\u54a8\u8be2-\u5220\u9664")
    public ResultVo delSubsidyConsult(@RequestParam Integer id) {
        this.subsidyConsultService.delSubsidyConsult(id);
        return ResultVo.success();
    }

    @PostMapping(value={"/consult/disable"})
    @ApiOperation(value="\u8865\u8d34\u54a8\u8be2-\u505c\u7528\u3001\u542f\u7528")
    public ResultVo disableOrEnableSubsidyConsult(@RequestParam(value="id") Integer id, @RequestParam(value="status") Integer status) {
        this.subsidyConsultService.disableOrEnableSubsidyConsult(id, status);
        return ResultVo.success();
    }
}

