/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller.subsidy;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.SubsidyFormInfo;
import com.farm.bean.SubsidyFormProtect;
import com.farm.bean.SubsidyImportDto;
import com.farm.service.SubsidyFormInfoService;
import com.farm.service.SubsidyFormProtectService;
import com.farm.util.EasyPoiUtil;
import com.farm.util.ExcelExpertListener;
import com.farm.util.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/subsidy"})
@Api(tags={"\u60e0\u519c\u8865\u8d34\u7cfb\u7edf-\u8868\u5355\u76f8\u5173"})
public class SubsidyFormInfoController {
    @Resource
    private SubsidyFormInfoService subsidyFormInfoService;
    @Autowired
    private SubsidyFormProtectService formProtectService;

    @GetMapping(value={"/detail"})
    @ApiOperation(value="\u8868\u5355\u8865\u8d34\u7533\u8bf7\u8be6\u60c5")
    public ResultVo selectOne(Integer id) {
        SubsidyFormInfo dto = this.subsidyFormInfoService.queryById(id);
        return ResultVo.success((Object)dto);
    }

    @GetMapping(value={"/detail-field"})
    @ApiOperation(value="\u60e0\u519c\u8865\u8d34\u7530\u5757\u5217\u8868")
    public ResultVo querySubsidyLandlord(@RequestParam Integer id, @RequestParam(name="page", required=false, defaultValue="1") Integer page, @RequestParam(name="pageSize", required=false, defaultValue="10") Integer pageSize) {
        Integer offset = (page - 1) * pageSize;
        JSONObject json = this.subsidyFormInfoService.queryFieldListByFormId(id, offset, pageSize);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/detail/export"})
    @ApiOperation(value="\u8865\u8d34\u7533\u8bf7\u8be6\u60c5\u8be6\u60c5")
    public void exportDetailById(@RequestParam(value="id") Integer id, @RequestParam(value="fileName") String fileName, @RequestParam(value="address", required=false, defaultValue=" ") String address, @RequestParam(value="type") Integer type, HttpServletResponse response) {
        SubsidyFormInfo dto = this.subsidyFormInfoService.queryById(id);
        Map map = new HashMap();
        String templatePath = "";
        switch (type) {
            case 0: {
                map = SubsidyFormInfo.generateScalePlantExportMap((SubsidyFormInfo)dto);
                templatePath = "scalePlantDetail.docx";
                break;
            }
            case 1: {
                SubsidyFormInfo subsidyFormInfo = this.formProtectService.queryProtectDetail(id, null);
                map = SubsidyFormInfo.generateProtectExportMap((SubsidyFormInfo)subsidyFormInfo, (String)address);
                templatePath = "protectDetail.docx";
                break;
            }
            case 2: {
                map = SubsidyFormInfo.generateProductExportMap((SubsidyFormInfo)dto);
                templatePath = "productDetail.docx";
                break;
            }
            case 3: {
                map = SubsidyFormInfo.generateCompanyProductExportMap((SubsidyFormInfo)dto);
                templatePath = "companyProductDetail.docx";
                break;
            }
            case 4: {
                map = SubsidyFormInfo.generateMachineExportMap((SubsidyFormInfo)dto);
                templatePath = "machineDetail.docx";
                break;
            }
            case 5: {
                map = SubsidyFormInfo.generateYearExportMap((SubsidyFormInfo)dto);
                templatePath = "yearReport.docx";
                break;
            }
            case 6: {
                map = SubsidyFormInfo.generateFertilizerExportMap((SubsidyFormInfo)dto);
                templatePath = "fertilizerReport.docx";
            }
        }
        try {
            EasyPoiUtil.WordTemplateExport(map, (String)("wordTemplate/" + templatePath), (String)fileName, (HttpServletResponse)response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @PostMapping(value={"/del"})
    @ApiOperation(value="\u5220\u9664\u8868\u5355")
    public Object delete(@RequestParam(value="idList") List<Integer> idList) {
        this.subsidyFormInfoService.removeByIds(idList);
        return ResultVo.success();
    }

    @PostMapping(value={"/upsert"})
    @ApiOperation(value="\u65b0\u589e\u8865\u8d34\u8868\u5355")
    public Object upsertFieldForm(@RequestBody String body) {
        JSONObject json = JSONObject.parseObject((String)body);
        Integer flag = 0;
        flag = json.containsKey((Object)"id") ? this.subsidyFormInfoService.updateForm(json) : this.subsidyFormInfoService.insertForm(json);
        JSONObject resJson = new JSONObject();
        resJson.put("flag", (Object)flag);
        return ResultVo.success((Object)resJson);
    }

    @GetMapping(value={"/user/list"})
    @ApiOperation(value="\u6211\u7684\u8fdb\u5ea6\u5217\u8868")
    public ResultVo queryUserFormList(@RequestParam(value="userId") String userId, @RequestParam(value="phone", required=false) String phone, @RequestParam(defaultValue="", required=false, value="status") Integer status, @RequestParam(defaultValue="1", required=false, value="page") Integer page, @RequestParam(defaultValue="10", required=false, value="pageSize") Integer pageSize) {
        Integer offset = (page - 1) * pageSize;
        JSONObject json = this.subsidyFormInfoService.queryUserFormList(userId, phone, status, offset, pageSize);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/public/list"})
    @ApiOperation(value="\u516c\u793a\u5217\u8868")
    public ResultVo queryPublicList(@RequestParam(defaultValue="", required=false, value="search") String search, @RequestParam(defaultValue="", required=false, value="projectIds") String projectIds, @RequestParam(defaultValue="", required=false, value="startDate") String startDate, @RequestParam(defaultValue="", required=false, value="endDate") String endDate, @RequestParam(defaultValue="", required=false, value="status") Integer status, @RequestParam(defaultValue="1", required=false, value="page") Integer page, @RequestParam(defaultValue="10", required=false, value="pageSize") Integer pageSize) {
        Integer offset = (page - 1) * pageSize;
        List<Object> projectIdList = new ArrayList();
        if (StringUtils.isNotBlank((String)projectIds)) {
            projectIdList = Arrays.asList(projectIds.split(","));
        }
        JSONObject json = this.subsidyFormInfoService.queryPublicList(status, offset, pageSize, search, projectIdList, startDate, endDate);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/auditlist"})
    @ApiOperation(value="\u5ba1\u6279\u5217\u8868")
    public ResultVo queryAuditList(@RequestParam(defaultValue="", required=false, value="status") Integer status, @RequestParam(defaultValue="", required=false, value="search") String search, @RequestParam(defaultValue="", required=false, value="type") Integer type, @RequestParam(defaultValue="", required=false, value="roleId") String roleId, @RequestParam(defaultValue="", required=false, value="regionCodeStr") String regionCodeStr, @RequestParam(defaultValue="", required=false, value="projectIdStr") String projectIdStr, @RequestParam(defaultValue="", required=false, value="userMnRegCode") String userMnRegCode, @RequestParam(defaultValue="1", required=false, value="page") Integer page, @RequestParam(defaultValue="10", required=false, value="pageSize") Integer pageSize) {
        Integer offset = (page - 1) * pageSize;
        List<Object> regionCodeList = regionCodeStr.equals("") ? new ArrayList() : Arrays.asList(regionCodeStr.split(","));
        List<Object> projectIdList = projectIdStr.equals("") ? new ArrayList() : Arrays.asList(projectIdStr.split(","));
        JSONObject json = this.subsidyFormInfoService.queryAuditList(status, type, offset, pageSize, roleId, search, regionCodeList, projectIdList, userMnRegCode);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/auditlist/export"})
    @ApiOperation(value="\u8865\u8d34\u5ba1\u6279\u5bfc\u51fa")
    public void exportSubsidyAuditList(HttpServletResponse response, @RequestParam(defaultValue="", required=false, value="status") Integer status, @RequestParam(defaultValue="", required=false, value="search") String search, @RequestParam(defaultValue="", required=false, value="type") Integer type, @RequestParam(defaultValue="", required=false, value="roleId") String roleId, @RequestParam(defaultValue="", required=false, value="regionCodeStr") String regionCodeStr, @RequestParam(defaultValue="", required=false, value="userMnRegCode") String userMnRegCode, @RequestParam(defaultValue="", required=false, value="projectIdStr") String projectIdStr) {
        List<Object> regionCodeList = regionCodeStr.equals("") ? new ArrayList() : Arrays.asList(regionCodeStr.split(","));
        List<Object> projectIdList = projectIdStr.equals("") ? new ArrayList() : Arrays.asList(projectIdStr.split(","));
        this.subsidyFormInfoService.exportSubsidyAuditList(response, status, search, type, roleId, regionCodeList, projectIdList, userMnRegCode);
    }

    @GetMapping(value={"/auditCompany/list"})
    @ApiOperation(value="\u519c\u8d44\u4f01\u4e1a\u5ba1\u6279\u5217\u8868")
    public ResultVo queryCompanyAuditList(@RequestParam(defaultValue="", required=false, value="search") String search, @RequestParam(defaultValue="", required=false, value="status") Integer status, @RequestParam(defaultValue="", required=false, value="regionCodeStr") String regionCodeStr, @RequestParam(defaultValue="", required=false, value="projectIdStr") String projectIdStr, @RequestParam(defaultValue="1", required=false, value="page") Integer page, @RequestParam(defaultValue="10", required=false, value="pageSize") Integer pageSize) {
        Integer offset = (page - 1) * pageSize;
        List<Object> regionCodeList = regionCodeStr.equals("") ? new ArrayList() : Arrays.asList(regionCodeStr.split(","));
        List<Object> projectIdList = projectIdStr.equals("") ? new ArrayList() : Arrays.asList(projectIdStr.split(","));
        JSONObject json = this.subsidyFormInfoService.queryCompanyAuditList(status, offset, pageSize, search, regionCodeList, projectIdList);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/auditCompany/list/export"})
    public void exportCompanyAuditList(HttpServletResponse response, @RequestParam(defaultValue="", required=false, value="search") String search, @RequestParam(defaultValue="", required=false, value="status") Integer status, @RequestParam(defaultValue="", required=false, value="regionCodeStr") String regionCodeStr, @RequestParam(defaultValue="", required=false, value="projectIdStr") String projectIdStr) {
        List<Object> regionCodeList = regionCodeStr.equals("") ? new ArrayList() : Arrays.asList(regionCodeStr.split(","));
        List<Object> projectIdList = projectIdStr.equals("") ? new ArrayList() : Arrays.asList(projectIdStr.split(","));
        this.subsidyFormInfoService.exportCompanyAuditList(response, search, status, regionCodeList, projectIdList);
    }

    @GetMapping(value={"/auditReportYear/list"})
    @ApiOperation(value="\u5e74\u5ea6\u62a5\u5907\u5ba1\u6279\u5217\u8868")
    public ResultVo queryReportYearAuditList(@RequestParam(defaultValue="", required=false, value="search") String search, @RequestParam(defaultValue="", required=false, value="status") Integer status, @RequestParam(defaultValue="", required=false, value="regionCodeStr") String regionCodeStr, @RequestParam(defaultValue="", required=false, value="projectIdStr") String projectIdStr, @RequestParam(defaultValue="1", required=false, value="page") Integer page, @RequestParam(defaultValue="10", required=false, value="pageSize") Integer pageSize) {
        Integer offset = (page - 1) * pageSize;
        List<Object> regionCodeList = regionCodeStr.equals("") ? new ArrayList() : Arrays.asList(regionCodeStr.split(","));
        List<Object> projectIdList = projectIdStr.equals("") ? new ArrayList() : Arrays.asList(projectIdStr.split(","));
        JSONObject json = this.subsidyFormInfoService.queryReportYearAuditList(status, offset, pageSize, search, regionCodeList, projectIdList);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/auditReportYear/export"})
    @ApiOperation(value="\u5e74\u5ea6\u62a5\u5907\u5ba1\u6279\u5bfc\u51fa")
    public void exportReportYearAuditList(HttpServletResponse response, @RequestParam(defaultValue="", required=false, value="search") String search, @RequestParam(defaultValue="", required=false, value="status") Integer status, @RequestParam(defaultValue="", required=false, value="regionCodeStr") String regionCodeStr, @RequestParam(defaultValue="", required=false, value="projectIdStr") String projectIdStr) {
        List<Object> regionCodeList = regionCodeStr.equals("") ? new ArrayList() : Arrays.asList(regionCodeStr.split(","));
        List<Object> projectIdList = projectIdStr.equals("") ? new ArrayList() : Arrays.asList(projectIdStr.split(","));
        this.subsidyFormInfoService.exportReportYearAuditList(response, search, status, regionCodeList, projectIdList);
    }

    @GetMapping(value={"/auditReportFertilizer/list"})
    @ApiOperation(value="\u80a5\u6599\u62a5\u5907\u5ba1\u6279\u5217\u8868")
    public ResultVo queryReportFertilizerAuditList(@RequestParam(defaultValue="", required=false, value="search") String search, @RequestParam(defaultValue="", required=false, value="status") Integer status, @RequestParam(defaultValue="", required=false, value="regionCodeStr") String regionCodeStr, @RequestParam(defaultValue="", required=false, value="projectIdStr") String projectIdStr, @RequestParam(defaultValue="1", required=false, value="page") Integer page, @RequestParam(defaultValue="10", required=false, value="pageSize") Integer pageSize) {
        Integer offset = (page - 1) * pageSize;
        List<Object> regionCodeList = regionCodeStr.equals("") ? new ArrayList() : Arrays.asList(regionCodeStr.split(","));
        List<Object> projectIdList = projectIdStr.equals("") ? new ArrayList() : Arrays.asList(projectIdStr.split(","));
        JSONObject json = this.subsidyFormInfoService.queryReportFertilizerAuditList(status, offset, pageSize, search, regionCodeList, projectIdList);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/auditReportFertilizer/export"})
    @ApiOperation(value="\u80a5\u6599\u62a5\u5907\u5ba1\u6279\u5bfc\u51fa")
    public void exportFertilizerAuditList(HttpServletResponse response, @RequestParam(defaultValue="", required=false, value="search") String search, @RequestParam(defaultValue="", required=false, value="status") Integer status, @RequestParam(defaultValue="", required=false, value="regionCodeStr") String regionCodeStr, @RequestParam(defaultValue="", required=false, value="projectIdStr") String projectIdStr) {
        List<Object> regionCodeList = regionCodeStr.equals("") ? new ArrayList() : Arrays.asList(regionCodeStr.split(","));
        List<Object> projectIdList = projectIdStr.equals("") ? new ArrayList() : Arrays.asList(projectIdStr.split(","));
        this.subsidyFormInfoService.exportFertilizerAuditList(response, search, status, regionCodeList, projectIdList);
    }

    @PostMapping(value={"/audit"})
    @ApiOperation(value="\u5ba1\u6279\u7533\u62a5")
    public Object auditForm(@RequestParam(value="id") Integer id, @RequestParam(value="type") Integer type, @RequestParam(value="status") Integer status, @RequestParam(value="userId") String userId, @RequestParam(value="area", required=false) Double area, @RequestParam(value="planAmount", required=false) Double planAmount, @RequestParam(value="cancel", required=false, defaultValue="false") Boolean cancel, @RequestParam(value="delFieldIds", required=false, defaultValue="") String delFieldIds, @RequestParam(value="segStatus", required=false) Integer segStatus, @RequestParam(value="auditComment", required=false, defaultValue="") String auditComment) {
        if (type == 0 || type == 1) {
            if (cancel.booleanValue()) {
                this.subsidyFormInfoService.cancelPublicFormField(id, auditComment, userId);
            } else {
                this.subsidyFormInfoService.auditFormField(id, status, segStatus, auditComment, userId, area, planAmount);
            }
            if (type == 0 && StringUtils.isNotBlank((String)delFieldIds)) {
                this.subsidyFormInfoService.deleteSubsidyFormFieldById(id, delFieldIds);
            }
        } else if (type == 2 || type == 3 || type == 4 || type == 5 || type == 6) {
            this.subsidyFormInfoService.auditForm(id, status, auditComment, userId);
        }
        return ResultVo.success();
    }

    @PostMapping(value={"/audit/batch"})
    public ResultVo auditFormBatch(@RequestBody String body) {
        JSONObject jsonObject = JSONObject.parseObject((String)body);
        Integer type = jsonObject.getInteger("type");
        Integer status = jsonObject.getInteger("status");
        String userId = jsonObject.getString("userId");
        String auditComment = jsonObject.getString("auditComment");
        JSONArray jsonArray = jsonObject.getJSONArray("subsidyFormInfoList");
        jsonArray.forEach(item -> {
            SubsidyFormInfo subsidyFormInfo = (SubsidyFormInfo)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)item.toString()), SubsidyFormInfo.class);
            Integer id = subsidyFormInfo.getId();
            Double area = subsidyFormInfo.getCirculateArea();
            Double planAmount = subsidyFormInfo.getPlanAmount();
            this.auditForm(id, type, status, userId, area, planAmount, Boolean.valueOf(false), "", subsidyFormInfo.getSegStatus(), auditComment);
        });
        return ResultVo.success();
    }

    @PostMapping(value={"/insert/protect"})
    @ApiOperation(value="\u7533\u62a5\u5730\u529b\u4fdd\u62a4\u8865\u8d34")
    public ResultVo insertFormProtect(@RequestBody String body) {
        JSONObject json = JSONObject.parseObject((String)body);
        SubsidyFormProtect subsidyFormProtect = (SubsidyFormProtect)JSONObject.toJavaObject((JSON)json, SubsidyFormProtect.class);
        this.subsidyFormInfoService.insertFormProtect(subsidyFormProtect, json);
        return ResultVo.success();
    }

    @GetMapping(value={"/protect/detail"})
    @ApiOperation(value="\u5730\u529b\u8865\u8d34\u7533\u8bf7\u8be6\u60c5")
    public ResultVo queryProtectDetail(@RequestParam(value="id") Integer id, @RequestParam(value="userId", required=false) String userId) {
        return ResultVo.success((Object)this.formProtectService.queryProtectDetail(id, userId));
    }

    @GetMapping(value={"/user-list"})
    @ApiOperation(value="\u5730\u529b\u4fdd\u62a4\u519c\u6237\u5217\u8868")
    public ResultVo queryProtectUserList(@RequestParam(value="regionCode") String regionCode) {
        return ResultVo.success((Object)this.subsidyFormInfoService.queryProtectUserList(regionCode));
    }

    @GetMapping(value={"/protect/page"})
    @ApiOperation(value="\u5730\u529b\u4fdd\u62a4\u8865\u8d34\u5206\u9875")
    public ResultVo queryFormProtectPage(@RequestParam(value="status", required=false, defaultValue="") String status, @RequestParam(value="regionCodes", required=false, defaultValue="") String regionCodes, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize) {
        List<Object> statusList = status.equals("") ? new ArrayList() : Arrays.asList(status.split(","));
        List<Object> regionCodeList = regionCodes.equals("") ? new ArrayList() : Arrays.asList(regionCodes.split(","));
        Integer start = (page - 1) * pageSize;
        return ResultVo.success((Object)this.subsidyFormInfoService.queryFormProtectPage(statusList, regionCodeList, start, pageSize));
    }

    @PostMapping(value={"/import"})
    @ApiOperation(value="\u8865\u8d34\u516c\u793a\u5bfc\u5165")
    public ResultVo importSubsidyForm(@RequestParam(value="file") MultipartFile file, @RequestParam(value="type") Integer type) {
        ExcelExpertListener excelListener = new ExcelExpertListener();
        try {
            InputStream inputStream = file.getInputStream();
            EasyExcel.read((InputStream)inputStream, SubsidyImportDto.class, (ReadListener)excelListener).sheet().doRead();
            this.subsidyFormInfoService.importSubsidyForm(excelListener.getList(), type);
            return ResultVo.success();
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResultVo.error();
        }
    }

    @PostMapping(value={"/del-import"})
    public ResultVo deleteSubsidyFormInfoById(@RequestParam(value="id") Integer id) {
        this.subsidyFormInfoService.deleteSubsidyFormInfoById(id);
        return ResultVo.success();
    }

    @GetMapping(value={"/field-map"})
    public ResultVo querySubsidyFieldMap(@RequestParam(value="regionCode", required=false, defaultValue="") String regionCode, @RequestParam(value="username", required=false, defaultValue="") String username, @RequestParam(value="projectIdStr", required=false, defaultValue="") String projectIdStr, @RequestParam(value="type") Integer type) {
        return ResultVo.success((Object)this.subsidyFormInfoService.querySubsidyFieldMap(regionCode, username, projectIdStr, type));
    }

    @GetMapping(value={"/sync"})
    public ResultVo syncSubsidyFormInfo() {
        this.subsidyFormInfoService.syncSubsidyFormInfo();
        return ResultVo.success();
    }

    @GetMapping(value={"/auditCount"})
    @ApiOperation(value="\u62a5\u5907\u5ba1\u6279\u5f85\u5ba1\u6838\u6570")
    public ResultVo queryAuditCount(@RequestParam(value="status", required=false) Integer status, @RequestParam(defaultValue="", required=false, value="roleId") String roleId) {
        JSONObject jsonObject = this.subsidyFormInfoService.queryAuditCount(status, roleId);
        return ResultVo.success((Object)jsonObject);
    }
}

