/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller.subsidy;

import com.alibaba.fastjson.JSONObject;
import com.farm.bean.SubsidyFertilizerParam;
import com.farm.bean.SubsidyFormInfo;
import com.farm.bean.SubsidyReportFertilizer;
import com.farm.mapper.SubsidyFormInfoMapper;
import com.farm.service.SubsidyFertilizerParamService;
import com.farm.service.SubsidyFormInfoService;
import com.farm.service.SubsidyReportFertilizerService;
import com.farm.service.SubsidyReportYearService;
import com.farm.util.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/subsidy-report"})
@Api(tags={"\u60e0\u519c\u8865\u8d34\u7cfb\u7edf-\u4f01\u4e1a\u62a5\u5907\u76f8\u5173"})
public class SubsidyReportController {
    @Autowired
    private SubsidyReportYearService subsidyReportYearService;
    @Autowired
    private SubsidyReportFertilizerService subsidyReportFertilizerService;
    @Autowired
    private SubsidyFertilizerParamService subsidyFertilizerParamService;
    @Autowired
    private SubsidyFormInfoService subsidyFormInfoService;
    @Resource
    private SubsidyFormInfoMapper subsidyFormInfoMapper;

    @GetMapping(value={"/page"})
    @ApiOperation(value="\u6761\u4ef6\u5206\u9875\u67e5\u8be2\u519c\u8d44\u4f01\u4e1a\u62a5\u5907")
    public ResultVo querySubsidyReportYearByCondAndPage(@RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize, @RequestParam(value="companyName", required=false, defaultValue="") String companyName, @RequestParam(value="userId", required=false) String userId, @RequestParam(value="status", required=false) Integer status, @RequestParam(value="type") Integer type) {
        Integer start = (page - 1) * pageSize;
        JSONObject jsonObject = type == 5 ? this.subsidyReportYearService.querySubsidyReportYearByCondAndPage(userId, status, companyName, start, pageSize) : this.subsidyReportFertilizerService.querySubsidyReportFertilizerByCondAndPage(userId, status, companyName, start, pageSize);
        return ResultVo.success((Object)jsonObject);
    }

    @GetMapping(value={"/detail"})
    @ApiOperation(value="\u67e5\u8be2\u6307\u5b9a\u519c\u8d44\u4f01\u4e1a\u62a5\u5907")
    public ResultVo querySubsidyReportYearById(@RequestParam(value="id") Integer id, @RequestParam(value="type") Integer type) {
        Object object = type == 5 ? this.subsidyReportYearService.querySubsidyReportYearById(id) : this.subsidyReportFertilizerService.querySubsidyReportFertilizerById(id);
        return ResultVo.success((Object)object);
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="\u5220\u9664\u6307\u5b9a\u62a5\u5907")
    public ResultVo deleteSubsidyReportYearById(@RequestParam(value="id") Integer id, @RequestParam(value="type") Integer type) {
        if (type == 1) {
            this.subsidyReportYearService.deleteSubsidyReportYearById(id);
        } else {
            this.subsidyReportFertilizerService.deleteSubsidyReportFertilizerById(id);
        }
        return ResultVo.success();
    }

    @PostMapping(value={"/year"})
    @ApiOperation(value="\u519c\u8d44\u4f01\u4e1a\u5e74\u5ea6\u62a5\u5907\u7533\u8bf7")
    public ResultVo insertSubsidyReportYear(@RequestParam(value="userId") String userId, @RequestParam(value="count") Integer count, @RequestParam(value="year") Integer year) {
        this.subsidyReportYearService.insertSubsidyReportYear(userId, count, year);
        return ResultVo.success();
    }

    @PostMapping(value={"/year/update"})
    @ApiOperation(value="\u4fee\u6539\u5e74\u5ea6\u62a5\u5907")
    public ResultVo updateSubsidyReportYear(@RequestParam(value="id") Integer id, @RequestParam(value="count", required=false) Integer count, @RequestParam(value="year", required=false) Integer year) {
        this.subsidyReportYearService.updateSubsidyReportYear(id, count, year);
        return ResultVo.success();
    }

    @PostMapping(value={"/year/audit"})
    @ApiOperation(value="\u5ba1\u6279\u5e74\u5ea6\u62a5\u5907")
    public ResultVo auditSubsidyReportYear(@RequestParam(value="id") Integer id, @RequestParam(value="auditComment", required=false, defaultValue="") String auditComment, @RequestParam(value="status") Integer status) {
        this.subsidyReportYearService.auditSubsidyReportYear(id, auditComment, status);
        return ResultVo.success();
    }

    @PostMapping(value={"/fertilizer"})
    @ApiOperation(value="\u6dfb\u52a0\u80a5\u6599\u62a5\u5907")
    public ResultVo insertSubsidyReportFertilizer(@RequestParam(value="userId") String userId, @RequestParam(value="agentName", required=false, defaultValue="") String agentName, @RequestParam(value="agentPhone", required=false, defaultValue="") String agentPhone, @RequestParam(value="fertilizerCertificateNumber") String fertilizerCertificateNumber, @RequestParam(value="type") Integer type, @RequestParam(value="fertilizerParam") String fertilizerParam, @RequestParam(value="fertilizerScheme", required=false, defaultValue="") String fertilizerScheme, @RequestParam(value="highestPrice") String highestPrice) {
        SubsidyReportFertilizer subsidyReportFertilizer = new SubsidyReportFertilizer(userId, agentName, agentPhone, fertilizerCertificateNumber, type, fertilizerParam, fertilizerScheme, Double.valueOf(highestPrice));
        this.subsidyReportFertilizerService.insertSubsidyReportFertilizer(subsidyReportFertilizer);
        this.subsidyFormInfoService.insert(new SubsidyFormInfo(userId, Integer.valueOf(0), Integer.valueOf(6), subsidyReportFertilizer.getId()));
        return ResultVo.success();
    }

    @PostMapping(value={"/fertilizer/update"})
    @ApiOperation(value="\u4fee\u6539\u80a5\u6599\u62a5\u5907")
    public ResultVo updateSubsidyReportFertilizer(@RequestParam(value="id") Integer id, @RequestParam(value="agentName", required=false, defaultValue="") String agentName, @RequestParam(value="agentPhone", required=false, defaultValue="") String agentPhone, @RequestParam(value="fertilizerCertificateNumber") String fertilizerCertificateNumber, @RequestParam(value="type") Integer type, @RequestParam(value="fertilizerParam") String fertilizerParam, @RequestParam(value="fertilizerScheme", required=false, defaultValue="") String fertilizerScheme, @RequestParam(value="highestPrice") String highestPrice) {
        SubsidyFormInfo subsidyFormInfo = this.subsidyFormInfoService.queryById(id);
        this.subsidyFormInfoService.updateFormStatus(id, Integer.valueOf(0));
        SubsidyReportFertilizer subsidyReportFertilizer = new SubsidyReportFertilizer(subsidyFormInfo.getRelateId(), agentName, agentPhone, fertilizerCertificateNumber, type, fertilizerParam, fertilizerScheme, Double.valueOf(highestPrice));
        this.subsidyReportFertilizerService.updateSubsidyReportFertilizer(subsidyReportFertilizer);
        this.subsidyFormInfoMapper.insertAuditLog(id, Integer.valueOf(7), Integer.valueOf(0), null, null);
        return ResultVo.success();
    }

    @PostMapping(value={"/fertilizer/audit"})
    @ApiOperation(value="\u5ba1\u6279\u80a5\u6599\u62a5\u5907")
    public ResultVo auditSubsidyReportFertilizer(@RequestParam(value="id") Integer id, @RequestParam(value="auditComment", required=false, defaultValue="") String auditComment, @RequestParam(value="status") Integer status) {
        this.subsidyReportFertilizerService.auditSubsidyReportFertilizer(id, auditComment, status);
        return ResultVo.success();
    }

    @GetMapping(value={"/param"})
    @ApiOperation(value="\u83b7\u53d6\u80a5\u6599\u8d28\u91cf\u53c2\u6570\u5217\u8868")
    public ResultVo queryFertilizerParamList() {
        return ResultVo.success((Object)this.subsidyFertilizerParamService.queryFertilizerParamList());
    }

    @GetMapping(value={"/param/page"})
    @ApiOperation(value="\u8d28\u91cf\u53c2\u6570\u5206\u9875")
    public ResultVo queryFertilizerParamPage(@RequestParam(value="cropName", required=false, defaultValue="") String cropName, @RequestParam(value="status", required=false, defaultValue="") Integer status, @RequestParam(value="year", required=false, defaultValue="") String year, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        return ResultVo.success((Object)this.subsidyFertilizerParamService.queryFertilizerParamPage(cropName, status, year, start, pageSize));
    }

    @PostMapping(value={"/param/upsert"})
    @ApiOperation(value="\u6dfb\u52a0\u80a5\u6599\u8d28\u91cf\u53c2\u6570")
    public ResultVo upsertFertilizerParam(@RequestParam(value="id", required=false) Integer id, @RequestParam(value="cropName") String cropName, @RequestParam(value="secondName", required=false, defaultValue="") String secondName, @RequestParam(value="years") String years, @RequestParam(value="mainFormula") String mainFormula, @RequestParam(value="regionCode") String regionCode) {
        if (id != null) {
            this.subsidyFertilizerParamService.deleteFertilizerParam(id, null);
        }
        ArrayList subsidyFertilizerParamList = new ArrayList();
        Arrays.asList(mainFormula.split(",")).forEach(str -> subsidyFertilizerParamList.add(new SubsidyFertilizerParam(cropName, secondName, years, str, regionCode)));
        this.subsidyFertilizerParamService.insertBatch(subsidyFertilizerParamList);
        return ResultVo.success();
    }

    @PostMapping(value={"/param/del"})
    @ApiOperation(value="\u505c\u7528/\u5220\u9664")
    public ResultVo deleteFertilizerParam(@RequestParam(value="id") Integer id, @RequestParam(value="status", required=false) Integer status) {
        this.subsidyFertilizerParamService.deleteFertilizerParam(id, status);
        return ResultVo.success();
    }

    @GetMapping(value={"/param/detail"})
    @ApiOperation(value="\u8d28\u91cf\u53c2\u6570\u8be6\u60c5")
    public ResultVo queryFertilizerParamDetail(@RequestParam(value="id") Integer id) {
        return ResultVo.success((Object)this.subsidyFertilizerParamService.queryFertilizerParamDetail(id));
    }
}

