/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller.transfer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.TransferLandInfo;
import com.farm.bean.TransferLandTrade;
import com.farm.service.TransferLandInfoService;
import com.farm.util.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/transferLand"})
@Api(tags={"\u571f\u5730\u6d41\u8f6c\u4fe1\u606f"})
public class TransferLandInfoController {
    @Resource
    private TransferLandInfoService transferLandInfoService;

    @PostMapping(value={"/upsert"})
    @ApiOperation(value="\u65b0\u589e\u571f\u5730\u6d41\u8f6c")
    public Object upsertTransfeiLand(@RequestBody JSONObject json) {
        TransferLandInfo dto = (TransferLandInfo)JSONObject.toJavaObject((JSON)json, TransferLandInfo.class);
        JSONArray fieldIdArray = new JSONArray();
        if (json.containsKey((Object)"fieldList")) {
            fieldIdArray = json.getJSONArray("fieldList");
        }
        if (dto.getId() == null) {
            this.transferLandInfoService.insert(dto, fieldIdArray);
        } else {
            this.transferLandInfoService.update(dto, fieldIdArray);
        }
        return ResultVo.success((Object)dto);
    }

    @PostMapping(value={"/deal-pc"})
    @ApiOperation(value="\u540e\u53f0\u7ba1\u7406\u6210\u4ea4\u586b\u62a5")
    public Object dealPcTransfeiLand(@RequestBody JSONObject json) {
        TransferLandTrade dto = (TransferLandTrade)JSONObject.toJavaObject((JSON)json, TransferLandTrade.class);
        TransferLandInfo landInfo = new TransferLandInfo();
        landInfo.setFieldType(json.getInteger("fieldType"));
        landInfo.setTransferType(json.getInteger("transferType"));
        landInfo.setUseYear(json.getInteger("useYear"));
        Double transferArea = json.getDouble("transferArea");
        landInfo.setTransferArea(transferArea);
        landInfo.setLat(Double.valueOf(29.1316104));
        landInfo.setLng(Double.valueOf(119.1258178));
        landInfo.setAddress("\u6d59\u6c5f\u7701\u9f99\u6e38\u53bf");
        landInfo.setRegionCode("330825");
        landInfo.setStatus(Integer.valueOf(1));
        landInfo.setUserId(json.getString("userId"));
        landInfo.setPrice(Double.valueOf(dto.getDealMoney() / transferArea));
        landInfo.setType(Integer.valueOf(0));
        landInfo.setSyncTown(Boolean.valueOf(true));
        landInfo.setTitle("");
        landInfo = this.transferLandInfoService.dealPcTransfeiLand(landInfo);
        dto.setTransferLandId(landInfo.getId());
        this.transferLandInfoService.insertLandTrade(dto);
        return ResultVo.success();
    }

    @PostMapping(value={"/deal"})
    @ApiOperation(value="\u6210\u4ea4\u586b\u62a5")
    public Object dealTransfeiLand(@RequestBody JSONObject json) {
        Integer id = json.getInteger("id");
        TransferLandTrade dto = (TransferLandTrade)JSONObject.toJavaObject((JSON)json, TransferLandTrade.class);
        dto.setTransferLandId(id);
        TransferLandInfo landInfo = new TransferLandInfo();
        landInfo.setId(id);
        landInfo.setFieldType(json.getInteger("fieldType"));
        landInfo.setTransferType(json.getInteger("transferType"));
        landInfo.setUseYear(json.getInteger("useYear"));
        landInfo.setTransferArea(json.getDouble("transferArea"));
        landInfo.setLat(json.getDouble("lat"));
        landInfo.setLng(json.getDouble("lng"));
        landInfo.setAddress(json.getString("address"));
        landInfo.setStatus(Integer.valueOf(1));
        this.transferLandInfoService.update(landInfo, null);
        this.transferLandInfoService.insertLandTrade(dto);
        return ResultVo.success();
    }

    @PostMapping(value={"/down-up"})
    @ApiOperation(value="\u4e0a\u4e0b\u67b6")
    public Object downTransfeiLand(@RequestBody JSONObject json) {
        Integer id = json.getInteger("id");
        TransferLandInfo landInfo = new TransferLandInfo();
        landInfo.setId(id);
        landInfo.setStatus(json.getInteger("status"));
        this.transferLandInfoService.downTransfeiLand(landInfo);
        return ResultVo.success();
    }

    @PostMapping(value={"/del"})
    @ApiOperation(value="\u5220\u9664")
    public Object delete(@RequestBody JSONObject json) {
        LinkedList<Integer> idList = new LinkedList<Integer>();
        idList.add(json.getInteger("id"));
        this.transferLandInfoService.removeByIds(idList);
        return ResultVo.success();
    }

    @GetMapping(value={"/detail"})
    @ApiOperation(value="\u571f\u5730\u6d41\u8f6c\u9700\u6c42\u8be6\u60c5")
    public Object selectOne(Integer id) {
        TransferLandInfo dto = this.transferLandInfoService.queryById(id);
        return ResultVo.success((Object)dto);
    }

    @PostMapping(value={"/user-list"})
    @ApiOperation(value="\u7528\u6237\u53d1\u5e03\u5217\u8868")
    public Object queryUserList(@RequestParam String userId, @RequestParam(name="page", defaultValue="1", required=false) Integer page, @RequestParam(name="pageSize", defaultValue="100", required=false) Integer pageSize) {
        Integer offset = (page - 1) * pageSize;
        JSONObject json = this.transferLandInfoService.queryUserList(userId, offset, pageSize);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/all-list0"})
    @ApiOperation(value="\u4fe1\u606f\u5217\u8868-\u4f9b")
    public Object queryTransferList0(@RequestParam(name="regionCodes", defaultValue="", required=false) String regionCodes, @RequestParam(name="fieldTypes", defaultValue="", required=false) String fieldTypes, @RequestParam(name="transferTypes", defaultValue="", required=false) String transferTypes, @RequestParam(name="areaTypes", defaultValue="", required=false) String areaTypes, @RequestParam(required=false, value="yearTypes", defaultValue="") String yearTypes, @RequestParam(name="lowPrice", defaultValue="", required=false) String lowPrice, @RequestParam(name="highPrice", defaultValue="", required=false) String highPrice, @RequestParam(name="search", defaultValue="", required=false) String search, @RequestParam(name="platform", required=false) Integer platform, @RequestParam(name="statusType", defaultValue="1", required=false) Integer statusType, @RequestParam(name="page", defaultValue="1", required=false) Integer page, @RequestParam(name="pageSize", defaultValue="100", required=false) Integer pageSize) {
        List<Object> regionList = new ArrayList();
        if (StringUtils.isNotBlank((String)regionCodes)) {
            regionList = Arrays.asList(regionCodes.split(","));
        }
        List<Object> fieldTypeList = new ArrayList();
        if (StringUtils.isNotBlank((String)fieldTypes)) {
            fieldTypeList = Arrays.asList(fieldTypes.split(","));
        }
        List<Object> transferTypeList = new ArrayList();
        if (StringUtils.isNotBlank((String)transferTypes)) {
            transferTypeList = Arrays.asList(transferTypes.split(","));
        }
        Integer offset = (page - 1) * pageSize;
        JSONObject json = this.transferLandInfoService.queryTransferList0(offset, pageSize, regionList, fieldTypeList, transferTypeList, areaTypes, yearTypes, lowPrice, highPrice, search, platform, statusType);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/all-list1"})
    @ApiOperation(value="\u4fe1\u606f\u5217\u8868-\u9700")
    public Object queryTransferList1(@RequestParam(name="regionCodes", defaultValue="", required=false) String regionCodes, @RequestParam(name="fieldTypes", defaultValue="", required=false) String fieldTypes, @RequestParam(name="transferTypes", defaultValue="", required=false) String transferTypes, @RequestParam(required=false, value="yearTypes", defaultValue="") String yearTypes, @RequestParam(name="search", defaultValue="", required=false) String search, @RequestParam(name="platform", required=false) Integer platform, @RequestParam(name="statusType", defaultValue="1", required=false) Integer statusType, @RequestParam(name="page", defaultValue="1", required=false) Integer page, @RequestParam(name="pageSize", defaultValue="100", required=false) Integer pageSize) {
        List<Object> regionList = new ArrayList();
        if (StringUtils.isNotBlank((String)regionCodes)) {
            regionList = Arrays.asList(regionCodes.split(","));
        }
        List<Object> fieldTypeList = new ArrayList();
        if (StringUtils.isNotBlank((String)fieldTypes)) {
            fieldTypeList = Arrays.asList(fieldTypes.split(","));
        }
        List<Object> transferTypeList = new ArrayList();
        if (StringUtils.isNotBlank((String)transferTypes)) {
            transferTypeList = Arrays.asList(transferTypes.split(","));
        }
        Integer offset = (page - 1) * pageSize;
        JSONObject json = this.transferLandInfoService.queryTransferList1(offset, pageSize, regionList, fieldTypeList, yearTypes, search, platform, statusType, transferTypeList);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/trade-list"})
    @ApiOperation(value="\u6210\u4ea4\u8bb0\u5f55\u5217\u8868")
    public Object queryTradeList(@RequestParam(name="fieldTypes", defaultValue="", required=false) String fieldTypes, @RequestParam(name="transferTypes", defaultValue="", required=false) String transferTypes, @RequestParam(name="search", defaultValue="", required=false) String search, @RequestParam(name="page", defaultValue="1", required=false) Integer page, @RequestParam(name="pageSize", defaultValue="100", required=false) Integer pageSize) {
        List<Object> fieldTypeList = new ArrayList();
        if (StringUtils.isNotBlank((String)fieldTypes)) {
            fieldTypeList = Arrays.asList(fieldTypes.split(","));
        }
        List<Object> transferTypeList = new ArrayList();
        if (StringUtils.isNotBlank((String)transferTypes)) {
            transferTypeList = Arrays.asList(transferTypes.split(","));
        }
        Integer offset = (page - 1) * pageSize;
        JSONObject json = this.transferLandInfoService.queryTradeList(offset, pageSize, fieldTypeList, transferTypeList, search);
        return ResultVo.success((Object)json);
    }

    @GetMapping(value={"/statistics"})
    @ApiOperation(value="\u6570\u636e\u7edf\u8ba1")
    public ResultVo queryTransferLandStatisticsInfo(@RequestParam(value="fieldTypes", required=false, defaultValue="") String fieldTypes, @RequestParam(value="transferTypes", required=false, defaultValue="") String transferTypes, @RequestParam(value="transferYears", required=false, defaultValue="") String transferYears, @RequestParam(value="regionCodes", required=false, defaultValue="") String regionCodes, @RequestParam(value="startTime", required=false, defaultValue="") String startTime, @RequestParam(value="endTime", required=false, defaultValue="") String endTime, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        List<Object> fieldTypeList = fieldTypes.equals("") ? new ArrayList() : Arrays.asList(fieldTypes.split(","));
        List<Object> transferTypeList = transferTypes.equals("") ? new ArrayList() : Arrays.asList(transferTypes.split(","));
        List<Object> transferYearList = transferYears.equals("") ? new ArrayList() : Arrays.asList(transferYears.split(","));
        List<Object> regionCodeList = regionCodes.equals("") ? new ArrayList() : Arrays.asList(regionCodes.split(","));
        return ResultVo.success((Object)this.transferLandInfoService.queryTransferLandStatisticsInfo(fieldTypeList, transferTypeList, transferYearList, regionCodeList, startTime, endTime, start, pageSize));
    }

    @GetMapping(value={"/statistics/export"})
    @ApiOperation(value="\u6570\u636e\u7edf\u8ba1\u5bfc\u51fa")
    public void exportTransferLandStatisticsInfo(HttpServletResponse response, @RequestParam(value="fieldTypes", required=false, defaultValue="") String fieldTypes, @RequestParam(value="transferTypes", required=false, defaultValue="") String transferTypes, @RequestParam(value="transferYears", required=false, defaultValue="") String transferYears, @RequestParam(value="regionCodes", required=false, defaultValue="") String regionCodes, @RequestParam(value="startTime", required=false, defaultValue="") String startTime, @RequestParam(value="endTime", required=false, defaultValue="") String endTime) throws IOException {
        List<Object> fieldTypeList = fieldTypes.equals("") ? new ArrayList() : Arrays.asList(fieldTypes.split(","));
        List<Object> transferTypeList = transferTypes.equals("") ? new ArrayList() : Arrays.asList(transferTypes.split(","));
        List<Object> transferYearList = transferYears.equals("") ? new ArrayList() : Arrays.asList(transferYears.split(","));
        List<Object> regionCodeList = regionCodes.equals("") ? new ArrayList() : Arrays.asList(regionCodes.split(","));
        this.transferLandInfoService.exportTransferLandStatisticsInfo(response, fieldTypeList, transferTypeList, transferYearList, regionCodeList, startTime, endTime);
    }
}

