/*
 * Decompiled with CFR 0.152.
 */
package com.farm.controller.transfer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.farm.bean.TransferNews;
import com.farm.service.TransferNewsService;
import com.farm.util.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/transfer-news"})
@Api(tags={"\u571f\u5730\u6d41\u8f6c\u653f\u7b56"})
public class TransferNewsController {
    @Autowired
    private TransferNewsService transferNewsService;

    @PostMapping(value={"/upsert"})
    @ApiOperation(value="\u65b0\u589e/\u4fee\u6539")
    public ResultVo upsertTransferNews(@RequestBody String body) {
        TransferNews transferNews = (TransferNews)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), TransferNews.class);
        if (transferNews.getId() == null) {
            this.transferNewsService.insert(transferNews);
        } else {
            this.transferNewsService.update(transferNews);
        }
        return ResultVo.success();
    }

    @PostMapping(value={"/del"})
    @ApiOperation(value="\u7f6e\u9876/\u505c\u7528/\u5220\u9664")
    public ResultVo topDisableDelTransferNews(@RequestParam(value="id") Integer id, @RequestParam(value="type", required=false) Integer type, @RequestParam(value="top", required=false) Integer top, @RequestParam(value="status", required=false) Integer status) {
        this.transferNewsService.topDisableDelTransferNews(id, type, top, status);
        return ResultVo.success();
    }

    @GetMapping(value={"/detail"})
    @ApiOperation(value="\u653f\u7b56\u8be6\u60c5")
    public ResultVo queryTransferNewsDetail(@RequestParam(value="id") Integer id) {
        return ResultVo.success((Object)this.transferNewsService.queryTransferNewsDetail(id));
    }

    @GetMapping(value={"/page"})
    @ApiOperation(value="\u6761\u4ef6\u5206\u9875")
    public ResultVo queryTransferNewsPage(@RequestParam(value="title", required=false, defaultValue="") String title, @RequestParam(value="status", required=false) Integer status, @RequestParam(value="page", required=false, defaultValue="1") Integer page, @RequestParam(value="pageSize", required=false, defaultValue="20") Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        return ResultVo.success((Object)this.transferNewsService.queryTransferNewsPage(title, status, start, pageSize));
    }
}

