/*
 * Decompiled with CFR 0.152.
 */
package com.farm.handler;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.farm.bean.FertilizationPlanExcel;
import com.farm.service.impl.ImportExcelService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MultiHeadDataListener<T>
extends AnalysisEventListener<T> {
    private static final Logger log = LoggerFactory.getLogger(MultiHeadDataListener.class);
    private final ImportExcelService saveImportExcelService = (ImportExcelService)SpringUtil.getBean(ImportExcelService.class);
    private static final List<FertilizationPlanExcel> fertilizationPlanList = new ArrayList();

    public void invoke(T data, AnalysisContext context) {
        if (data instanceof FertilizationPlanExcel) {
            FertilizationPlanExcel entity = (FertilizationPlanExcel)data;
            if (StrUtil.isNotBlank((CharSequence)entity.getUserName())) {
                fertilizationPlanList.add(entity);
            }
        } else {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u9002\u914d\u7684\u6a21\u7248\uff01");
        }
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        if (CollUtil.isNotEmpty((Collection)fertilizationPlanList)) {
            try {
                this.saveImportExcelService.importExcel(fertilizationPlanList);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                fertilizationPlanList.clear();
            }
        }
    }
}

