/*
 * Decompiled with CFR 0.152.
 */
package com.farm.service.impl;

import com.farm.bean.AgriservMachineEx;
import com.farm.bean.AgriserveMachineInspect;
import com.farm.bean.AgriserveMachineInspectImport;
import com.farm.bean.AgriserveMachineWarningLog;
import com.farm.bean.Warning;
import com.farm.mapper.AgriculturalMachineInspectMapper;
import com.farm.mapper.AgriserveMachineMapper;
import com.farm.mapper.WarningMapper;
import com.farm.service.AgriculturalMachineService;
import com.farm.util.ResultVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class AgriculturalMachineServiceImpl
implements AgriculturalMachineService {
    @Autowired
    private AgriculturalMachineInspectMapper agriculturalMachineInspectMapper;
    @Autowired
    private AgriserveMachineMapper agriserveMachineMapper;
    @Autowired
    private WarningMapper warningMapper;

    public List<AgriserveMachineInspect> readAll(String engineNumber, String frameNumber, Integer roleLevel, String searchWord, Integer status, Integer state, Integer type, Integer page, Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        List list = this.agriculturalMachineInspectMapper.readAll(engineNumber, frameNumber, searchWord, status, state, type, start, pageSize);
        if (!CollectionUtils.isEmpty((Collection)list) && list.size() > 0) {
            list.forEach(inspect -> {
                AgriserveMachineInspect agriserveMachineInspect = this.agriculturalMachineInspectMapper.getByMachineId(inspect.getId());
                if (ObjectUtils.isNotEmpty((Object)agriserveMachineInspect)) {
                    inspect.setVoucher(agriserveMachineInspect.getVoucher());
                    inspect.setInspectCompany(agriserveMachineInspect.getInspectCompany());
                    inspect.setInspection(agriserveMachineInspect.getInspection());
                }
            });
        }
        return list;
    }

    public long readAllCount(Integer level, String searchWord, Integer status, Integer state, Integer type, Integer page, Integer pageSize) {
        Integer start = (page - 1) * pageSize;
        return this.agriculturalMachineInspectMapper.readAllCount(searchWord, status, state, type, start, pageSize);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Transactional
    public ResultVo add(AgriserveMachineInspect inspect) {
        if (Objects.isNull(inspect.getId())) {
            if (!Objects.isNull(inspect.getType())) {
                Integer isExist;
                if (inspect.getType() == 1) {
                    if (!StringUtils.isNotBlank((CharSequence)inspect.getEngineNumber())) return ResultVo.error((String)"\u53d1\u52a8\u673a\u53f7\u8bf7\u586b\u5199");
                    isExist = this.agriserveMachineMapper.getByCarNumber(inspect.getEngineNumber(), Integer.valueOf(0));
                    if (isExist > 0) {
                        return ResultVo.error((String)"\u5f53\u524d\u519c\u673a\u5df2\u7ecf\u5b58\u5728");
                    }
                } else {
                    if (!StringUtils.isNotBlank((CharSequence)inspect.getFrameNumber())) return ResultVo.error((String)"\u5e95\u76d8\u673a\u67b6\u53f7\u8bf7\u586b\u5199");
                    isExist = this.agriserveMachineMapper.getByCarNumber(inspect.getFrameNumber(), Integer.valueOf(1));
                    if (isExist > 0) {
                        return ResultVo.error((String)"\u5f53\u524d\u519c\u673a\u5df2\u7ecf\u5b58\u5728");
                    }
                }
            }
            ArrayList<AgriserveMachineInspectImport> list = new ArrayList<AgriserveMachineInspectImport>();
            AgriserveMachineInspectImport machine = new AgriserveMachineInspectImport();
            BeanUtils.copyProperties((Object)inspect, (Object)machine);
            list.add(machine);
            this.agriserveMachineMapper.batchInsertMachine(list);
            List collect = list.stream().map(a -> {
                AgriservMachineEx ex = new AgriservMachineEx();
                ex.setMachineId(a.getId());
                ex.setInspection(a.getInspection());
                ex.setIsInspect(Integer.valueOf(1));
                ex.setIsSign(Integer.valueOf(0));
                ex.setVoucher(a.getVoucher());
                ex.setInspectCompany(a.getInspectCompany());
                return ex;
            }).collect(Collectors.toList());
            this.agriserveMachineMapper.batchInsertMachineEx(collect);
            Warning warning = new Warning();
            warning.setStatus(Integer.valueOf(0));
            warning.setCompany("\u519c\u673a\u53d1\u5c55\u4e2d\u5fc3");
            warning.setLeader("\u65b9\u8d85");
            warning.setWarningType(Integer.valueOf(machine.getType() == 0 || machine.getType() == 2 ? 2 : 1));
            warning.setRelId(machine.getId().toString());
            warning.setContent((machine.getType() == 0 ? "\u62d6\u62c9\u673a" : (machine.getType() == 1 ? "\u63d2\u79e7\u673a" : (machine.getType() == 2 ? "\u6536\u5272\u673a" : (machine.getType() == 3 ? "\u70d8\u5e72\u673a" : "\u65e0\u4eba\u673a")))) + machine.getFrameNumber() + "\u5df2\u7ecf\u8d85\u8fc7\u4e00\u5e74\u672a\u5e74\u68c0");
            warning.setModule(Integer.valueOf(6));
            warning.setRule(Integer.valueOf(machine.getType() == 0 || machine.getType() == 2 ? 1 : 2));
            this.warningMapper.insertOne(warning);
            AgriserveMachineWarningLog log = new AgriserveMachineWarningLog();
            log.setRelId(Integer.valueOf(warning.getId()));
            log.setRelUnit(inspect.getRelUnit());
            log.setTitle("\u7b2c\u4e09\u65b9\u63d0\u4ea4\u5e74\u68c0\u51ed\u8bc1");
            log.setResponsibility(inspect.getResponsibility());
            log.setPhone(inspect.getResponsibilityPhone());
            this.warningMapper.insert(log);
            return ResultVo.success((Object)"\u64cd\u4f5c\u6210\u529f");
        } else {
            this.agriserveMachineMapper.updateMachineInfo(inspect);
        }
        return ResultVo.success((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    @Transactional
    public void update(String list, String voucher, String phone, Integer isInspect, Integer isSign, String relUnit, String solution, String responsibility, String machineImages, String nameplateImages, String inspectCompany, String inspection) {
        String[] split = list.split(",");
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (String s : split) {
            int num = Integer.parseInt(s);
            ids.add(num);
        }
        this.agriculturalMachineInspectMapper.update(ids, voucher, isInspect, isSign, machineImages, nameplateImages, inspectCompany, inspection);
        List warnings = this.warningMapper.readById(ids);
        if (!CollectionUtils.isEmpty((Collection)warnings)) {
            for (Warning warning : warnings) {
                AgriserveMachineWarningLog warningLog = new AgriserveMachineWarningLog();
                warningLog.setRelId(Integer.valueOf(Integer.parseInt(warning.getId())));
                warningLog.setRelUnit(relUnit);
                warningLog.setResponsibility(responsibility);
                warningLog.setPhone(phone);
                warningLog.setSolution(solution);
                if (!Objects.isNull(isInspect) && isInspect == 1) {
                    warningLog.setTitle("\u7b2c\u4e09\u65b9\u63d0\u4ea4\u5e74\u68c0\u51ed\u8bc1");
                    this.warningMapper.updateOne(warning.getId(), Integer.valueOf(0), Integer.valueOf(0));
                } else {
                    warningLog.setTitle("\u519c\u4e1a\u519c\u6751\u5c40\u9a8c\u6536\u5ba1\u6838:\u901a\u8fc7");
                    this.warningMapper.updateOne(warning.getId(), Integer.valueOf(1), Integer.valueOf(1));
                }
                this.warningMapper.insert(warningLog);
            }
        }
    }

    public Map<String, String> readCount(String searchWord, Integer type) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 1; i <= 4; ++i) {
            String num = this.agriculturalMachineInspectMapper.readCount(type, searchWord, Integer.valueOf(i));
            map.put(i == 1 ? "\u672a\u5e74\u68c0" : (i == 2 ? "\u5df2\u5e74\u68c0" : (i == 3 ? "\u5f85\u9a8c\u6536" : "\u5df2\u9a8c\u6536")), num);
        }
        return map;
    }

    @Transactional
    public ResultVo updateInfo(AgriserveMachineInspect inspect) {
        this.agriserveMachineMapper.updateInfo(inspect);
        this.agriculturalMachineInspectMapper.updateInfo(inspect);
        return ResultVo.success();
    }
}

